/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index.impl;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Set;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.commons.codec.binary.Hex;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.binding.artifact.SAMLArtifact;
import org.opensaml.saml.common.binding.artifact.SAMLSourceIDArtifact;
import org.opensaml.saml.common.binding.artifact.SAMLSourceLocationArtifact;
import org.opensaml.saml.criterion.ArtifactCriterion;
import org.opensaml.saml.ext.saml1md.SourceID;
import org.opensaml.saml.metadata.resolver.index.MetadataIndexKey;
import org.opensaml.saml.metadata.resolver.index.impl.SAMLArtifactMetadataIndex;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0002;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAMLArtifactMetadataIndexTest
extends XMLObjectBaseTestCase {
    private SAMLArtifactMetadataIndex metadataIndex;
    private String entityID = "https://www.example.com/saml";
    private byte[] entityIDSourceID;
    private String sourceLocation1 = "https://www.example.com/saml/artifactResolve1";
    private String sourceLocation2 = "https://www.example.com/saml/artifactResolve2";
    private EntityDescriptor descriptor;
    private SourceID extSourceID1a;
    private SourceID extSourceID1b;
    private SourceID extSourceID2;
    private MetadataIndexKey entityIDSourceIDKey;
    private MetadataIndexKey extSourceIDKey1a;
    private MetadataIndexKey extSourceIDKey1b;
    private MetadataIndexKey extSourceIDKey2;
    private MetadataIndexKey sourceLocationKey1;
    private MetadataIndexKey sourceLocationKey2;
    private SAMLSourceIDArtifact sourceIDArtifact;
    private SAMLSourceLocationArtifact sourceLocationArtifact1;

    @BeforeMethod
    protected void setUp() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        this.metadataIndex = new SAMLArtifactMetadataIndex();
        MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
        this.entityIDSourceID = sha1Digester.digest(this.entityID.getBytes("UTF-8"));
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        byte[] messageHandle = new byte[20];
        secureRandom.nextBytes(messageHandle);
        this.sourceIDArtifact = new SAML2ArtifactType0004(new byte[]{0, 0}, this.entityIDSourceID, messageHandle);
        this.entityIDSourceIDKey = new SAMLArtifactMetadataIndex.ArtifactSourceIDMetadataIndexKey(this.entityIDSourceID);
        this.sourceLocationArtifact1 = new SAML1ArtifactType0002(messageHandle, this.sourceLocation1);
        this.descriptor = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.descriptor.setEntityID(this.entityID);
        this.sourceLocationKey1 = new SAMLArtifactMetadataIndex.ArtifactSourceLocationMetadataIndexKey(this.sourceLocation1);
        this.sourceLocationKey2 = new SAMLArtifactMetadataIndex.ArtifactSourceLocationMetadataIndexKey(this.sourceLocation2);
        byte[] secondarySourceID = new byte[20];
        secureRandom.nextBytes(secondarySourceID);
        this.extSourceIDKey1a = new SAMLArtifactMetadataIndex.ArtifactSourceIDMetadataIndexKey(secondarySourceID);
        this.extSourceID1a = (SourceID)this.buildXMLObject(SourceID.DEFAULT_ELEMENT_NAME);
        this.extSourceID1a.setValue(new String(Hex.encodeHex((byte[])secondarySourceID, (boolean)true)));
        secondarySourceID = new byte[20];
        secureRandom.nextBytes(secondarySourceID);
        this.extSourceIDKey1b = new SAMLArtifactMetadataIndex.ArtifactSourceIDMetadataIndexKey(secondarySourceID);
        this.extSourceID1b = (SourceID)this.buildXMLObject(SourceID.DEFAULT_ELEMENT_NAME);
        this.extSourceID1b.setValue(new String(Hex.encodeHex((byte[])secondarySourceID, (boolean)true)));
        secondarySourceID = new byte[20];
        secureRandom.nextBytes(secondarySourceID);
        this.extSourceIDKey2 = new SAMLArtifactMetadataIndex.ArtifactSourceIDMetadataIndexKey(secondarySourceID);
        this.extSourceID2 = (SourceID)this.buildXMLObject(SourceID.DEFAULT_ELEMENT_NAME);
        this.extSourceID2.setValue(new String(Hex.encodeHex((byte[])secondarySourceID, (boolean)true)));
    }

    @Test
    public void testGenerateKeysFromDescriptorEntityIDOnly() {
        Set keys = this.metadataIndex.generateKeys(this.descriptor);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.entityIDSourceIDKey));
    }

    @Test
    public void testGenerateKeysFromDescriptorWithOneARS() {
        SSODescriptor roleDescriptor1 = (SSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        ArtifactResolutionService ars1 = (ArtifactResolutionService)this.buildXMLObject(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        ars1.setLocation(this.sourceLocation1);
        ars1.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        roleDescriptor1.getArtifactResolutionServices().add(ars1);
        this.descriptor.getRoleDescriptors().add(roleDescriptor1);
        Set keys = this.metadataIndex.generateKeys(this.descriptor);
        Assert.assertEquals((int)keys.size(), (int)2);
        Assert.assertTrue((boolean)keys.contains(this.entityIDSourceIDKey));
        Assert.assertTrue((boolean)keys.contains(this.sourceLocationKey1));
    }

    @Test
    public void testGenerateKeysFromDescriptorWithMultipleARS() {
        SSODescriptor roleDescriptor1 = (SSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        ArtifactResolutionService ars1 = (ArtifactResolutionService)this.buildXMLObject(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        ars1.setLocation(this.sourceLocation1);
        ars1.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        roleDescriptor1.getArtifactResolutionServices().add(ars1);
        this.descriptor.getRoleDescriptors().add(roleDescriptor1);
        SSODescriptor roleDescriptor2 = (SSODescriptor)this.buildXMLObject(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        ArtifactResolutionService ars2 = (ArtifactResolutionService)this.buildXMLObject(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        ars2.setLocation(this.sourceLocation2);
        ars2.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        roleDescriptor2.getArtifactResolutionServices().add(ars2);
        this.descriptor.getRoleDescriptors().add(roleDescriptor2);
        Set keys = this.metadataIndex.generateKeys(this.descriptor);
        Assert.assertEquals((int)keys.size(), (int)3);
        Assert.assertTrue((boolean)keys.contains(this.entityIDSourceIDKey));
        Assert.assertTrue((boolean)keys.contains(this.sourceLocationKey1));
        Assert.assertTrue((boolean)keys.contains(this.sourceLocationKey2));
    }

    @Test
    public void testGenerateKeysFromDescriptorWithOneExtension() {
        RoleDescriptor roleDescriptor1 = (RoleDescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        Extensions extensions1 = (Extensions)this.buildXMLObject(Extensions.DEFAULT_ELEMENT_NAME);
        extensions1.getUnknownXMLObjects().add(this.extSourceID1a);
        roleDescriptor1.setExtensions(extensions1);
        this.descriptor.getRoleDescriptors().add(roleDescriptor1);
        Set keys = this.metadataIndex.generateKeys(this.descriptor);
        Assert.assertEquals((int)keys.size(), (int)2);
        Assert.assertTrue((boolean)keys.contains(this.entityIDSourceIDKey));
        Assert.assertTrue((boolean)keys.contains(this.extSourceIDKey1a));
    }

    @Test
    public void testGenerateKeysFromDescriptorWithMultipleExtensions() {
        RoleDescriptor roleDescriptor1 = (RoleDescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        Extensions extensions1 = (Extensions)this.buildXMLObject(Extensions.DEFAULT_ELEMENT_NAME);
        extensions1.getUnknownXMLObjects().add(this.extSourceID1a);
        extensions1.getUnknownXMLObjects().add(this.extSourceID1b);
        roleDescriptor1.setExtensions(extensions1);
        this.descriptor.getRoleDescriptors().add(roleDescriptor1);
        RoleDescriptor roleDescriptor2 = (RoleDescriptor)this.buildXMLObject(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        Extensions extensions2 = (Extensions)this.buildXMLObject(Extensions.DEFAULT_ELEMENT_NAME);
        extensions2.getUnknownXMLObjects().add(this.extSourceID2);
        roleDescriptor2.setExtensions(extensions2);
        this.descriptor.getRoleDescriptors().add(roleDescriptor2);
        Set keys = this.metadataIndex.generateKeys(this.descriptor);
        Assert.assertEquals((int)keys.size(), (int)4);
        Assert.assertTrue((boolean)keys.contains(this.entityIDSourceIDKey));
        Assert.assertTrue((boolean)keys.contains(this.extSourceIDKey1a));
        Assert.assertTrue((boolean)keys.contains(this.extSourceIDKey1b));
        Assert.assertTrue((boolean)keys.contains(this.extSourceIDKey2));
    }

    @Test
    public void testGenerateKeysFromDescriptorWithExtensionAndARS() {
        SSODescriptor roleDescriptor1 = (SSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        Extensions extensions1 = (Extensions)this.buildXMLObject(Extensions.DEFAULT_ELEMENT_NAME);
        extensions1.getUnknownXMLObjects().add(this.extSourceID1a);
        roleDescriptor1.setExtensions(extensions1);
        ArtifactResolutionService ars1 = (ArtifactResolutionService)this.buildXMLObject(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        ars1.setLocation(this.sourceLocation1);
        ars1.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        roleDescriptor1.getArtifactResolutionServices().add(ars1);
        this.descriptor.getRoleDescriptors().add(roleDescriptor1);
        Set keys = this.metadataIndex.generateKeys(this.descriptor);
        Assert.assertEquals((int)keys.size(), (int)3);
        Assert.assertTrue((boolean)keys.contains(this.entityIDSourceIDKey));
        Assert.assertTrue((boolean)keys.contains(this.extSourceIDKey1a));
        Assert.assertTrue((boolean)keys.contains(this.sourceLocationKey1));
    }

    @Test
    public void testGenerateSourceIDKeysFromCriteria() {
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new ArtifactCriterion((SAMLArtifact)this.sourceIDArtifact));
        Set keys = this.metadataIndex.generateKeys(criteriaSet);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.entityIDSourceIDKey));
    }

    @Test
    public void testGenerateSourceLocationKeysFromCriteria() {
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new ArtifactCriterion((SAMLArtifact)this.sourceLocationArtifact1));
        Set keys = this.metadataIndex.generateKeys(criteriaSet);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.sourceLocationKey1));
    }

    @Test
    public void testSourceIDKey() throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
        SAMLArtifactMetadataIndex.ArtifactSourceIDMetadataIndexKey keySame = new SAMLArtifactMetadataIndex.ArtifactSourceIDMetadataIndexKey(sha1Digester.digest(this.entityID.getBytes("UTF-8")));
        sha1Digester.reset();
        SAMLArtifactMetadataIndex.ArtifactSourceIDMetadataIndexKey keyDifferent = new SAMLArtifactMetadataIndex.ArtifactSourceIDMetadataIndexKey(sha1Digester.digest("foobar".getBytes("UTF-8")));
        Assert.assertEquals((Object)this.entityIDSourceIDKey, (Object)keySame);
        Assert.assertTrue((this.entityIDSourceIDKey.hashCode() == keySame.hashCode() ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)this.entityIDSourceIDKey, (Object)keyDifferent);
    }

    @Test
    public void testSourceLocationKey() throws UnsupportedEncodingException, NoSuchAlgorithmException {
        SAMLArtifactMetadataIndex.ArtifactSourceLocationMetadataIndexKey keySame = new SAMLArtifactMetadataIndex.ArtifactSourceLocationMetadataIndexKey(this.sourceLocation1);
        SAMLArtifactMetadataIndex.ArtifactSourceLocationMetadataIndexKey keySameCanonicalized = new SAMLArtifactMetadataIndex.ArtifactSourceLocationMetadataIndexKey("HTTPS://WWW.EXAMPLE.COM:443/saml/artifactResolve1?foo=x&bar=y#someFragment");
        SAMLArtifactMetadataIndex.ArtifactSourceLocationMetadataIndexKey keyDifferent = new SAMLArtifactMetadataIndex.ArtifactSourceLocationMetadataIndexKey("https://bogus.example.org/sp");
        Assert.assertEquals((Object)this.sourceLocationKey1, (Object)keySame);
        Assert.assertTrue((this.sourceLocationKey1.hashCode() == keySame.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.sourceLocationKey1, (Object)keySameCanonicalized);
        Assert.assertTrue((this.sourceLocationKey1.hashCode() == keySameCanonicalized.hashCode() ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)this.sourceLocationKey1, (Object)keyDifferent);
    }
}

