/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml1.core.AuthenticationQuery;
import org.opensaml.saml.saml1.core.Subject;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthenticationQueryTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String expectedAuthenticationMethod;

    public AuthenticationQueryTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAuthenticationQuery.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAuthenticationQueryAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/AuthenticationQueryWithChildren.xml";
        this.expectedAuthenticationMethod = "Trust Me";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery", "saml1p");
    }

    @Test
    public void testSingleElementUnmarshall() {
        AuthenticationQuery authenticationQuery = (AuthenticationQuery)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)authenticationQuery.getAuthenticationMethod(), (String)"AuthenticationQuery attribute present");
        Assert.assertNull((Object)authenticationQuery.getSubject(), (String)"Subject element present");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthenticationQuery authenticationQuery = (AuthenticationQuery)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)authenticationQuery.getAuthenticationMethod(), (String)this.expectedAuthenticationMethod, (String)"AuthenticationQuery attribute");
        Assert.assertNull((Object)authenticationQuery.getSubject(), (String)"Subject element present");
    }

    @Test
    public void testChildElementsUnmarshall() {
        AuthenticationQuery authenticationQuery = (AuthenticationQuery)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)authenticationQuery.getSubject(), (String)"No Subject element found");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AuthenticationQuery authenticationQuery = (AuthenticationQuery)this.buildXMLObject(this.qname);
        authenticationQuery.setAuthenticationMethod(this.expectedAuthenticationMethod);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)authenticationQuery);
    }

    @Test
    public void testChildElementsMarshall() {
        AuthenticationQuery authenticationQuery = (AuthenticationQuery)this.buildXMLObject(this.qname);
        authenticationQuery.setSubject((Subject)this.buildXMLObject(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Subject", "saml1")));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)authenticationQuery);
    }
}

