/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml1.core.SubjectLocality;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SubjectLocalityTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String expectedIPAddress;
    private final String expectedDNSAddress;

    public SubjectLocalityTest() {
        this.expectedIPAddress = "207.75.164.30";
        this.expectedDNSAddress = "shibboleth.internet2.edu";
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleSubjectLocality.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleSubjectLocalityAttributes.xml";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        SubjectLocality subjectLocality = (SubjectLocality)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)subjectLocality.getIPAddress(), (String)"IPAddress present");
        Assert.assertNull((Object)subjectLocality.getDNSAddress(), (String)"DNSAddress present");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        SubjectLocality subjectLocality = (SubjectLocality)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)subjectLocality.getIPAddress(), (String)this.expectedIPAddress, (String)"IPAddress");
        Assert.assertEquals((String)subjectLocality.getDNSAddress(), (String)this.expectedDNSAddress, (String)"DNSAddress");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        SubjectLocality subjectLocality = (SubjectLocality)this.buildXMLObject(this.qname);
        subjectLocality.setDNSAddress(this.expectedDNSAddress);
        subjectLocality.setIPAddress(this.expectedIPAddress);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)subjectLocality);
    }
}

