/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.profile.AbstractSAML1NameIdentifierGenerator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractSAML1NameIdentifierGeneratorTest
extends OpenSAMLInitBaseTestCase {
    private static final String NAME_QUALIFIER = "https://idp.example.org";

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoFormat() throws ComponentInitializationException {
        MockSAML1NameIdentifierGenerator mock = new MockSAML1NameIdentifierGenerator();
        mock.initialize();
    }

    @Test
    public void testFull() throws ComponentInitializationException, SAMLException {
        MockSAML1NameIdentifierGenerator mock = new MockSAML1NameIdentifierGenerator();
        mock.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        mock.setIdPNameQualifier(NAME_QUALIFIER);
        mock.initialize();
        NameIdentifier nameId = (NameIdentifier)mock.generate(new ProfileRequestContext(), mock.getFormat());
        Assert.assertNotNull((Object)nameId);
        Assert.assertEquals((String)nameId.getValue(), (String)"foo");
        Assert.assertEquals((String)nameId.getNameQualifier(), (String)NAME_QUALIFIER);
    }

    @Test
    public void testOmitSet() throws ComponentInitializationException, SAMLException {
        MockSAML1NameIdentifierGenerator mock = new MockSAML1NameIdentifierGenerator();
        mock.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        mock.setIdPNameQualifier(NAME_QUALIFIER);
        mock.setOmitQualifiers(true);
        mock.initialize();
        NameIdentifier nameId = (NameIdentifier)mock.generate(new ProfileRequestContext(), mock.getFormat());
        Assert.assertNotNull((Object)nameId);
        Assert.assertEquals((String)nameId.getValue(), (String)"foo");
        Assert.assertNull((Object)nameId.getNameQualifier());
    }

    @Test
    public void testOmitUnset() throws ComponentInitializationException, SAMLException {
        MockSAML1NameIdentifierGenerator mock = new MockSAML1NameIdentifierGenerator();
        mock.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        mock.setOmitQualifiers(true);
        mock.initialize();
        NameIdentifier nameId = (NameIdentifier)mock.generate(new ProfileRequestContext(), mock.getFormat());
        Assert.assertNotNull((Object)nameId);
        Assert.assertEquals((String)nameId.getValue(), (String)"foo");
        Assert.assertNull((Object)nameId.getNameQualifier());
    }

    @Test
    public void testDefaultQualifier() throws ComponentInitializationException, SAMLException {
        MockSAML1NameIdentifierGenerator mock = new MockSAML1NameIdentifierGenerator();
        mock.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        mock.initialize();
        NameIdentifier nameId = (NameIdentifier)mock.generate(new ProfileRequestContext(), mock.getFormat());
        Assert.assertNotNull((Object)nameId);
        Assert.assertEquals((String)nameId.getValue(), (String)"foo");
        Assert.assertEquals((String)nameId.getNameQualifier(), (String)NAME_QUALIFIER);
    }

    private class MockSAML1NameIdentifierGenerator
    extends AbstractSAML1NameIdentifierGenerator {
        public MockSAML1NameIdentifierGenerator() {
            this.setId("test");
            this.setDefaultIdPNameQualifierLookupStrategy(FunctionSupport.constant((Object)AbstractSAML1NameIdentifierGeneratorTest.NAME_QUALIFIER));
        }

        protected String getIdentifier(ProfileRequestContext profileRequestContext) throws SAMLException {
            return "foo";
        }
    }
}

