/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.profile.impl;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.profile.NameIdentifierGenerator;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.profile.AbstractSAML1NameIdentifierGenerator;
import org.opensaml.saml.saml1.profile.SAML1NameIdentifierGenerator;
import org.opensaml.saml.saml1.profile.impl.AddNameIdentifierToSubjects;
import org.opensaml.saml.saml1.profile.impl.ChainingSAML1NameIdentifierGenerator;
import org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddNameIdentifierToSubjectsTest
extends OpenSAMLInitBaseTestCase {
    private static final String NAME_QUALIFIER = "https://idp.example.org";
    private ChainingSAML1NameIdentifierGenerator generator;
    private ProfileRequestContext prc;
    private AddNameIdentifierToSubjects action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new AddNameIdentifierToSubjects();
        MockSAML1NameIdentifierGenerator mock = new MockSAML1NameIdentifierGenerator("foo");
        mock.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        mock.initialize();
        MockSAML1NameIdentifierGenerator mock2 = new MockSAML1NameIdentifierGenerator("bar");
        mock2.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        mock2.setActivationCondition((Predicate)Predicates.alwaysFalse());
        mock2.initialize();
        MockSAML1NameIdentifierGenerator mock3 = new MockSAML1NameIdentifierGenerator("baz");
        mock3.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        mock3.initialize();
        this.generator = new ChainingSAML1NameIdentifierGenerator();
        this.generator.setGenerators(Arrays.asList(new NameIdentifierGenerator[]{mock, mock2, mock3}));
        this.action.setNameIdentifierGenerator((SAML1NameIdentifierGenerator)this.generator);
    }

    @Test
    public void testNoMessage() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getMessage());
    }

    @Test
    public void testNoAssertions() throws ComponentInitializationException {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildResponse());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertTrue((boolean)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().isEmpty());
    }

    @Test
    public void testNoStatements() throws ComponentInitializationException {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildResponse());
        ((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        this.action.setFormatLookupStrategy((Function)new X509FormatLookupStrategy());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertTrue((boolean)((Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0)).getStatements().isEmpty());
    }

    @Test
    void testArbitraryFormat() throws ComponentInitializationException {
        this.addStatements();
        this.action.setNameIdentifierGenerator((SAML1NameIdentifierGenerator)this.generator);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = ((AuthenticationStatement)assertion.getAuthenticationStatements().get(0)).getSubject();
        Assert.assertNull((Object)subject);
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(1);
        subject = ((AttributeStatement)assertion.getAttributeStatements().get(0)).getSubject();
        Assert.assertNull((Object)subject);
    }

    @Test
    void testSingleGenerator() throws ComponentInitializationException {
        this.addStatements();
        this.action.setFormatLookupStrategy((Function)new X509FormatLookupStrategy());
        this.action.setNameIdentifierGenerator((SAML1NameIdentifierGenerator)this.generator);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = ((AuthenticationStatement)assertion.getAuthenticationStatements().get(0)).getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameIdentifier());
        Assert.assertEquals((String)subject.getNameIdentifier().getValue(), (String)"foo");
        Assert.assertEquals((String)subject.getNameIdentifier().getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(1);
        subject = ((AttributeStatement)assertion.getAttributeStatements().get(0)).getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameIdentifier());
        Assert.assertEquals((String)subject.getNameIdentifier().getValue(), (String)"foo");
        Assert.assertEquals((String)subject.getNameIdentifier().getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
    }

    @Test
    void testMultipleGenerators() throws ComponentInitializationException {
        this.addStatements();
        this.action.setFormatLookupStrategy((Function)new EmailFormatLookupStrategy());
        this.action.setNameIdentifierGenerator((SAML1NameIdentifierGenerator)this.generator);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = ((AuthenticationStatement)assertion.getAuthenticationStatements().get(0)).getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameIdentifier());
        Assert.assertEquals((String)subject.getNameIdentifier().getValue(), (String)"baz");
        Assert.assertEquals((String)subject.getNameIdentifier().getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(1);
        subject = ((AttributeStatement)assertion.getAttributeStatements().get(0)).getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameIdentifier());
        Assert.assertEquals((String)subject.getNameIdentifier().getValue(), (String)"baz");
        Assert.assertEquals((String)subject.getNameIdentifier().getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
    }

    private void addStatements() {
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        ((Assertion)response.getAssertions().get(0)).getAuthenticationStatements().add(SAML1ActionTestingSupport.buildAuthenticationStatement());
        ((Assertion)response.getAssertions().get(1)).getAttributeStatements().add(SAML1ActionTestingSupport.buildAttributeStatement());
        this.prc.getOutboundMessageContext().setMessage((Object)response);
    }

    private class MockSAML1NameIdentifierGenerator
    extends AbstractSAML1NameIdentifierGenerator {
        private final String identifier;

        public MockSAML1NameIdentifierGenerator(String id) {
            this.setId("test");
            this.setDefaultIdPNameQualifierLookupStrategy(new Function<ProfileRequestContext, String>(){

                @Override
                public String apply(ProfileRequestContext input) {
                    return AddNameIdentifierToSubjectsTest.NAME_QUALIFIER;
                }
            });
            this.identifier = id;
        }

        protected String getIdentifier(ProfileRequestContext profileRequestContext) throws SAMLException {
            return this.identifier;
        }
    }

    private class X509FormatLookupStrategy
    implements Function<ProfileRequestContext, List<String>> {
        private X509FormatLookupStrategy() {
        }

        @Override
        public List<String> apply(ProfileRequestContext input) {
            return Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName", "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        }
    }

    private class EmailFormatLookupStrategy
    implements Function<ProfileRequestContext, List<String>> {
        private EmailFormatLookupStrategy() {
        }

        @Override
        public List<String> apply(ProfileRequestContext input) {
            return Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        }
    }
}

