/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.impl.SenderVouchersSubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.tests.BaseAssertionValidationTest;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SenderVouchesSubjectConfirmationValidatorTest
extends BaseAssertionValidationTest {
    private SenderVouchersSubjectConfirmationValidator validator;
    private SubjectConfirmation subjectConfirmation;

    @BeforeMethod(dependsOnMethods={"setUpBasicAssertion"})
    public void setUp() {
        this.validator = new SenderVouchersSubjectConfirmationValidator();
        this.subjectConfirmation = (SubjectConfirmation)this.getAssertion().getSubject().getSubjectConfirmations().get(0);
    }

    @Test
    public void testSenderVouches() throws AssertionValidationException {
        this.subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testNonSenderVouches() throws AssertionValidationException {
        this.subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }
}

