/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.tests;

import java.net.URISyntaxException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.BearerSubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.tests.BaseAssertionValidationTest;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.saml.saml2.core.Statement;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAML20AssertionValidatorTest
extends BaseAssertionValidationTest {
    private SAML20AssertionValidator validator;
    private List<ConditionValidator> conditionValidators;
    private List<SubjectConfirmationValidator> subjectConfirmationValidators;
    private List<StatementValidator> statementValidators;
    private Set<Credential> trustedCredentials;
    private CollectionCredentialResolver credentialResolver;
    private SignatureTrustEngine signatureTrustEngine;
    private SignaturePrevalidator signaturePrevalidator;
    private X509Certificate cert1;
    private X509Certificate cert2;
    private PublicKey publicKey1;
    private PublicKey publicKey2;
    private PrivateKey privateKey1;
    private PrivateKey privateKey2;
    private Credential cred1;
    private Credential cred2;

    @BeforeClass
    protected void readCertsAndKeys() throws CertificateException, URISyntaxException, KeyException {
        this.cert1 = this.getCertificate("subject1.crt");
        this.publicKey1 = this.cert1.getPublicKey();
        this.privateKey1 = this.getPrivateKey("subject1.key");
        this.cred1 = this.getSigningCredential(this.publicKey1, this.privateKey1);
        this.cert2 = this.getCertificate("subject2.crt");
        this.publicKey2 = this.cert2.getPublicKey();
        this.privateKey2 = this.getPrivateKey("subject2.key");
        this.cred2 = this.getSigningCredential(this.publicKey2, this.privateKey2);
    }

    @BeforeMethod(dependsOnMethods={"setUpBasicAssertion"})
    protected void setUp() throws NoSuchAlgorithmException, NoSuchProviderException {
        this.conditionValidators = new ArrayList<ConditionValidator>();
        this.subjectConfirmationValidators = new ArrayList<SubjectConfirmationValidator>();
        this.statementValidators = new ArrayList<StatementValidator>();
        this.subjectConfirmationValidators.add((SubjectConfirmationValidator)new BearerSubjectConfirmationValidator());
        this.trustedCredentials = new HashSet<Credential>();
        this.credentialResolver = new CollectionCredentialResolver(this.trustedCredentials);
        this.signatureTrustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)this.credentialResolver, DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
        this.signaturePrevalidator = new SAMLSignatureProfileValidator();
    }

    @Test
    public void testNoSubjectConfirmationValidators() throws AssertionValidationException {
        this.subjectConfirmationValidators.clear();
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation"));
    }

    @Test
    public void testNoSubject() throws AssertionValidationException {
        this.getAssertion().setSubject(null);
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.VALID);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation"));
    }

    @Test
    public void testNoSubjectConfirmations() throws AssertionValidationException {
        this.getAssertion().getSubject().getSubjectConfirmations().clear();
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.VALID);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation"));
    }

    @Test
    public void testNoSignatureAndNotRequired() throws AssertionValidationException {
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.VALID);
        Assert.assertSame(validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation"), assertion.getSubject().getSubjectConfirmations().get(0));
    }

    @Test
    public void testNoSignatureAndRequired() throws AssertionValidationException {
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", true);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testWithTrustedSignature() throws AssertionValidationException, SecurityException, MarshallingException, SignatureException {
        this.trustedCredentials.add(this.cred1);
        this.signAssertion(this.getAssertion(), this.cred1);
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", true);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.VALID);
        Assert.assertSame(validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation"), assertion.getSubject().getSubjectConfirmations().get(0));
    }

    @Test
    public void testWithTrustedSignatureAndContextTrustEngine() throws AssertionValidationException, SecurityException, MarshallingException, SignatureException {
        this.trustedCredentials.add(this.cred1);
        this.signAssertion(this.getAssertion(), this.cred1);
        this.validator = new SAML20AssertionValidator(this.conditionValidators, this.subjectConfirmationValidators, this.statementValidators, null, this.signaturePrevalidator);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", true);
        staticParams.put("saml2.SignatureValidationTrustEngine", this.signatureTrustEngine);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.VALID);
        Assert.assertSame(validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation"), assertion.getSubject().getSubjectConfirmations().get(0));
    }

    @Test
    public void testWithTrustedSignatureAndContextPrevalidator() throws AssertionValidationException, SecurityException, MarshallingException, SignatureException {
        this.trustedCredentials.add(this.cred1);
        this.signAssertion(this.getAssertion(), this.cred1);
        this.validator = new SAML20AssertionValidator(this.conditionValidators, this.subjectConfirmationValidators, this.statementValidators, this.signatureTrustEngine, null);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", true);
        staticParams.put("saml2.SignatureValidationPrevalidator", this.signaturePrevalidator);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.VALID);
        Assert.assertSame(validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation"), assertion.getSubject().getSubjectConfirmations().get(0));
    }

    @Test
    public void testWithSignatureAndUntrustedCredential() throws AssertionValidationException, SecurityException, MarshallingException, SignatureException {
        this.trustedCredentials.add(this.cred2);
        this.signAssertion(this.getAssertion(), this.cred1);
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", true);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testWithSignatureNoSignatureTrustEngine() throws AssertionValidationException, SecurityException, MarshallingException, SignatureException {
        this.signAssertion(this.getAssertion(), this.cred1);
        this.validator = new SAML20AssertionValidator(this.conditionValidators, this.subjectConfirmationValidators, this.statementValidators, null, this.signaturePrevalidator);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", true);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testWithSignatureFailsSignaturePrevalidation() throws AssertionValidationException, SecurityException, MarshallingException, SignatureException {
        this.trustedCredentials.add(this.cred1);
        this.signAssertion(this.getAssertion(), this.cred1);
        SignaturePrevalidator failingValidator = new SignaturePrevalidator(){

            public void validate(@Nonnull Signature signature) throws SignatureException {
                throw new SignatureException();
            }
        };
        this.validator = new SAML20AssertionValidator(this.conditionValidators, this.subjectConfirmationValidators, this.statementValidators, this.signatureTrustEngine, failingValidator);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", true);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testWithSignatureTrustEngineFailure() throws AssertionValidationException, SecurityException, MarshallingException, SignatureException {
        this.trustedCredentials.add(this.cred1);
        this.signAssertion(this.getAssertion(), this.cred1);
        SignatureTrustEngine failingEngine = new SignatureTrustEngine(){

            public boolean validate(Signature token, CriteriaSet trustBasisCriteria) throws SecurityException {
                throw new SecurityException();
            }

            @Nullable
            public KeyInfoCredentialResolver getKeyInfoResolver() {
                return null;
            }

            public boolean validate(@Nonnull byte[] signature, @Nonnull byte[] content, @Nonnull String algorithmURI, @Nullable CriteriaSet trustBasisCriteria, @Nullable Credential candidateCredential) throws SecurityException {
                throw new SecurityException();
            }
        };
        this.validator = new SAML20AssertionValidator(this.conditionValidators, this.subjectConfirmationValidators, this.statementValidators, failingEngine, this.signaturePrevalidator);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", true);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testNoConditions() throws AssertionValidationException {
        this.getAssertion().setConditions(null);
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.VALID);
        Assert.assertSame(validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation"), assertion.getSubject().getSubjectConfirmations().get(0));
    }

    @Test
    public void testNoConditionsWithRequired() throws AssertionValidationException {
        this.getAssertion().setConditions(null);
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        staticParams.put("saml2.Conditions.RequiredConditions", Collections.singleton(MockCondition.ELEMENT_NAME));
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testConditionsWithRequiredPresent() throws AssertionValidationException {
        this.getAssertion().getConditions().getConditions().add(new MockCondition());
        this.getAssertion().getConditions().getConditions().add(new MockCondition2());
        this.conditionValidators.add(new MockConditionValidator());
        this.conditionValidators.add(new MockCondition2Validator());
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        staticParams.put("saml2.Conditions.RequiredConditions", Collections.singleton(MockCondition.ELEMENT_NAME));
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testConditionsWithRequiredMissing() throws AssertionValidationException {
        this.getAssertion().getConditions().getConditions().add(new MockCondition2());
        this.conditionValidators.add(new MockConditionValidator());
        this.conditionValidators.add(new MockCondition2Validator());
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        staticParams.put("saml2.Conditions.RequiredConditions", Collections.singleton(MockCondition.ELEMENT_NAME));
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidConditionsNotBefore() throws AssertionValidationException {
        this.getAssertion().getConditions().setNotBefore(Instant.now().plus(30L, ChronoUnit.MINUTES));
        this.getAssertion().getConditions().setNotOnOrAfter(Instant.now().plus(60L, ChronoUnit.MINUTES));
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidConditionsNotOnOrAfter() throws AssertionValidationException {
        this.getAssertion().getConditions().setNotBefore(Instant.now().minus(60L, ChronoUnit.MINUTES));
        this.getAssertion().getConditions().setNotOnOrAfter(Instant.now().minus(30L, ChronoUnit.MINUTES));
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testFailConditionValidator() throws AssertionValidationException {
        ConditionValidator failingValidator = new ConditionValidator(){

            @Nonnull
            public ValidationResult validate(@Nonnull Condition condition, @Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
                return ValidationResult.INVALID;
            }

            @Nonnull
            public QName getServicedCondition() {
                return OneTimeUse.DEFAULT_ELEMENT_NAME;
            }
        };
        this.conditionValidators.add(failingValidator);
        this.getAssertion().getConditions().getConditions().add((Condition)this.buildXMLObject(OneTimeUse.DEFAULT_ELEMENT_NAME));
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testUnknownCondition() throws AssertionValidationException {
        this.getAssertion().getConditions().getConditions().add((Condition)this.buildXMLObject(OneTimeUse.DEFAULT_ELEMENT_NAME));
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testFailStatementValidator() throws AssertionValidationException {
        StatementValidator failingValidator = new StatementValidator(){

            @Nonnull
            public QName getServicedStatement() {
                return AuthnStatement.DEFAULT_ELEMENT_NAME;
            }

            @Nonnull
            public ValidationResult validate(@Nonnull Statement statement, @Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
                return ValidationResult.INVALID;
            }
        };
        this.statementValidators.add(failingValidator);
        this.getAssertion().getStatements().add((Statement)this.buildXMLObject(AuthnStatement.DEFAULT_ELEMENT_NAME));
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidSAMLVersion() throws AssertionValidationException {
        this.getAssertion().setVersion(SAMLVersion.VERSION_11);
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidIssuer() throws AssertionValidationException {
        this.getAssertion().getIssuer().setValue("invalid");
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testNoIssuer() throws AssertionValidationException {
        this.getAssertion().setIssuer(null);
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testNoIssueInstant() throws AssertionValidationException {
        this.getAssertion().setIssueInstant(null);
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testGetLifetime() {
        HashMap<String, Comparable<Duration>> staticParams = new HashMap<String, Comparable<Duration>>();
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)SAML20AssertionValidator.getLifetime((ValidationContext)validationContext), (Object)Duration.ofMinutes(5L));
        staticParams.put("saml2.Lifetime", Duration.ofMinutes(10L));
        validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)SAML20AssertionValidator.getLifetime((ValidationContext)validationContext), (Object)Duration.ofMinutes(10L));
        staticParams.put("saml2.Lifetime", Duration.ofMinutes(8L).negated());
        validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)SAML20AssertionValidator.getLifetime((ValidationContext)validationContext), (Object)Duration.ofMinutes(8L));
        staticParams.put("saml2.Lifetime", Long.valueOf(420000L));
        validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)SAML20AssertionValidator.getLifetime((ValidationContext)validationContext), (Object)Duration.ofMinutes(7L));
        staticParams.put("saml2.Lifetime", Long.valueOf(-540000L));
        validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)SAML20AssertionValidator.getLifetime((ValidationContext)validationContext), (Object)Duration.ofMinutes(9L));
        staticParams.put("saml2.Lifetime", Duration.ofSeconds(0L));
        validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)SAML20AssertionValidator.getLifetime((ValidationContext)validationContext), (Object)Duration.ofMinutes(5L));
    }

    @Test
    public void testIssueInstantInFuture() throws AssertionValidationException {
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Instant now = Instant.now();
        Duration clockSkew = SAML20AssertionValidator.getClockSkew((ValidationContext)validationContext);
        this.getAssertion().setIssueInstant(now.plus(clockSkew).plusSeconds(5L));
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testIssueInstantInFutureWithinClockSkew() throws AssertionValidationException {
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Instant now = Instant.now();
        Duration clockSkew = SAML20AssertionValidator.getClockSkew((ValidationContext)validationContext);
        this.getAssertion().setIssueInstant(now.plus(clockSkew).minusSeconds(5L));
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testIssueInstantExpired() throws AssertionValidationException {
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Instant now = Instant.now();
        Duration clockSkew = SAML20AssertionValidator.getClockSkew((ValidationContext)validationContext);
        Duration lifetime = SAML20AssertionValidator.getLifetime((ValidationContext)validationContext);
        this.getAssertion().setIssueInstant(now.minus(lifetime.plus(clockSkew).plusSeconds(5L)));
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testIssueInstantExpiredWithinClockSkew() throws AssertionValidationException {
        this.validator = this.getCurrentValidator();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SignatureRequired", false);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Instant now = Instant.now();
        Duration clockSkew = SAML20AssertionValidator.getClockSkew((ValidationContext)validationContext);
        Duration lifetime = SAML20AssertionValidator.getLifetime((ValidationContext)validationContext);
        this.getAssertion().setIssueInstant(now.minus(lifetime.plus(clockSkew).minusSeconds(5L)));
        Assertion assertion = this.getAssertion();
        Assert.assertEquals((Object)this.validator.validate(assertion, validationContext), (Object)ValidationResult.VALID);
    }

    private SAML20AssertionValidator getCurrentValidator() {
        return new SAML20AssertionValidator(this.conditionValidators, this.subjectConfirmationValidators, this.statementValidators, this.signatureTrustEngine, this.signaturePrevalidator);
    }

    public static class MockCondition
    extends AbstractXMLObject
    implements Condition {
        public static final QName ELEMENT_NAME = new QName("urn:test:conditions", "MockCondition", "mock");

        public MockCondition() {
            this(ELEMENT_NAME.getNamespaceURI(), ELEMENT_NAME.getLocalPart(), ELEMENT_NAME.getPrefix());
        }

        protected MockCondition(String namespaceURI, String elementLocalName, String namespacePrefix) {
            super(namespaceURI, elementLocalName, namespacePrefix);
        }

        public List<XMLObject> getOrderedChildren() {
            return null;
        }
    }

    public static class MockCondition2
    extends AbstractXMLObject
    implements Condition {
        public static final QName ELEMENT_NAME = new QName("urn:test:conditions", "MockCondition2", "mock");

        public MockCondition2() {
            this(ELEMENT_NAME.getNamespaceURI(), ELEMENT_NAME.getLocalPart(), ELEMENT_NAME.getPrefix());
        }

        protected MockCondition2(String namespaceURI, String elementLocalName, String namespacePrefix) {
            super(namespaceURI, elementLocalName, namespacePrefix);
        }

        public List<XMLObject> getOrderedChildren() {
            return null;
        }
    }

    public static class MockConditionValidator
    implements ConditionValidator {
        public QName getServicedCondition() {
            return MockCondition.ELEMENT_NAME;
        }

        public ValidationResult validate(Condition condition, Assertion assertion, ValidationContext context) throws AssertionValidationException {
            return ValidationResult.VALID;
        }
    }

    public static class MockCondition2Validator
    implements ConditionValidator {
        public QName getServicedCondition() {
            return MockCondition2.ELEMENT_NAME;
        }

        public ValidationResult validate(Condition condition, Assertion assertion, ValidationContext context) throws AssertionValidationException {
            return ValidationResult.VALID;
        }
    }
}

