/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Instant;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPSOAP11Encoder;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.soap.soap11.Envelope;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HTTPSOAP11EncoderTest
extends XMLObjectBaseTestCase {
    @Test
    public void testResponseEncoding() throws Exception {
        SAMLObjectBuilder statusCodeBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = (StatusCode)statusCodeBuilder.buildObject();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        SAMLObjectBuilder statusBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status responseStatus = (Status)statusBuilder.buildObject();
        responseStatus.setStatusCode(statusCode);
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response samlMessage = (Response)responseBuilder.buildObject();
        samlMessage.setID("foo");
        samlMessage.setVersion(SAMLVersion.VERSION_20);
        samlMessage.setIssueInstant(Instant.ofEpochMilli(0L));
        samlMessage.setStatus(responseStatus);
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation("http://example.org");
        samlEndpoint.setResponseLocation("http://example.org/response");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)samlMessage);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)"relay");
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(samlEndpoint);
        final MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPSOAP11Encoder encoder = new HTTPSOAP11Encoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            public HttpServletResponse get() {
                return response;
            }
        });
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)response.getContentType(), (String)"text/xml;charset=UTF-8", (String)"Unexpected content type");
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Assert.assertEquals((String)response.getHeader("SOAPAction"), (String)"http://www.oasis-open.org/committees/security");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(response.getContentAsByteArray());){
            XMLObject xmlObject = XMLObjectSupport.unmarshallFromInputStream((ParserPool)parserPool, (InputStream)inputStream);
            Assert.assertNotNull((Object)xmlObject);
            Assert.assertTrue((boolean)(xmlObject instanceof Envelope));
            Envelope envelope = (Envelope)xmlObject;
            Assert.assertNull((Object)envelope.getHeader());
            Assert.assertNotNull((Object)envelope.getBody());
            Assert.assertEquals((int)envelope.getBody().getUnknownXMLObjects().size(), (int)1);
            Response outboundResponse = (Response)envelope.getBody().getUnknownXMLObjects().get(0);
            outboundResponse.releaseDOM();
            outboundResponse.releaseChildrenDOM(true);
            outboundResponse.setParent(null);
            this.assertXMLEquals(XMLObjectSupport.marshall((XMLObject)outboundResponse).getOwnerDocument(), (XMLObject)samlMessage);
        }
    }
}

