/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Artifact;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.impl.RequestTestBase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ArtifactResolveTest
extends RequestTestBase {
    public ArtifactResolveTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/ArtifactResolve.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/ArtifactResolveOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/ArtifactResolveChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "ArtifactResolve", "saml2p");
        ArtifactResolve ar = (ArtifactResolve)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)ar);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)ar);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(ArtifactResolve.DEFAULT_ELEMENT_NAME);
        ((ArtifactResolve)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "ArtifactResolve", "saml2p");
        ArtifactResolve ar = (ArtifactResolve)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)ar);
        super.populateOptionalAttributes((SAMLObject)ar);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)ar);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "ArtifactResolve", "saml2p");
        ArtifactResolve ar = (ArtifactResolve)this.buildXMLObject(qname);
        super.populateChildElements((SAMLObject)ar);
        QName artifactQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "Artifact", "saml2p");
        ar.setArtifact((Artifact)this.buildXMLObject(artifactQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)ar);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        ArtifactResolve ar = (ArtifactResolve)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)ar, (String)"ArtifactResolve was null");
        super.helperTestSingleElementUnmarshall((SAMLObject)ar);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        ArtifactResolve ar = (ArtifactResolve)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)ar, (String)"ArtifactResolve was null");
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)ar);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ArtifactResolve ar = (ArtifactResolve)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)ar.getArtifact(), (String)"Artifact was null");
        super.helperTestChildElementsUnmarshall((SAMLObject)ar);
    }
}

