/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.RequesterID;
import org.opensaml.saml.saml2.core.Scoping;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ScopingTest
extends XMLObjectProviderBaseTestCase {
    private int expectedProxyCount;
    private int expectedNumRequestIDs;

    public ScopingTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/Scoping.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/ScopingOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/ScopingChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedProxyCount = 5;
        this.expectedNumRequestIDs = 3;
    }

    @Test
    public void testSingleElementMarshall() {
        Scoping scoping = (Scoping)this.buildXMLObject(Scoping.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)scoping);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Scoping scoping = (Scoping)this.buildXMLObject(Scoping.DEFAULT_ELEMENT_NAME);
        scoping.setProxyCount(Integer.valueOf(this.expectedProxyCount));
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)scoping);
    }

    @Test
    public void testChildElementsMarshall() {
        Scoping scoping = (Scoping)this.buildXMLObject(Scoping.DEFAULT_ELEMENT_NAME);
        QName idpListQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "IDPList", "saml2p");
        scoping.setIDPList((IDPList)this.buildXMLObject(idpListQName));
        QName requesterIDQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "RequesterID", "saml2p");
        for (int i = 0; i < this.expectedNumRequestIDs; ++i) {
            scoping.getRequesterIDs().add((RequesterID)this.buildXMLObject(requesterIDQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)scoping);
    }

    @Test
    public void testSingleElementUnmarshall() {
        Scoping scoping = (Scoping)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)scoping.getProxyCount(), (String)"ProxyCount");
        Assert.assertNull((Object)scoping.getIDPList(), (String)"IDPList");
        Assert.assertEquals((int)scoping.getRequesterIDs().size(), (int)0, (String)"RequesterID count");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Scoping scoping = (Scoping)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)scoping.getProxyCount(), (String)"ProxyCount");
        Assert.assertNull((Object)scoping.getIDPList(), (String)"IDPList");
        Assert.assertEquals((int)scoping.getRequesterIDs().size(), (int)0, (String)"RequesterID count");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Scoping scoping = (Scoping)this.unmarshallElement(this.childElementsFile);
        Assert.assertNull((Object)scoping.getProxyCount(), (String)"ProxyCount");
        Assert.assertNotNull((Object)scoping.getIDPList(), (String)"IDPList");
        Assert.assertEquals((int)scoping.getRequesterIDs().size(), (int)this.expectedNumRequestIDs, (String)"RequesterID count");
    }
}

