/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.tests;

import java.time.Instant;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.testing.BaseComplexSAMLObjectTestCase;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Subject;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthnRequestTest
extends BaseComplexSAMLObjectTestCase {
    public AuthnRequestTest() {
        this.elementFile = "/org/opensaml/saml/saml2/core/AuthnRequest.xml";
    }

    @Override
    @Test
    public void testUnmarshall() {
        AuthnRequest request = (AuthnRequest)this.unmarshallElement(this.elementFile);
        Assert.assertNotNull((Object)request, (String)"AuthnRequest was null");
        Assert.assertEquals((boolean)request.isForceAuthn(), (boolean)true, (String)"ForceAuthn");
        Assert.assertEquals((String)request.getAssertionConsumerServiceURL(), (String)"http://www.example.com/", (String)"AssertionConsumerServiceURL");
        Assert.assertEquals((int)request.getAttributeConsumingServiceIndex(), (int)0, (String)"AttributeConsumingServiceIndex");
        Assert.assertEquals((String)request.getProviderName(), (String)"SomeProvider", (String)"ProviderName");
        Assert.assertEquals((String)request.getID(), (String)"abe567de6", (String)"ID");
        Assert.assertEquals((String)request.getVersion().toString(), (String)SAMLVersion.VERSION_20.toString(), (String)"Version");
        Assert.assertEquals((Object)request.getIssueInstant(), (Object)Instant.parse("2005-01-31T12:00:00.000Z"), (String)"IssueInstant");
        Assert.assertEquals((String)request.getDestination(), (String)"http://www.example.com/", (String)"Destination");
        Assert.assertEquals((String)request.getConsent(), (String)"urn:oasis:names:tc:SAML:2.0:consent:obtained", (String)"Consent");
        Assert.assertEquals((String)request.getSubject().getNameID().getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", (String)"Subject/NameID/@NameIdFormat");
        Assert.assertEquals((String)request.getSubject().getNameID().getValue(), (String)"j.doe@company.com", (String)"Subject/NameID contents");
        Audience audience = (Audience)((AudienceRestriction)request.getConditions().getAudienceRestrictions().get(0)).getAudiences().get(0);
        Assert.assertEquals((String)audience.getURI(), (String)"urn:foo:sp.example.org", (String)"Conditions/AudienceRestriction[1]/Audience[1] contents");
        AuthnContextClassRef classRef = (AuthnContextClassRef)request.getRequestedAuthnContext().getAuthnContextClassRefs().get(0);
        Assert.assertEquals((String)classRef.getURI(), (String)"urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport", (String)"RequestedAuthnContext/AuthnContextClassRef[1] contents");
    }

    @Override
    @Test
    public void testMarshall() {
        NameID nameid = (NameID)this.buildXMLObject(NameID.DEFAULT_ELEMENT_NAME);
        nameid.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        nameid.setValue("j.doe@company.com");
        Subject subject = (Subject)this.buildXMLObject(Subject.DEFAULT_ELEMENT_NAME);
        subject.setNameID(nameid);
        Audience audience = (Audience)this.buildXMLObject(Audience.DEFAULT_ELEMENT_NAME);
        audience.setURI("urn:foo:sp.example.org");
        AudienceRestriction ar = (AudienceRestriction)this.buildXMLObject(AudienceRestriction.DEFAULT_ELEMENT_NAME);
        ar.getAudiences().add(audience);
        Conditions conditions = (Conditions)this.buildXMLObject(Conditions.DEFAULT_ELEMENT_NAME);
        conditions.getAudienceRestrictions().add(ar);
        AuthnContextClassRef classRef = (AuthnContextClassRef)this.buildXMLObject(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        classRef.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        RequestedAuthnContext rac = (RequestedAuthnContext)this.buildXMLObject(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        rac.getAuthnContextClassRefs().add(classRef);
        AuthnRequest request = (AuthnRequest)this.buildXMLObject(AuthnRequest.DEFAULT_ELEMENT_NAME);
        request.setSubject(subject);
        request.setConditions(conditions);
        request.setRequestedAuthnContext(rac);
        request.setForceAuthn(XSBooleanValue.valueOf((String)"true"));
        request.setAssertionConsumerServiceURL("http://www.example.com/");
        request.setAttributeConsumingServiceIndex(Integer.valueOf(0));
        request.setProviderName("SomeProvider");
        request.setID("abe567de6");
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIssueInstant(Instant.parse("2005-01-31T12:00:00.000Z"));
        request.setDestination("http://www.example.com/");
        request.setConsent("urn:oasis:names:tc:SAML:2.0:consent:obtained");
        this.assertXMLEquals("Marshalled AuthnRequest", this.expectedDOM, (XMLObject)request);
    }
}

