/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.ecp.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.ecp.RelayState;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RelayStateTest
extends XMLObjectProviderBaseTestCase {
    private String expectedContent;
    private String expectedSOAP11Actor;
    private Boolean expectedSOAP11MustUnderstand;

    public RelayStateTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/ecp/impl/RelayState.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedContent = "ThisIsSomeRelayState";
        this.expectedSOAP11Actor = "https://soap11actor.example.org";
        this.expectedSOAP11MustUnderstand = true;
    }

    @Test
    public void testSingleElementUnmarshall() {
        RelayState relayState = (RelayState)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)relayState);
        Assert.assertEquals((Object)relayState.isSOAP11MustUnderstand(), (Object)this.expectedSOAP11MustUnderstand, (String)"SOAP mustUnderstand had unxpected value");
        Assert.assertEquals((String)relayState.getSOAP11Actor(), (String)this.expectedSOAP11Actor, (String)"SOAP actor had unxpected value");
        Assert.assertEquals((String)relayState.getValue(), (String)this.expectedContent, (String)"Element content had unexpected value");
    }

    @Test
    public void testSingleElementMarshall() {
        RelayState relayState = (RelayState)this.buildXMLObject(RelayState.DEFAULT_ELEMENT_NAME);
        relayState.setSOAP11Actor(this.expectedSOAP11Actor);
        relayState.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        relayState.setValue(this.expectedContent);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)relayState);
    }
}

