/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.ecp.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.ecp.Request;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RequestTest
extends XMLObjectProviderBaseTestCase {
    private String expectedProviderName;
    private Boolean expectedPassive;
    private String expectedSOAP11Actor;
    private Boolean expectedSOAP11MustUnderstand;

    public RequestTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/ecp/impl/Request.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/ecp/impl/RequestOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/ecp/impl/RequestChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedProviderName = "https://provider.example.org";
        this.expectedSOAP11Actor = "https://soap11actor.example.org";
        this.expectedSOAP11MustUnderstand = true;
        this.expectedPassive = true;
    }

    @Test
    public void testSingleElementUnmarshall() {
        Request request = (Request)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)request.isSOAP11MustUnderstand(), (Object)this.expectedSOAP11MustUnderstand, (String)"SOAP mustUnderstand had unxpected value");
        Assert.assertEquals((String)request.getSOAP11Actor(), (String)this.expectedSOAP11Actor, (String)"SOAP actor had unxpected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Request request = (Request)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)request.isSOAP11MustUnderstand(), (Object)this.expectedSOAP11MustUnderstand, (String)"SOAP mustUnderstand had unxpected value");
        Assert.assertEquals((String)request.getSOAP11Actor(), (String)this.expectedSOAP11Actor, (String)"SOAP actor had unxpected value");
        Assert.assertEquals((Object)request.isPassive(), (Object)this.expectedPassive, (String)"IsPassive had unexpected value");
        Assert.assertEquals((String)request.getProviderName(), (String)this.expectedProviderName, (String)"ProviderName had unexpected value");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Request request = (Request)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)request.isSOAP11MustUnderstand(), (Object)this.expectedSOAP11MustUnderstand, (String)"SOAP mustUnderstand had unxpected value");
        Assert.assertEquals((String)request.getSOAP11Actor(), (String)this.expectedSOAP11Actor, (String)"SOAP actor had unxpected value");
        Assert.assertNotNull((Object)request.getIssuer(), (String)"Issuer was null");
        Assert.assertNotNull((Object)request.getIDPList(), (String)"IDPList was null");
    }

    @Test
    public void testSingleElementMarshall() {
        Request request = (Request)this.buildXMLObject(Request.DEFAULT_ELEMENT_NAME);
        request.setSOAP11Actor(this.expectedSOAP11Actor);
        request.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)request);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Request request = (Request)this.buildXMLObject(Request.DEFAULT_ELEMENT_NAME);
        request.setSOAP11Actor(this.expectedSOAP11Actor);
        request.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        request.setProviderName(this.expectedProviderName);
        request.setPassive(this.expectedPassive);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)request);
    }

    @Test
    public void testChildElementsMarshall() {
        Request request = (Request)this.buildXMLObject(Request.DEFAULT_ELEMENT_NAME);
        request.setSOAP11Actor(this.expectedSOAP11Actor);
        request.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        request.setIssuer((Issuer)this.buildXMLObject(Issuer.DEFAULT_ELEMENT_NAME));
        request.setIDPList((IDPList)this.buildXMLObject(IDPList.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)request);
    }
}

