/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.saml.saml2.metadata.AffiliateMember;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.impl.AffiliationDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.KeyDescriptorBuilder;
import org.opensaml.xmlsec.signature.Signature;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AffiliationDescriptorTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedOwnerID;
    protected String expectedID;
    protected Duration expectedCacheDuration;
    protected Instant expectedValidUntil;
    protected QName[] unknownAttributeNames = new QName[]{new QName("urn:foo:bar", "bar", "foo")};
    protected String[] unknownAttributeValues = new String[]{"fred"};

    public AffiliationDescriptorTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/AffiliationDescriptor.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/AffiliationDescriptorOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/AffiliationDescriptorChildElements.xml";
        this.singleElementUnknownAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/AffiliationDescriptorUnknownAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedOwnerID = "urn:example.org";
        this.expectedID = "id";
        this.expectedCacheDuration = Duration.ofSeconds(90L);
        this.expectedValidUntil = Instant.parse("2005-12-07T10:21:00Z");
    }

    @Test
    public void testSingleElementUnmarshall() {
        AffiliationDescriptor descriptor = (AffiliationDescriptor)this.unmarshallElement(this.singleElementFile);
        String ownerId = descriptor.getOwnerID();
        Assert.assertEquals((String)ownerId, (String)this.expectedOwnerID, (String)("entityID attribute has a value of " + ownerId + ", expected a value of " + this.expectedOwnerID));
        Duration duration = descriptor.getCacheDuration();
        Assert.assertNull((Object)duration, (String)("cacheDuration attribute has a value of " + duration + ", expected no value"));
        Instant validUntil = descriptor.getValidUntil();
        Assert.assertNull((Object)validUntil, (String)("validUntil attribute has a value of " + validUntil + ", expected no value"));
        Assert.assertTrue((boolean)descriptor.isValid());
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AffiliationDescriptor descriptor = (AffiliationDescriptor)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        String ownerId = descriptor.getOwnerID();
        Assert.assertEquals((String)ownerId, (String)this.expectedOwnerID, (String)("entityID attribute has a value of " + ownerId + ", expected a value of " + this.expectedOwnerID));
        String id = descriptor.getID();
        Assert.assertEquals((String)id, (String)this.expectedID, (String)("ID attribute has a value of " + id + ", expected a value of " + this.expectedID));
        Duration duration = descriptor.getCacheDuration();
        Assert.assertEquals((Object)duration, (Object)this.expectedCacheDuration, (String)("cacheDuration attribute has a value of " + duration + ", expected a value of " + this.expectedCacheDuration));
        Instant validUntil = descriptor.getValidUntil();
        Assert.assertEquals((int)this.expectedValidUntil.compareTo(validUntil), (int)0, (String)"validUntil attribute value did not match expected value");
        Assert.assertFalse((boolean)descriptor.isValid());
    }

    @Test
    public void testSingleElementUnknownAttributesUnmarshall() {
        AffiliationDescriptor descriptor = (AffiliationDescriptor)this.unmarshallElement(this.singleElementUnknownAttributesFile);
        AttributeMap attributes = descriptor.getUnknownAttributes();
        Assert.assertEquals((int)attributes.entrySet().size(), (int)this.unknownAttributeNames.length);
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            Assert.assertEquals((String)attributes.get((Object)this.unknownAttributeNames[i]), (String)this.unknownAttributeValues[i]);
        }
    }

    @Test
    public void testChildElementsUnmarshall() {
        AffiliationDescriptor descriptor = (AffiliationDescriptor)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)descriptor.getExtensions(), (String)"Extensions");
        Assert.assertNotNull((Object)descriptor.getSignature(), (String)"Signature");
        Assert.assertEquals((int)descriptor.getKeyDescriptors().size(), (int)1, (String)"KeyDescriptor count");
        Assert.assertEquals((int)descriptor.getMembers().size(), (int)3, (String)"Affiliate Member count ");
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AffiliationDescriptor", "md");
        AffiliationDescriptor descriptor = (AffiliationDescriptor)this.buildXMLObject(qname);
        descriptor.setOwnerID(this.expectedOwnerID);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)descriptor);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(AffiliationDescriptor.DEFAULT_ELEMENT_NAME);
        ((AffiliationDescriptor)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AffiliationDescriptor descriptor = new AffiliationDescriptorBuilder().buildObject();
        descriptor.setOwnerID(this.expectedOwnerID);
        descriptor.setID(this.expectedID);
        descriptor.setValidUntil(this.expectedValidUntil);
        descriptor.setCacheDuration(this.expectedCacheDuration);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)descriptor);
    }

    @Test
    public void testSingleElementUnknownAttributesMarshall() {
        AffiliationDescriptor descriptor = new AffiliationDescriptorBuilder().buildObject();
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            descriptor.getUnknownAttributes().put(this.unknownAttributeNames[i], this.unknownAttributeValues[i]);
        }
        this.assertXMLEquals(this.expectedUnknownAttributesDOM, (XMLObject)descriptor);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AffiliationDescriptor", "md");
        AffiliationDescriptor descriptor = (AffiliationDescriptor)this.buildXMLObject(qname);
        StringBuilder bigString = new StringBuilder();
        for (int i = 0; i < 1026; ++i) {
            bigString.append('s');
        }
        try {
            descriptor.setOwnerID(bigString.toString());
            Assert.fail();
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        descriptor.setOwnerID(this.expectedOwnerID);
        descriptor.setID(this.expectedID);
        descriptor.setSignature(this.buildSignatureSkeleton());
        descriptor.setExtensions((Extensions)this.buildXMLObject(Extensions.DEFAULT_ELEMENT_NAME));
        QName affilMemberQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AffiliateMember", "md");
        descriptor.getMembers().add((AffiliateMember)this.buildXMLObject(affilMemberQName));
        descriptor.getMembers().add((AffiliateMember)this.buildXMLObject(affilMemberQName));
        descriptor.getMembers().add((AffiliateMember)this.buildXMLObject(affilMemberQName));
        descriptor.getKeyDescriptors().add(new KeyDescriptorBuilder().buildObject());
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)descriptor);
    }

    private Signature buildSignatureSkeleton() {
        Signature signature = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        return signature;
    }
}

