/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.AssertionIDRequestService;
import org.opensaml.saml.saml2.metadata.AuthnAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.AuthnQueryService;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.impl.AuthnAuthorityDescriptorBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuthnAuthorityDescriptorTest
extends XMLObjectProviderBaseTestCase {
    protected List<String> expectedSupportedProtocols;
    protected Duration expectedCacheDuration;
    protected Instant expectedValidUntil;
    protected String expectedErrorURL;
    protected int expectedKeyDescriptors;
    protected int expectedContactPersons;
    protected int expectedAuthnQueryServices;
    protected int expectedAssertionIdRequestServices;
    protected int expectedNameIdFormats;

    public AuthnAuthorityDescriptorTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/AuthnAuthorityDescriptor.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/AuthnAuthorityDescriptorOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/AuthnAuthorityDescriptorChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedSupportedProtocols = new ArrayList<String>();
        this.expectedSupportedProtocols.add("urn:oasis:names:tc:SAML:2.0:protocol");
        this.expectedCacheDuration = Duration.ofSeconds(90L);
        this.expectedValidUntil = Instant.parse("2005-12-07T10:21:00Z");
        this.expectedErrorURL = "http://example.org";
        this.expectedKeyDescriptors = 0;
        this.expectedContactPersons = 2;
        this.expectedAuthnQueryServices = 3;
        this.expectedAssertionIdRequestServices = 2;
        this.expectedNameIdFormats = 1;
    }

    @Test
    public void testSingleElementUnmarshall() {
        AuthnAuthorityDescriptor authnAuthorityObj = (AuthnAuthorityDescriptor)this.unmarshallElement(this.singleElementFile);
        List protoEnum = authnAuthorityObj.getSupportedProtocols();
        Assert.assertEquals((Collection)protoEnum, this.expectedSupportedProtocols, (String)"Supported protocol enumeration was not equal to expected enumeration");
        Duration duration = authnAuthorityObj.getCacheDuration();
        Assert.assertNull((Object)duration, (String)("cacheDuration attribute has a value of " + duration + ", expected no value"));
        Instant validUntil = authnAuthorityObj.getValidUntil();
        Assert.assertNull((Object)validUntil, (String)("validUntil attribute has a value of " + validUntil + ", expected no value"));
        String errorURL = authnAuthorityObj.getErrorURL();
        Assert.assertNull((Object)errorURL, (String)("errorURL attribute has a value of " + errorURL + ", expected no value"));
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthnAuthorityDescriptor authnAuthorityObj = (AuthnAuthorityDescriptor)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        List protoEnum = authnAuthorityObj.getSupportedProtocols();
        Assert.assertEquals((Collection)protoEnum, this.expectedSupportedProtocols, (String)"Supported protocol enumeration was not equal to expected enumeration");
        Duration duration = authnAuthorityObj.getCacheDuration();
        Assert.assertEquals((Object)duration, (Object)this.expectedCacheDuration, (String)("cacheDuration attribute has a value of " + duration + ", expected a value of " + this.expectedCacheDuration));
        Instant validUntil = authnAuthorityObj.getValidUntil();
        Assert.assertEquals((int)this.expectedValidUntil.compareTo(validUntil), (int)0, (String)"validUntil attribute value did not match expected value");
        String errorURL = authnAuthorityObj.getErrorURL();
        Assert.assertEquals((String)errorURL, (String)this.expectedErrorURL, (String)("errorURL attribute has a value of " + errorURL + ", expected a value of " + this.expectedErrorURL));
    }

    @Test
    public void testChildElementsUnmarshall() {
        AuthnAuthorityDescriptor authnAuthorityObj = (AuthnAuthorityDescriptor)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)authnAuthorityObj.getExtensions(), (String)"<Extensions>");
        Assert.assertEquals((int)authnAuthorityObj.getKeyDescriptors().size(), (int)0, (String)"KeyDescriptor");
        Assert.assertEquals((int)authnAuthorityObj.getKeyDescriptors().size(), (int)this.expectedKeyDescriptors, (String)"KeyDescriptors count");
        Assert.assertNotNull((Object)authnAuthorityObj.getOrganization(), (String)"Organization");
        Assert.assertEquals((int)authnAuthorityObj.getContactPersons().size(), (int)this.expectedContactPersons, (String)"ContactPersons count");
        Assert.assertEquals((int)authnAuthorityObj.getAuthnQueryServices().size(), (int)this.expectedAuthnQueryServices, (String)"AuthnQueryServices count");
        Assert.assertEquals((int)authnAuthorityObj.getAssertionIDRequestServices().size(), (int)this.expectedAssertionIdRequestServices, (String)"AssertionIDRequestServices count");
        Assert.assertEquals((int)authnAuthorityObj.getNameIDFormats().size(), (int)this.expectedNameIdFormats, (String)"NameIdFormats count");
        Assert.assertEquals((int)authnAuthorityObj.getEndpoints().size(), (int)(this.expectedAuthnQueryServices + this.expectedAssertionIdRequestServices), (String)"Endpoints count");
        Assert.assertEquals((int)authnAuthorityObj.getEndpoints(AuthnQueryService.DEFAULT_ELEMENT_NAME).size(), (int)this.expectedAuthnQueryServices, (String)"Endpoints(AuthnQueryService) count");
        Assert.assertEquals((int)authnAuthorityObj.getEndpoints(AssertionIDRequestService.DEFAULT_ELEMENT_NAME).size(), (int)this.expectedAssertionIdRequestServices, (String)"Endpoints(AssertionIdRequestService) count");
        Assert.assertNull((Object)authnAuthorityObj.getEndpoints(EntityDescriptor.DEFAULT_ELEMENT_NAME));
    }

    @Test
    public void testSingleElementMarshall() {
        AuthnAuthorityDescriptor descriptor = new AuthnAuthorityDescriptorBuilder().buildObject();
        descriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        this.assertXMLEquals(this.expectedDOM, (XMLObject)descriptor);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AuthnAuthorityDescriptor descriptor = new AuthnAuthorityDescriptorBuilder().buildObject();
        descriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        descriptor.setValidUntil(this.expectedValidUntil);
        descriptor.setCacheDuration(this.expectedCacheDuration);
        descriptor.setErrorURL(this.expectedErrorURL);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)descriptor);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AuthnAuthorityDescriptor", "md");
        AuthnAuthorityDescriptor descriptor = (AuthnAuthorityDescriptor)this.buildXMLObject(qname);
        descriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        QName extensionsQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions", "md");
        descriptor.setExtensions((Extensions)this.buildXMLObject(extensionsQName));
        QName orgQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Organization", "md");
        descriptor.setOrganization((Organization)this.buildXMLObject(orgQName));
        QName contactPersonQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ContactPerson", "md");
        for (int i = 0; i < this.expectedContactPersons; ++i) {
            descriptor.getContactPersons().add((ContactPerson)this.buildXMLObject(contactPersonQName));
        }
        QName authnQueryServiceQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AuthnQueryService", "md");
        for (int i = 0; i < this.expectedAuthnQueryServices; ++i) {
            descriptor.getAuthnQueryServices().add((AuthnQueryService)this.buildXMLObject(authnQueryServiceQName));
        }
        QName assertionIDRequestServiceQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AssertionIDRequestService", "md");
        for (int i = 0; i < this.expectedAssertionIdRequestServices; ++i) {
            descriptor.getAssertionIDRequestServices().add((AssertionIDRequestService)this.buildXMLObject(assertionIDRequestServiceQName));
        }
        QName nameIDFormatQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "NameIDFormat", "md");
        for (int i = 0; i < this.expectedNameIdFormats; ++i) {
            descriptor.getNameIDFormats().add((NameIDFormat)this.buildXMLObject(nameIDFormatQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)descriptor);
    }
}

