/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.ManageNameIDService;
import org.opensaml.saml.saml2.metadata.impl.ManageNameIDServiceBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ManageNameIDServiceTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedBinding;
    protected String expectedLocation;
    protected String expectedResponseLocation;

    public ManageNameIDServiceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/ManageNameIDService.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/ManageNameIDServiceOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedBinding = "urn:binding:foo";
        this.expectedLocation = "example.org";
        this.expectedResponseLocation = "example.org/response";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ManageNameIDService service = (ManageNameIDService)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        ManageNameIDService service = (ManageNameIDService)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
        Assert.assertEquals((String)service.getResponseLocation(), (String)this.expectedResponseLocation, (String)"ResponseLocation was not expected value");
    }

    @Test
    public void testSingleElementMarshall() {
        ManageNameIDService service = new ManageNameIDServiceBuilder().buildObject();
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)service);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        ManageNameIDService service = (ManageNameIDService)this.buildXMLObject(ManageNameIDService.DEFAULT_ELEMENT_NAME);
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        service.setResponseLocation(this.expectedResponseLocation);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)service);
    }
}

