/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.messaging.context.ECPContext;
import org.opensaml.saml.ext.samlec.GeneratedKey;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.opensaml.saml.saml2.profile.impl.AddGeneratedKeyToAssertions;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddGeneratedKeyToAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private ECPContext ecp;
    private AddGeneratedKeyToAssertions action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.ecp = new ECPContext();
        this.ecp.setSessionKey(new byte[]{1, 2, 3});
        this.action = new AddGeneratedKeyToAssertions();
        this.action.initialize();
    }

    @Test
    public void testNoResponse() {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        prc.getOutboundMessageContext().addSubcontext((BaseContext)this.ecp);
        this.action.execute(prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoBindings() {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
    }

    @Test
    public void testNoAssertion() {
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)SAML2ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        prc.getOutboundMessageContext().addSubcontext((BaseContext)this.ecp);
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
    }

    @Test
    public void testSingleAssertion() throws EncodingException {
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        prc.getOutboundMessageContext().addSubcontext((BaseContext)this.ecp);
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getAdvice());
        Assert.assertEquals((int)assertion.getAdvice().getChildren(GeneratedKey.DEFAULT_ELEMENT_NAME).size(), (int)1);
        GeneratedKey key = (GeneratedKey)assertion.getAdvice().getChildren(GeneratedKey.DEFAULT_ELEMENT_NAME).get(0);
        Assert.assertEquals((String)key.getValue(), (String)Base64Support.encode((byte[])this.ecp.getSessionKey(), (boolean)false));
    }

    @Test
    public void testSingleAssertionWithExistingCondition() throws EncodingException {
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        SAML2ActionSupport.addAdviceToAssertion((AbstractProfileAction)this.action, (Assertion)assertion);
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        prc.getOutboundMessageContext().addSubcontext((BaseContext)this.ecp);
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)assertion.getAdvice());
        Assert.assertEquals((int)assertion.getAdvice().getChildren(GeneratedKey.DEFAULT_ELEMENT_NAME).size(), (int)1);
        GeneratedKey key = (GeneratedKey)assertion.getAdvice().getChildren(GeneratedKey.DEFAULT_ELEMENT_NAME).get(0);
        Assert.assertEquals((String)key.getValue(), (String)Base64Support.encode((byte[])this.ecp.getSessionKey(), (boolean)false));
    }

    @Test
    public void testMultipleAssertion() throws EncodingException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        prc.getOutboundMessageContext().addSubcontext((BaseContext)this.ecp);
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)3);
        for (Assertion assertion : response.getAssertions()) {
            Assert.assertNotNull((Object)assertion.getAdvice());
            Assert.assertEquals((int)assertion.getAdvice().getChildren(GeneratedKey.DEFAULT_ELEMENT_NAME).size(), (int)1);
            GeneratedKey key = (GeneratedKey)assertion.getAdvice().getChildren(GeneratedKey.DEFAULT_ELEMENT_NAME).get(0);
            Assert.assertEquals((String)key.getValue(), (String)Base64Support.encode((byte[])this.ecp.getSessionKey(), (boolean)false));
        }
    }
}

