/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import com.google.common.base.Predicates;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.binding.impl.SAMLMetadataLookupHandlerTest;
import org.opensaml.saml.common.profile.NameIdentifierGenerator;
import org.opensaml.saml.common.profile.logic.AffiliationNameIDPolicyPredicate;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.profile.AbstractSAML2NameIDGenerator;
import org.opensaml.saml.saml2.profile.SAML2NameIDGenerator;
import org.opensaml.saml.saml2.profile.impl.AddNameIDToSubjects;
import org.opensaml.saml.saml2.profile.impl.ChainingSAML2NameIDGenerator;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddNameIDToSubjectsTest
extends XMLObjectBaseTestCase {
    private static final String NAME_QUALIFIER = "https://idp.example.org";
    private FilesystemMetadataResolver metadataResolver;
    private SAMLObjectBuilder<NameIDPolicy> policyBuilder;
    private ChainingSAML2NameIDGenerator generator;
    private ProfileRequestContext prc;
    private AddNameIDToSubjects action;

    @BeforeClass
    public void classSetUp() throws ResolverException, URISyntaxException, ComponentInitializationException {
        URL mdURL = SAMLMetadataLookupHandlerTest.class.getResource("/org/opensaml/saml/saml2/profile/impl/affiliation-metadata.xml");
        File mdFile = new File(mdURL.toURI());
        this.metadataResolver = new FilesystemMetadataResolver(mdFile);
        this.metadataResolver.setParserPool(parserPool);
        this.metadataResolver.setId("md");
        this.metadataResolver.initialize();
    }

    @AfterClass
    public void classTearDown() {
        this.metadataResolver.destroy();
    }

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new AddNameIDToSubjects();
        MockSAML2NameIDGenerator mock = new MockSAML2NameIDGenerator("foo");
        mock.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        mock.initialize();
        MockSAML2NameIDGenerator mock2 = new MockSAML2NameIDGenerator("bar");
        mock2.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        mock2.setActivationCondition((Predicate)Predicates.alwaysFalse());
        mock2.initialize();
        MockSAML2NameIDGenerator mock3 = new MockSAML2NameIDGenerator("baz");
        mock3.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        mock3.initialize();
        MockSAML2NameIDGenerator mock4 = new MockSAML2NameIDGenerator("baf");
        mock4.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        mock4.initialize();
        this.generator = new ChainingSAML2NameIDGenerator();
        this.generator.setGenerators(Arrays.asList(new NameIdentifierGenerator[]{mock, mock2, mock3, mock4}));
        this.action.setNameIDGenerator((SAML2NameIDGenerator)this.generator);
        this.policyBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIDPolicy.DEFAULT_ELEMENT_NAME);
    }

    @Test
    public void testNoMessage() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assertion assertion = (Assertion)this.prc.getOutboundMessageContext().getMessage();
        Subject subject = assertion.getSubject();
        Assert.assertNull((Object)subject);
    }

    @Test
    public void testNoAssertions() throws ComponentInitializationException {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildResponse());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertTrue((boolean)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().isEmpty());
    }

    @Test
    void testRequiredFormat() throws ComponentInitializationException {
        this.addAssertions();
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        NameIDPolicy policy = (NameIDPolicy)this.policyBuilder.buildObject();
        policy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        request.setNameIDPolicy(policy);
        this.prc.getInboundMessageContext().setMessage((Object)request);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = assertion.getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameID());
        Assert.assertEquals((String)subject.getNameID().getValue(), (String)"baz");
        Assert.assertEquals((String)subject.getNameID().getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(1);
        subject = assertion.getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameID());
        Assert.assertEquals((String)subject.getNameID().getValue(), (String)"baz");
        Assert.assertEquals((String)subject.getNameID().getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
    }

    @Test
    void testRequiredFormatError() throws ComponentInitializationException {
        this.addAssertions();
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        NameIDPolicy policy = (NameIDPolicy)this.policyBuilder.buildObject();
        policy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos");
        request.setNameIDPolicy(policy);
        this.prc.getInboundMessageContext().setMessage((Object)request);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidNameIDPolicy");
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = assertion.getSubject();
        Assert.assertNull((Object)subject);
    }

    @Test
    void testQualifierAsIssuer() throws ComponentInitializationException {
        this.addAssertions();
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        NameIDPolicy policy = (NameIDPolicy)this.policyBuilder.buildObject();
        policy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        policy.setSPNameQualifier("foo");
        request.setNameIDPolicy(policy);
        this.prc.getInboundMessageContext().setMessage((Object)request);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidNameIDPolicy");
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = assertion.getSubject();
        Assert.assertNull((Object)subject);
        policy.setSPNameQualifier(request.getIssuer().getValue());
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        subject = assertion.getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameID());
        Assert.assertEquals((String)subject.getNameID().getValue(), (String)"baf");
        Assert.assertEquals((String)subject.getNameID().getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
    }

    @Test
    void testAffiliation() throws ComponentInitializationException {
        this.addAssertions();
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        NameIDPolicy policy = (NameIDPolicy)this.policyBuilder.buildObject();
        policy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        policy.setSPNameQualifier("foo");
        request.setNameIDPolicy(policy);
        this.prc.getInboundMessageContext().setMessage((Object)request);
        AffiliationNameIDPolicyPredicate predicate = new AffiliationNameIDPolicyPredicate();
        predicate.setMetadataResolver((MetadataResolver)this.metadataResolver);
        predicate.setRequesterIdLookupStrategy((Function)new AddNameIDToSubjects.RequesterIdFromIssuerFunction());
        predicate.setObjectLookupStrategy((Function)new AddNameIDToSubjects.NameIDPolicyLookupFunction());
        predicate.initialize();
        this.action.setNameIDPolicyPredicate((Predicate)predicate);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidNameIDPolicy");
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = assertion.getSubject();
        Assert.assertNull((Object)subject);
        policy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        policy.setSPNameQualifier("http://affiliation.example.org");
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        subject = assertion.getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameID());
        Assert.assertEquals((String)subject.getNameID().getValue(), (String)"baf");
        Assert.assertEquals((String)subject.getNameID().getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
    }

    @Test
    void testArbitraryFormat() throws ComponentInitializationException {
        this.addAssertions();
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = assertion.getSubject();
        Assert.assertNull((Object)subject);
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(1);
        subject = assertion.getSubject();
        Assert.assertNull((Object)subject);
    }

    @Test
    void testSingleGenerator() throws ComponentInitializationException {
        this.addAssertions();
        this.action.setFormatLookupStrategy((Function)new X509FormatLookupStrategy());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = assertion.getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameID());
        Assert.assertEquals((String)subject.getNameID().getValue(), (String)"foo");
        Assert.assertEquals((String)subject.getNameID().getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(1);
        subject = assertion.getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameID());
        Assert.assertEquals((String)subject.getNameID().getValue(), (String)"foo");
        Assert.assertEquals((String)subject.getNameID().getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
    }

    @Test
    void testMultipleGenerators() throws ComponentInitializationException {
        this.addAssertions();
        this.action.setFormatLookupStrategy((Function)new EmailFormatLookupStrategy());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = assertion.getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameID());
        Assert.assertEquals((String)subject.getNameID().getValue(), (String)"baz");
        Assert.assertEquals((String)subject.getNameID().getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(1);
        subject = assertion.getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameID());
        Assert.assertEquals((String)subject.getNameID().getValue(), (String)"baz");
        Assert.assertEquals((String)subject.getNameID().getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
    }

    private void addAssertions() {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.prc.getOutboundMessageContext().setMessage((Object)response);
    }

    private class MockSAML2NameIDGenerator
    extends AbstractSAML2NameIDGenerator {
        private final String identifier;

        public MockSAML2NameIDGenerator(String id) {
            this.setId("test");
            this.setDefaultIdPNameQualifierLookupStrategy(new Function<ProfileRequestContext, String>(){

                @Override
                public String apply(ProfileRequestContext input) {
                    return AddNameIDToSubjectsTest.NAME_QUALIFIER;
                }
            });
            this.identifier = id;
        }

        protected String getIdentifier(ProfileRequestContext profileRequestContext) throws SAMLException {
            return this.identifier;
        }
    }

    private class X509FormatLookupStrategy
    implements Function<ProfileRequestContext, List<String>> {
        private X509FormatLookupStrategy() {
        }

        @Override
        public List<String> apply(ProfileRequestContext input) {
            return Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName", "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        }
    }

    private class EmailFormatLookupStrategy
    implements Function<ProfileRequestContext, List<String>> {
        private EmailFormatLookupStrategy() {
        }

        @Override
        public List<String> apply(ProfileRequestContext input) {
            return Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        }
    }
}

