/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.saml.saml2.profile.impl.DecryptNameIDs;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DecryptNameIDsTest
extends OpenSAMLInitBaseTestCase {
    private KeyInfoCredentialResolver keyResolver;
    private String encURI;
    private DataEncryptionParameters encParams;
    private Encrypter encrypter;
    private ProfileRequestContext prc;
    private DecryptNameIDs action;
    private SAMLObjectBuilder<NameID> nameIdBuilder;
    private SAMLObjectBuilder<Subject> subjectBuilder;

    @BeforeMethod
    public void setUp() throws NoSuchAlgorithmException, KeyException {
        this.encURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        this.nameIdBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameID.DEFAULT_ELEMENT_NAME);
        this.subjectBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Subject.DEFAULT_ELEMENT_NAME);
        Credential encCred = AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.encURI);
        this.keyResolver = new StaticKeyInfoCredentialResolver(encCred);
        this.encParams = new DataEncryptionParameters();
        this.encParams.setAlgorithm(this.encURI);
        this.encParams.setEncryptionCredential(encCred);
        this.encrypter = new Encrypter(this.encParams);
        DecryptionParameters decParams = new DecryptionParameters();
        decParams.setDataKeyInfoCredentialResolver(this.keyResolver);
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        ((SecurityParametersContext)this.prc.getInboundMessageContext().getSubcontext(SecurityParametersContext.class, true)).setDecryptionParameters(decParams);
        this.action = new DecryptNameIDs();
    }

    @Test
    public void testNoMessage() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testEncryptedNameIDNoParams() throws EncryptionException, ComponentInitializationException {
        AuthnRequest authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        this.prc.getInboundMessageContext().setMessage((Object)authnRequest);
        Subject subject = (Subject)this.subjectBuilder.buildObject();
        authnRequest.setSubject(subject);
        NameID nameId = (NameID)this.nameIdBuilder.buildObject();
        nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        nameId.setValue("foo");
        EncryptedID encryptedTarget = this.encrypter.encrypt(nameId);
        subject.setEncryptedID(encryptedTarget);
        this.action.initialize();
        this.prc.getInboundMessageContext().removeSubcontext(SecurityParametersContext.class);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"DecryptNameIDFailed");
        Assert.assertNull((Object)authnRequest.getSubject().getNameID());
        this.action = new DecryptNameIDs();
        this.action.setErrorFatal(false);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNull((Object)authnRequest.getSubject().getNameID());
    }

    @Test
    public void testEncryptedNameID() throws EncryptionException, ComponentInitializationException {
        AuthnRequest authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        this.prc.getInboundMessageContext().setMessage((Object)authnRequest);
        Subject subject = (Subject)this.subjectBuilder.buildObject();
        authnRequest.setSubject(subject);
        NameID nameId = (NameID)this.nameIdBuilder.buildObject();
        nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        nameId.setValue("foo");
        EncryptedID encryptedTarget = this.encrypter.encrypt(nameId);
        subject.setEncryptedID(encryptedTarget);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)authnRequest.getSubject().getNameID());
        Assert.assertEquals((String)authnRequest.getSubject().getNameID().getValue(), (String)"foo");
        Assert.assertEquals((String)authnRequest.getSubject().getNameID().getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
    }

    @Test
    public void testWrongKeyFatal() throws Exception {
        AuthnRequest authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        this.prc.getInboundMessageContext().setMessage((Object)authnRequest);
        Subject subject = (Subject)this.subjectBuilder.buildObject();
        authnRequest.setSubject(subject);
        NameID nameId = (NameID)this.nameIdBuilder.buildObject();
        nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        nameId.setValue("foo");
        EncryptedID encryptedTarget = this.encrypter.encrypt(nameId);
        subject.setEncryptedID(encryptedTarget);
        Credential encCred = AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.encURI);
        StaticKeyInfoCredentialResolver badKeyResolver = new StaticKeyInfoCredentialResolver(encCred);
        ((SecurityParametersContext)this.prc.getInboundMessageContext().getSubcontext(SecurityParametersContext.class)).getDecryptionParameters().setDataKeyInfoCredentialResolver((KeyInfoCredentialResolver)badKeyResolver);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"DecryptNameIDFailed");
        Assert.assertNull((Object)authnRequest.getSubject().getNameID());
    }

    @Test
    public void testWrongKeyNonFatal() throws Exception {
        AuthnRequest authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        this.prc.getInboundMessageContext().setMessage((Object)authnRequest);
        Subject subject = (Subject)this.subjectBuilder.buildObject();
        authnRequest.setSubject(subject);
        NameID nameId = (NameID)this.nameIdBuilder.buildObject();
        nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        nameId.setValue("foo");
        EncryptedID encryptedTarget = this.encrypter.encrypt(nameId);
        subject.setEncryptedID(encryptedTarget);
        Credential encCred = AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.encURI);
        StaticKeyInfoCredentialResolver badKeyResolver = new StaticKeyInfoCredentialResolver(encCred);
        ((SecurityParametersContext)this.prc.getInboundMessageContext().getSubcontext(SecurityParametersContext.class)).getDecryptionParameters().setDataKeyInfoCredentialResolver((KeyInfoCredentialResolver)badKeyResolver);
        this.action.setErrorFatal(false);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNull((Object)authnRequest.getSubject().getNameID());
    }
}

