/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.messaging.context.ECPContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.saml.saml2.profile.impl.PopulateECPContext;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.opensaml.xmlsec.EncryptionParameters;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateECPContextTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private PopulateECPContext action;

    @BeforeMethod
    public void setUp() throws NoSuchAlgorithmException, NoSuchProviderException {
        this.prc = new RequestContextBuilder().setInboundMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest()).buildProfileRequestContext();
        this.action = new PopulateECPContext();
    }

    @Test
    public void testUnsignedUnencrypted() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        ECPContext ecp = (ECPContext)this.prc.getOutboundMessageContext().getSubcontext(ECPContext.class);
        if (ecp != null) {
            Assert.assertFalse((boolean)ecp.isRequestAuthenticated());
            Assert.assertNull((Object)ecp.getSessionKey());
        }
    }

    @Test
    public void testAuthenticated() throws ComponentInitializationException {
        ((SAMLBindingContext)this.prc.getInboundMessageContext().getSubcontext(SAMLBindingContext.class, true)).setHasBindingSignature(true);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        ECPContext ecp = (ECPContext)this.prc.getOutboundMessageContext().getSubcontext(ECPContext.class);
        Assert.assertTrue((boolean)ecp.isRequestAuthenticated());
        Assert.assertNull((Object)ecp.getSessionKey());
    }

    @Test
    public void testUnencrypted() throws ComponentInitializationException {
        this.action.setRequireEncryption(false);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        ECPContext ecp = (ECPContext)this.prc.getOutboundMessageContext().getSubcontext(ECPContext.class);
        Assert.assertNotNull((Object)ecp.getSessionKey());
    }

    @Test
    public void testEncrypted() throws ComponentInitializationException {
        ((EncryptionContext)this.prc.getOutboundMessageContext().getSubcontext(EncryptionContext.class, true)).setAssertionEncryptionParameters(new EncryptionParameters());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        ECPContext ecp = (ECPContext)this.prc.getOutboundMessageContext().getSubcontext(ECPContext.class);
        Assert.assertNotNull((Object)ecp.getSessionKey());
    }
}

