/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.io.IOException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.binding.artifact.impl.BasicSAMLArtifactMap;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.impl.ResolveArtifact;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ResolveArtifactTest
extends OpenSAMLInitBaseTestCase {
    private BasicSAMLArtifactMap artifactMap;
    private ProfileRequestContext prc;
    private ResolveArtifact action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().setOutboundMessage((Object)SAML2ActionTestingSupport.buildArtifactResponse()).buildProfileRequestContext();
        ((SAMLPeerEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).setEntityId("SP");
        this.artifactMap = new BasicSAMLArtifactMap();
        this.artifactMap.initialize();
        this.action = new ResolveArtifact();
        this.action.setArtifactMap((SAMLArtifactMap)this.artifactMap);
        this.action.setIssuerLookupStrategy(FunctionSupport.constant((Object)"IdP"));
        this.action.initialize();
    }

    @Test
    public void testNoRequest() {
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoArtifacts() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildArtifactResolve(null));
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoResponse() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildArtifactResolve((String)"foo"));
        this.prc.getOutboundMessageContext().setMessage(null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testMissingArtifacts() throws IOException {
        this.artifactMap.put("bar", "SP", "IdP", (SAMLObject)SAML2ActionTestingSupport.buildResponse());
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildArtifactResolve((String)"foo"));
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToResolveArtifact");
        Assert.assertNull((Object)((ArtifactResponse)this.prc.getOutboundMessageContext().getMessage()).getMessage());
    }

    @Test
    public void testWrongSP() throws IOException {
        this.artifactMap.put("foo", "SP2", "IdP", (SAMLObject)SAML2ActionTestingSupport.buildResponse());
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildArtifactResolve((String)"foo"));
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToResolveArtifact");
        Assert.assertNull((Object)((ArtifactResponse)this.prc.getOutboundMessageContext().getMessage()).getMessage());
        Assert.assertNull((Object)this.artifactMap.get("foo"));
    }

    @Test
    public void testWrongIdP() throws IOException {
        this.artifactMap.put("foo", "SP", "IdP2", (SAMLObject)SAML2ActionTestingSupport.buildResponse());
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildArtifactResolve((String)"foo"));
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToResolveArtifact");
        Assert.assertNull((Object)((ArtifactResponse)this.prc.getOutboundMessageContext().getMessage()).getMessage());
        Assert.assertNull((Object)this.artifactMap.get("foo"));
    }

    @Test
    public void testOne() throws IOException {
        this.artifactMap.put("foo", "SP", "IdP", (SAMLObject)SAML2ActionTestingSupport.buildResponse());
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildArtifactResolve((String)"foo"));
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertTrue((boolean)(((ArtifactResponse)this.prc.getOutboundMessageContext().getMessage()).getMessage() instanceof Response));
        Assert.assertNull((Object)this.artifactMap.get("foo"));
    }
}

