/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationProcessingData;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.tests.MockAssertionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.impl.MockAssertionValidationContextBuilder;
import org.opensaml.saml.saml2.profile.impl.ValidateAssertions;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private ValidateAssertions action;
    private ProfileRequestContext prc;
    private Response samlResponse;
    private Map<Assertion, Object> resultsMap;
    private MockHttpServletRequest httpRequest;
    private MockHttpServletResponse httpResponse;

    @BeforeMethod
    public void beforeMethod() {
        this.httpRequest = new MockHttpServletRequest();
        this.httpResponse = new MockHttpServletResponse();
        this.resultsMap = new HashMap<Assertion, Object>();
        this.action = new ValidateAssertions();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            public MockHttpServletRequest get() {
                return ValidateAssertionsTest.this.httpRequest;
            }
        });
        this.action.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            public HttpServletResponse get() {
                return ValidateAssertionsTest.this.httpResponse;
            }
        });
        this.action.setValidationContextBuilder((Function)new MockAssertionValidationContextBuilder());
        this.action.setAssertionValidator((SAML20AssertionValidator)new MockAssertionValidator(this.resultsMap));
        this.samlResponse = SAML2ActionTestingSupport.buildResponse();
        this.samlResponse.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.prc = new RequestContextBuilder().setInboundMessage((Object)this.samlResponse).buildProfileRequestContext();
    }

    @Test
    public void testValid() throws ComponentInitializationException {
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.VALID);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.VALID);
    }

    @Test
    public void testInvalid() throws ComponentInitializationException {
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INVALID);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"AssertionInvalid");
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INVALID);
    }

    @Test
    public void testIndeterminate() throws ComponentInitializationException {
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INDETERMINATE);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"AssertionInvalid");
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INDETERMINATE);
    }

    @Test
    public void testInvalidNonFatal() throws ComponentInitializationException {
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INVALID);
        this.action.setInvalidFatal(false);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INVALID);
    }

    @Test
    public void testIndeterminateNonFatal() throws ComponentInitializationException {
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INDETERMINATE);
        this.action.setInvalidFatal(false);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INDETERMINATE);
    }

    @Test
    public void testMultipleValid() throws ComponentInitializationException {
        this.samlResponse.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.VALID);
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(1), ValidationResult.VALID);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.VALID);
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(1), ValidationResult.VALID);
    }

    @Test
    public void testMultipleMixed() throws ComponentInitializationException {
        this.samlResponse.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INVALID);
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(1), ValidationResult.VALID);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"AssertionInvalid");
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INVALID);
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(1), ValidationResult.VALID);
    }

    @Test
    public void testMultipleMixedNonFatal() throws ComponentInitializationException {
        this.samlResponse.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INVALID);
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(1), ValidationResult.VALID);
        this.action.setInvalidFatal(false);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.INVALID);
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(1), ValidationResult.VALID);
    }

    @Test
    public void testValidatorLookup() throws ComponentInitializationException {
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.VALID);
        this.action.setAssertionValidator(null);
        this.action.setAssertionValidatorLookup(input -> new MockAssertionValidator(this.resultsMap));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.VALID);
    }

    @Test
    public void testValidatorLookupFails() throws ComponentInitializationException {
        this.action.setAssertionValidator(null);
        this.action.setAssertionValidatorLookup(input -> null);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToValidateAssertion");
    }

    @Test
    public void testCustomAssertionResolution() throws ComponentInitializationException {
        Assertion assertion1 = SAML2ActionTestingSupport.buildAssertion();
        this.resultsMap.put(assertion1, ValidationResult.VALID);
        this.action.setAssertionResolver(input -> Collections.singletonList(assertion1));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        this.checkObjectMetadata(assertion1, ValidationResult.VALID);
        this.checkObjectMetadataEmpty((Assertion)this.samlResponse.getAssertions().get(0));
    }

    @Test
    public void testNoAssertions() throws ComponentInitializationException {
        this.action.setAssertionResolver(input -> Collections.emptyList());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }

    @Test
    public void testValidationThrows() throws ComponentInitializationException {
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), new AssertionValidationException());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToValidateAssertion");
        this.checkObjectMetadataEmpty((Assertion)this.samlResponse.getAssertions().get(0));
    }

    @Test
    public void testValidationThrowsUnchecked() throws ComponentInitializationException {
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), new RuntimeException());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToValidateAssertion");
        this.checkObjectMetadataEmpty((Assertion)this.samlResponse.getAssertions().get(0));
    }

    @Test
    public void testValidationThrowsMultiple() throws ComponentInitializationException {
        this.samlResponse.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.samlResponse.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.VALID);
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(1), new AssertionValidationException());
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(2), ValidationResult.VALID);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToValidateAssertion");
        this.checkObjectMetadata((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.VALID);
        this.checkObjectMetadataEmpty((Assertion)this.samlResponse.getAssertions().get(1));
        this.checkObjectMetadataEmpty((Assertion)this.samlResponse.getAssertions().get(2));
    }

    @Test
    public void testUnableToBuildValidationContext() throws ComponentInitializationException {
        this.resultsMap.put((Assertion)this.samlResponse.getAssertions().get(0), ValidationResult.VALID);
        this.action.setValidationContextBuilder(input -> null);
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToValidateAssertion");
        this.checkObjectMetadataEmpty((Assertion)this.samlResponse.getAssertions().get(0));
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoAssertionResolver() throws ComponentInitializationException {
        this.action.setAssertionResolver(null);
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoValidators() throws ComponentInitializationException {
        this.action.setAssertionValidator(null);
        this.action.setAssertionValidatorLookup(null);
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoHttpRequest() throws ComponentInitializationException {
        this.action.setHttpServletRequestSupplier(null);
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoContextBuilder() throws ComponentInitializationException {
        this.action.setValidationContextBuilder(null);
        this.action.initialize();
    }

    public void checkObjectMetadata(Assertion assertion, ValidationResult result) {
        List dataItems = assertion.getObjectMetadata().get(ValidationProcessingData.class);
        Assert.assertNotNull((Object)dataItems);
        Assert.assertEquals((int)dataItems.size(), (int)1);
        ValidationProcessingData data = (ValidationProcessingData)dataItems.get(0);
        Assert.assertEquals((Object)data.getResult(), (Object)result);
        Assert.assertNotNull((Object)data.getContext());
    }

    public void checkObjectMetadataEmpty(Assertion assertion) {
        Assert.assertTrue((boolean)assertion.getObjectMetadata().get(ValidationProcessingData.class).isEmpty());
    }
}

