/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.wssecurity.messaging.impl;

import java.net.URISyntaxException;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.opensaml.saml.saml2.wssecurity.SAML20AssertionToken;
import org.opensaml.saml.saml2.wssecurity.messaging.impl.SAML20AssertionTokenValidationInput;
import org.opensaml.saml.saml2.wssecurity.messaging.impl.WSSecuritySAML20AssertionTokenSecurityHandler;
import org.opensaml.security.SecurityException;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.util.SOAPSupport;
import org.opensaml.soap.wssecurity.Security;
import org.opensaml.soap.wssecurity.WSSecurityConstants;
import org.opensaml.soap.wssecurity.messaging.Token;
import org.opensaml.soap.wssecurity.messaging.WSSecurityContext;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class WSSecuritySAML20AssertionTokenSecurityHandlerTest
extends XMLObjectBaseTestCase {
    private WSSecuritySAML20AssertionTokenSecurityHandler handler;
    private MessageContext messageContext;
    private MockHttpServletRequest httpServletRequest;
    private Assertion assertion;
    private SubjectConfirmation subjectConfirmation;
    private String issuerEntityID = "https://idp.example.org";
    private String rpEntityID = "https://rp.example.com";
    private String remoteAddr = "10.1.2.3";

    @BeforeMethod
    protected void setUp() throws CertificateException, URISyntaxException, KeyException, SecurityException, MarshallingException, SignatureException {
        this.assertion = this.buildAssertion();
        this.messageContext = this.buildMessageContext();
        this.httpServletRequest = this.buildHttpServletRequest();
        this.handler = new WSSecuritySAML20AssertionTokenSecurityHandler();
        this.handler.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            public HttpServletRequest get() {
                return WSSecuritySAML20AssertionTokenSecurityHandlerTest.this.httpServletRequest;
            }
        });
    }

    @Test
    public void testDefaultsValid() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setAssertionValidator((SAML20AssertionValidator)new MockAssertionValidator(ValidationResult.VALID, this.subjectConfirmation, false));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        WSSecurityContext securityContext = (WSSecurityContext)this.messageContext.getSubcontext(WSSecurityContext.class);
        Assert.assertNotNull((Object)securityContext);
        Assert.assertEquals((int)securityContext.getTokens().size(), (int)1);
        Assert.assertTrue((boolean)(securityContext.getTokens().get(0) instanceof SAML20AssertionToken));
        SAML20AssertionToken token = (SAML20AssertionToken)securityContext.getTokens().get(0);
        Assert.assertSame((Object)token.getWrappedToken(), (Object)this.assertion);
        Assert.assertEquals((Object)token.getValidationStatus(), (Object)Token.ValidationStatus.VALID);
        Assert.assertSame((Object)token.getSubjectConfirmation(), (Object)this.subjectConfirmation);
    }

    @Test
    public void testDefaultsInvalid() throws ComponentInitializationException {
        this.handler.setAssertionValidator((SAML20AssertionValidator)new MockAssertionValidator(ValidationResult.INVALID, null, false));
        this.handler.initialize();
        try {
            this.handler.invoke(this.messageContext);
            Assert.fail((String)"Assertion validation should have failed");
        }
        catch (MessageHandlerException e) {
            Fault fault = ((SOAP11Context)this.messageContext.getSubcontext(SOAP11Context.class, true)).getFault();
            Assert.assertNotNull((Object)fault);
            Assert.assertEquals((Object)fault.getCode().getValue(), (Object)WSSecurityConstants.SOAP_FAULT_INVALID_SECURITY_TOKEN);
        }
    }

    @Test
    public void testDefaultsIndeterminate() throws ComponentInitializationException {
        this.handler.setAssertionValidator((SAML20AssertionValidator)new MockAssertionValidator(ValidationResult.INDETERMINATE, null, false));
        this.handler.initialize();
        try {
            this.handler.invoke(this.messageContext);
            Assert.fail((String)"Assertion validation should have failed");
        }
        catch (MessageHandlerException e) {
            Fault fault = ((SOAP11Context)this.messageContext.getSubcontext(SOAP11Context.class, true)).getFault();
            Assert.assertNotNull((Object)fault);
            Assert.assertEquals((Object)fault.getCode().getValue(), (Object)WSSecurityConstants.SOAP_FAULT_INVALID_SECURITY_TOKEN);
        }
    }

    @Test
    public void testValidViaLookup() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setAssertionValidator(null);
        this.handler.setAssertionValidatorLookup((Function)new Function<Pair<MessageContext, Assertion>, SAML20AssertionValidator>(){

            @Override
            @Nullable
            public SAML20AssertionValidator apply(@Nullable Pair<MessageContext, Assertion> input) {
                return new MockAssertionValidator(ValidationResult.VALID, WSSecuritySAML20AssertionTokenSecurityHandlerTest.this.subjectConfirmation, false);
            }
        });
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        WSSecurityContext securityContext = (WSSecurityContext)this.messageContext.getSubcontext(WSSecurityContext.class);
        Assert.assertNotNull((Object)securityContext);
        Assert.assertEquals((int)securityContext.getTokens().size(), (int)1);
        Assert.assertTrue((boolean)(securityContext.getTokens().get(0) instanceof SAML20AssertionToken));
        SAML20AssertionToken token = (SAML20AssertionToken)securityContext.getTokens().get(0);
        Assert.assertSame((Object)token.getWrappedToken(), (Object)this.assertion);
        Assert.assertEquals((Object)token.getValidationStatus(), (Object)Token.ValidationStatus.VALID);
        Assert.assertSame((Object)token.getSubjectConfirmation(), (Object)this.subjectConfirmation);
    }

    @Test
    public void testInvalidNotFatal() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setInvalidFatal(false);
        this.handler.setAssertionValidator((SAML20AssertionValidator)new MockAssertionValidator(ValidationResult.INVALID, null, false));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        WSSecurityContext securityContext = (WSSecurityContext)this.messageContext.getSubcontext(WSSecurityContext.class);
        Assert.assertNotNull((Object)securityContext);
        Assert.assertEquals((int)securityContext.getTokens().size(), (int)1);
        Assert.assertTrue((boolean)(securityContext.getTokens().get(0) instanceof SAML20AssertionToken));
        SAML20AssertionToken token = (SAML20AssertionToken)securityContext.getTokens().get(0);
        Assert.assertSame((Object)token.getWrappedToken(), (Object)this.assertion);
        Assert.assertEquals((Object)token.getValidationStatus(), (Object)Token.ValidationStatus.INVALID);
        Assert.assertSame((Object)token.getSubjectConfirmation(), null);
    }

    @Test
    public void testIndeterminateNotFatal() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setInvalidFatal(false);
        this.handler.setAssertionValidator((SAML20AssertionValidator)new MockAssertionValidator(ValidationResult.INDETERMINATE, null, false));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        WSSecurityContext securityContext = (WSSecurityContext)this.messageContext.getSubcontext(WSSecurityContext.class);
        Assert.assertNotNull((Object)securityContext);
        Assert.assertEquals((int)securityContext.getTokens().size(), (int)1);
        Assert.assertTrue((boolean)(securityContext.getTokens().get(0) instanceof SAML20AssertionToken));
        SAML20AssertionToken token = (SAML20AssertionToken)securityContext.getTokens().get(0);
        Assert.assertSame((Object)token.getWrappedToken(), (Object)this.assertion);
        Assert.assertEquals((Object)token.getValidationStatus(), (Object)Token.ValidationStatus.INDETERMINATE);
        Assert.assertSame((Object)token.getSubjectConfirmation(), null);
    }

    @Test
    public void testException() throws ComponentInitializationException {
        this.handler.setAssertionValidator((SAML20AssertionValidator)new MockAssertionValidator(null, null, true));
        this.handler.initialize();
        try {
            this.handler.invoke(this.messageContext);
            Assert.fail((String)"Assertion validation should have failed");
        }
        catch (MessageHandlerException e) {
            Fault fault = ((SOAP11Context)this.messageContext.getSubcontext(SOAP11Context.class, true)).getFault();
            Assert.assertNotNull((Object)fault);
            Assert.assertEquals((Object)fault.getCode().getValue(), (Object)FaultCode.SERVER);
        }
    }

    @Test
    public void testNonSOAP() throws ComponentInitializationException, MessageHandlerException {
        this.messageContext.removeSubcontext(SOAP11Context.class);
        this.handler.setAssertionValidator((SAML20AssertionValidator)new MockAssertionValidator(ValidationResult.VALID, this.subjectConfirmation, false));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        WSSecurityContext securityContext = (WSSecurityContext)this.messageContext.getSubcontext(WSSecurityContext.class);
        Assert.assertNull((Object)securityContext);
    }

    @Test
    public void testNoAssertions() throws ComponentInitializationException, MessageHandlerException {
        ((SOAP11Context)this.messageContext.getSubcontext(SOAP11Context.class)).getEnvelope().getHeader().getUnknownXMLObjects().clear();
        this.handler.setAssertionValidator((SAML20AssertionValidator)new MockAssertionValidator(ValidationResult.VALID, this.subjectConfirmation, false));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        WSSecurityContext securityContext = (WSSecurityContext)this.messageContext.getSubcontext(WSSecurityContext.class);
        Assert.assertNull((Object)securityContext);
    }

    @Test
    public void testNoHeader() throws ComponentInitializationException, MessageHandlerException {
        ((SOAP11Context)this.messageContext.getSubcontext(SOAP11Context.class)).getEnvelope().setHeader(null);
        this.handler.setAssertionValidator((SAML20AssertionValidator)new MockAssertionValidator(ValidationResult.VALID, this.subjectConfirmation, false));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        WSSecurityContext securityContext = (WSSecurityContext)this.messageContext.getSubcontext(WSSecurityContext.class);
        Assert.assertNull((Object)securityContext);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoValidatorOrLookup() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setAssertionValidator(null);
        this.handler.setAssertionValidatorLookup(null);
        this.handler.initialize();
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNoValidatorAndFailedLookup() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setAssertionValidator(null);
        this.handler.setAssertionValidatorLookup((Function)new Function<Pair<MessageContext, Assertion>, SAML20AssertionValidator>(){

            @Override
            @Nullable
            public SAML20AssertionValidator apply(@Nullable Pair<MessageContext, Assertion> input) {
                return null;
            }
        });
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testBadValidationContextBuilder() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setValidationContextBuilder((Function)new Function<SAML20AssertionTokenValidationInput, ValidationContext>(){

            @Override
            @Nullable
            public ValidationContext apply(@Nullable SAML20AssertionTokenValidationInput input) {
                return null;
            }
        });
        this.handler.setAssertionValidator((SAML20AssertionValidator)new MockAssertionValidator(ValidationResult.VALID, this.subjectConfirmation, false));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
    }

    private MessageContext buildMessageContext() {
        MessageContext mc = new MessageContext();
        ((SAMLSelfEntityContext)mc.getSubcontext(SAMLSelfEntityContext.class, true)).setEntityId(this.rpEntityID);
        XMLObject payload = this.buildXMLObject(simpleXMLObjectQName);
        mc.setMessage((Object)payload);
        if (this.assertion == null) {
            throw new RuntimeException("Assertion wasn't built");
        }
        Envelope envelope = (Envelope)this.buildXMLObject(Envelope.DEFAULT_ELEMENT_NAME);
        envelope.setBody((Body)this.buildXMLObject(Body.DEFAULT_ELEMENT_NAME));
        envelope.getBody().getUnknownXMLObjects().add(payload);
        envelope.setHeader((Header)this.buildXMLObject(Header.DEFAULT_ELEMENT_NAME));
        Security security = (Security)this.buildXMLObject(Security.ELEMENT_NAME);
        SOAPSupport.addSOAP11MustUnderstandAttribute((XMLObject)security, (boolean)true);
        security.getUnknownXMLObjects().add(this.assertion);
        envelope.getHeader().getUnknownXMLObjects().add(security);
        ((SOAP11Context)mc.getSubcontext(SOAP11Context.class, true)).setEnvelope(envelope);
        return mc;
    }

    private MockHttpServletRequest buildHttpServletRequest() throws URISyntaxException, CertificateException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.setServerName("rp.example.com");
        request.setServerPort(443);
        request.setRequestURI("/wss/saml");
        request.setRemoteAddr(this.remoteAddr);
        return request;
    }

    private Assertion buildAssertion() throws SecurityException, MarshallingException, SignatureException {
        Assertion a = SAML2ActionTestingSupport.buildAssertion();
        a.setIssuer(SAML2ActionTestingSupport.buildIssuer((String)this.issuerEntityID));
        a.setSubject(SAML2ActionTestingSupport.buildSubject((String)"barney"));
        this.subjectConfirmation = (SubjectConfirmation)this.buildXMLObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        this.subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        a.getSubject().getSubjectConfirmations().add(this.subjectConfirmation);
        a.getAuthnStatements().add(SAML2ActionTestingSupport.buildAuthnStatement());
        return a;
    }

    private static class MockAssertionValidator
    extends SAML20AssertionValidator {
        private ValidationResult validationResult;
        private boolean isThrowException;
        private SubjectConfirmation confirmedSubjectConfirmation;

        public MockAssertionValidator(ValidationResult result, SubjectConfirmation confirmed, boolean throwException) {
            super(null, null, null, null, null);
            this.validationResult = result;
            this.confirmedSubjectConfirmation = confirmed;
            this.isThrowException = throwException;
        }

        @Nonnull
        public ValidationResult validate(@Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
            if (this.isThrowException) {
                throw new AssertionValidationException();
            }
            if (this.confirmedSubjectConfirmation != null) {
                context.getDynamicParameters().put("saml2.ConfirmedSubjectConfirmation", this.confirmedSubjectConfirmation);
            }
            return this.validationResult;
        }
    }
}

