/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.security.impl;

import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.testing.SAMLTestSupport;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.saml.security.impl.SAMLMDCredentialContext;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class MetadataCredentialResolverTest
extends XMLObjectBaseTestCase {
    private String idpRSAPubKeyName = "IDP-SSO-RSA-Key";
    private RSAPublicKey idpRSAPubKey;
    private String idpRSAPubKeyBase64 = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDfCVgF2Lvhu0Q35FvmAVGMXc3i1MojcqybcfVbfn0Tg/Aj5FvuAiDFg9KpGvMHDKdLOY+1xsKZqyIm58SFhW+5z51YpnblHGjuDtPtPbtspQ7pAOsknnvbKZrx7RGNOJyQZE3Qn88Y5ZBNzABusqNXjrWlU9m4a+XNIFqM4YbJLwIDAQAB";
    private X509Certificate idpDSACert;
    private String idpDSACertBase64 = "MIIECTCCAvGgAwIBAgIBMzANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyNTIwMTYxMVoXDTE3MDUyMjIwMTYxMVowGjEYMBYGA1UEAxMPaWRwLmV4YW1wbGUub3JnMIIBtjCCASsGByqGSM44BAEwggEeAoGBAI+ktw7R9m7TxjaCrT2MHwWNQUAyXPrqbFCcu+DCirr861U6R6W/GyqWdcy8/D1Hh/I1U94POQn5yfqVPpVH2ZRS4OMFndHWaoo9V5LJoXTXHiDYB3W4t9tn0fm7It0n7VoUI5C4y9LG32Hq+UIGF/ktNTmo//mEqLS6aJNdbMFpAhUArmKGh0hcpmjukYArWcMRvipB4CMCgYBuCiCrUaHBRRtqrk0P/Luq0l2M2718GwSGeLPZip06gACDG7IctMrgH1J+ZIjsx6vffi977wnMDiktqacmaobV+SCRW9ijJRdkYpUHmlLvuJGnDPjkvewpbGWJsCabpWEvWdYw3ma8RuHOPj4Jkrdd4VcRaFwox/fPJ7cG6kBydgOBhAACgYBxQIPv9DCsmiMHG1FAxSARX0GcRiELJPJ+MtaStdTrVobNa2jebwc3npLiTvUR4U/CDo1mSZb+Sp/wian8kNZHmGcR6KbtJs9UDsa3V0pbbgpUar4HcxV+NQJBbhn9RGu85g3PDILUrINiUAf26mhPN5Y0paM+HbM68nUf1OLv16OBsjCBrzAJBgNVHRMEAjAAMCwGCWCGSAGG+EIBDQQfFh1PcGVuU1NMIEdlbmVyYXRlZCBDZXJ0aWZpY2F0ZTAdBgNVHQ4EFgQUIHFAEB/3jIIZzJEJ/qdsuI8vN3kwVQYDVR0jBE4wTIAU1e5lU95R2oetQupBbvKv1u5GlAuhMaQvMC0xEjAQBgNVBAoTCUludGVybmV0MjEXMBUGA1UEAxMOY2EuZXhhbXBsZS5vcmeCAQEwDQYJKoZIhvcNAQEFBQADggEBAJt4Q34+pqjW5tHHhkdzTITSBjOOf8EvYMgxTMRzhagLSHTt9RgO5i/G7ELvnwe1j6187m1XD9iEAWKeKbB//ljeOpgnwzkLR9Er5tr1RI3cbil0AX+oX0c1jfRaQnR50Rfb5YoNX6G963iphlxp9C8VLB6eOk/S270XoWoQIkO1ioQ8JY4HE6AyDsOpJaOmHpBaxjgsiko52ZWZeZyaCyL98BXwVxeml7pYnHlXWWidB0N/Zy+LbvWg3urUkiDjMcB6nGImmEfDSxRdybitcMwbwL26z2WOpwL3llm3mcCydKXgXt8IQhfDhOZOHWckeD2tStnJRP/cqBgO62/qirw=";
    private X509Certificate idpRSACert;
    private String idpRSACertBase64 = "MIIC8TCCAdmgAwIBAgIBMjANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyNTIwMDk1MVoXDTE3MDUyMjIwMDk1MVowGjEYMBYGA1UEAxMPaWRwLmV4YW1wbGUub3JnMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDfCVgF2Lvhu0Q35FvmAVGMXc3i1MojcqybcfVbfn0Tg/Aj5FvuAiDFg9KpGvMHDKdLOY+1xsKZqyIm58SFhW+5z51YpnblHGjuDtPtPbtspQ7pAOsknnvbKZrx7RGNOJyQZE3Qn88Y5ZBNzABusqNXjrWlU9m4a+XNIFqM4YbJLwIDAQABo4GyMIGvMAkGA1UdEwQCMAAwLAYJYIZIAYb4QgENBB8WHU9wZW5TU0wgR2VuZXJhdGVkIENlcnRpZmljYXRlMB0GA1UdDgQWBBT2qDRFTzawttBGjN6wxni/12tQQjBVBgNVHSMETjBMgBTV7mVT3lHah61C6kFu8q/W7kaUC6ExpC8wLTESMBAGA1UEChMJSW50ZXJuZXQyMRcwFQYDVQQDEw5jYS5leGFtcGxlLm9yZ4IBATANBgkqhkiG9w0BAQUFAAOCAQEAlJYAou5ko3ujHVhOc4OB2AOOqdXAjThiXg6zTjezs7/F53b9IRt4in/k92y1tKZ87F/JcnH6MrzKfb8m5XtcYwtUSvmFTCp5rrFpz1JhXlgnaWVJJ2G2vKLDGuPQvLV9zsWhnkbTPuzocvOotxl7w7LJvO3D/tzTAnnUbgg1AfP+CTDs3F/ceHzWGVWTMUAmNGX8gMS2/xh66QoEzl7LBG8Xzpo0j+gSxe7hScb5iS4U/XUEbZylMUbbK57h9Bez8VVeO1jfwAniIBT0Ur9ksiYsAdyXYoXssGiFbKW1K3QG1GA9wwGy5GvjyALuuXL4lEzFB0kMsGucNMfyyojX9A==";
    private String keyAuthorityCertBase64 = "MIIDXTCCAkWgAwIBAgIBATANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDQwOTA1NDcxMloXDTE3MDQwNjA1NDcxMlowLTESMBAGA1UEChMJSW50ZXJuZXQyMRcwFQYDVQQDEw5jYS5leGFtcGxlLm9yZzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANxM5/6mBCcX+S7HApcKtfqdFRZzi6Ra91nkEzXOUcO+BPUdYqSxKGnCCso25ZOZP3gnJVkY8Pi7VWrCM6wRgIMyQDvNYqCpNjkZGFkrMoa6fm8BSaDHJ1fz6l/eEl0CVU3UuUAf0mXQLGm6Jannq8aMolRujlhE5iRaOJ2qp6wqsvyatK+vTgDngnwYVa4Cqu0jUeNF28quST5D3gIuZ0OeFHSM2Z1WUKkwwsHqVkxBBcH1QE1JOGIoSnrxxl/o4VlLWGEI8zq5qixE8VYtBBmijBwIL5ETy2fwiqcsvimQaQAtAfbtpO3kBSs8n7nnzMUHfRlcebGkwwcNfYcD5hcCAwEAAaOBhzCBhDAdBgNVHQ4EFgQU1e5lU95R2oetQupBbvKv1u5GlAswVQYDVR0jBE4wTIAU1e5lU95R2oetQupBbvKv1u5GlAuhMaQvMC0xEjAQBgNVBAoTCUludGVybmV0MjEXMBUGA1UEAxMOY2EuZXhhbXBsZS5vcmeCAQEwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAbqrozetM/iBVIUir9k14HbLEP0lZ6jOPWFIUFXMOn0t8+Ul7PMp9Rdn+7OGQIoJw97/mam3kpQ/HmjJMFYv6MGsDQ4vAOiQiaTKzgMhrnCdVpVH9uz4ARHiysCujnjH9sehTWgybY8pXzzSG5BAjEGowHq01nXxq2K4yAJSdAUBYLfuSKW1uRU6cmEa9uzl9EvoZfAF3BLnGlPqu4ZajH2NC9ZY0y19LX4yeJLHL1sY4fyxb3x8QhcCXiI16awBTr/VnUpJjSe9vh+OudWGeyCL/KhjlrDkjJ3hIxBF5mP/Y27cFpRnC2gECkieURvh52OyuqkzpbOrTN5rD9fNinA==";
    private String protocolFoo = "PROTOCOL_FOO";
    private String protocolBar = "PROTOCOL_BAR";
    private QName idpRole = IDPSSODescriptor.DEFAULT_ELEMENT_NAME;
    private String idpEntityID = "http://idp.example.org/shibboleth";
    private String mdFileName = "/org/opensaml/saml/security/test1-metadata.xml";
    private PredicateRoleDescriptorResolver roleResolver;
    private MetadataCredentialResolver mdCredResolver;
    private EntityIdCriterion entityIdCriteria;
    private EntityRoleCriterion roleCriteria;
    private CriteriaSet criteriaSet;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.idpRSAPubKey = KeySupport.buildJavaRSAPublicKey((String)this.idpRSAPubKeyBase64);
        this.idpDSACert = X509Support.decodeCertificate((String)this.idpDSACertBase64);
        this.idpRSACert = X509Support.decodeCertificate((String)this.idpRSACertBase64);
        X509Support.decodeCertificate((String)this.keyAuthorityCertBase64);
        Document mdDoc = parserPool.parse(MetadataCredentialResolverTest.class.getResourceAsStream(this.mdFileName));
        DOMMetadataResolver mdProvider = new DOMMetadataResolver(mdDoc.getDocumentElement());
        mdProvider.setId("test");
        mdProvider.initialize();
        this.roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)mdProvider);
        this.roleResolver.initialize();
        this.mdCredResolver = new MetadataCredentialResolver();
        this.mdCredResolver.setRoleDescriptorResolver((RoleDescriptorResolver)this.roleResolver);
        this.mdCredResolver.setKeyInfoCredentialResolver(SAMLTestSupport.buildBasicInlineKeyInfoResolver());
        this.mdCredResolver.initialize();
        this.entityIdCriteria = new EntityIdCriterion(this.idpEntityID);
        this.roleCriteria = new EntityRoleCriterion(this.idpRole);
        this.criteriaSet = new CriteriaSet();
        this.criteriaSet.add((Object)this.entityIdCriteria);
        this.criteriaSet.add((Object)this.roleCriteria);
    }

    @Test
    public void testNoProtocolNoUsage() throws SecurityException, ResolverException {
        ArrayList<Credential> resolved = new ArrayList<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(this.criteriaSet)) {
            resolved.add(credential);
            this.checkContextAndID(credential, this.idpEntityID, this.idpRole, true);
        }
        Assert.assertEquals((int)resolved.size(), (int)3, (String)"Incorrect number of credentials resolved");
        for (Credential credential : resolved) {
            switch (credential.getUsageType()) {
                case SIGNING: {
                    X509Credential x509Cred = (X509Credential)credential;
                    Assert.assertEquals((Object)x509Cred.getEntityCertificate(), (Object)this.idpDSACert, (String)"Unexpected value for certificate");
                    break;
                }
                case ENCRYPTION: {
                    Assert.assertTrue((boolean)credential.getKeyNames().contains(this.idpRSAPubKeyName), (String)"Expected value for key name not found");
                    Assert.assertEquals((Object)credential.getPublicKey(), (Object)this.idpRSAPubKey, (String)"Unexpected value for key");
                    break;
                }
                case UNSPECIFIED: {
                    X509Credential x509Cred = (X509Credential)credential;
                    Assert.assertEquals((Object)x509Cred.getEntityCertificate(), (Object)this.idpRSACert, (String)"Unexpected value for certificate");
                    break;
                }
            }
        }
    }

    @Test
    public void testNoProtocolUsageEncryption() throws SecurityException, ResolverException {
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        ArrayList<Credential> resolved = new ArrayList<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(this.criteriaSet)) {
            resolved.add(credential);
            this.checkContextAndID(credential, this.idpEntityID, this.idpRole, true);
        }
        Assert.assertEquals((int)resolved.size(), (int)2, (String)"Incorrect number of credentials resolved");
        for (Credential credential : resolved) {
            switch (credential.getUsageType()) {
                case SIGNING: {
                    Assert.fail((String)"Credential with invalid usage was resolved");
                    break;
                }
                case ENCRYPTION: {
                    Assert.assertTrue((boolean)credential.getKeyNames().contains(this.idpRSAPubKeyName), (String)"Expected value for key name not found");
                    Assert.assertEquals((Object)credential.getPublicKey(), (Object)this.idpRSAPubKey, (String)"Unexpected value for key");
                    break;
                }
                case UNSPECIFIED: {
                    X509Credential x509Cred = (X509Credential)credential;
                    Assert.assertEquals((Object)x509Cred.getEntityCertificate(), (Object)this.idpRSACert, (String)"Unexpected value for certificate");
                    break;
                }
            }
        }
    }

    @Test
    public void testNoProtocolUsageSigning() throws SecurityException, ResolverException {
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        ArrayList<Credential> resolved = new ArrayList<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(this.criteriaSet)) {
            resolved.add(credential);
            this.checkContextAndID(credential, this.idpEntityID, this.idpRole, true);
        }
        Assert.assertEquals((int)resolved.size(), (int)2, (String)"Incorrect number of credentials resolved");
        for (Credential credential : resolved) {
            switch (credential.getUsageType()) {
                case SIGNING: {
                    X509Credential x509Cred = (X509Credential)credential;
                    Assert.assertEquals((Object)x509Cred.getEntityCertificate(), (Object)this.idpDSACert, (String)"Unexpected value for certificate");
                    break;
                }
                case ENCRYPTION: {
                    Assert.fail((String)"Credential with invalid usage was resolved");
                    break;
                }
                case UNSPECIFIED: {
                    X509Credential x509Cred = (X509Credential)credential;
                    Assert.assertEquals((Object)x509Cred.getEntityCertificate(), (Object)this.idpRSACert, (String)"Unexpected value for certificate");
                    break;
                }
            }
        }
    }

    @Test
    public void testProtocolFOONoUsage() throws SecurityException, ResolverException {
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolFoo));
        ArrayList<Credential> resolved = new ArrayList<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(this.criteriaSet)) {
            resolved.add(credential);
            this.checkContextAndID(credential, this.idpEntityID, this.idpRole, true);
        }
        Assert.assertEquals((int)resolved.size(), (int)2, (String)"Incorrect number of credentials resolved");
        for (Credential credential : resolved) {
            switch (credential.getUsageType()) {
                case SIGNING: {
                    X509Credential x509Cred = (X509Credential)credential;
                    Assert.assertEquals((Object)x509Cred.getEntityCertificate(), (Object)this.idpDSACert, (String)"Unexpected value for certificate");
                    break;
                }
                case ENCRYPTION: {
                    Assert.assertTrue((boolean)credential.getKeyNames().contains(this.idpRSAPubKeyName), (String)"Expected value for key name not found");
                    Assert.assertEquals((Object)credential.getPublicKey(), (Object)this.idpRSAPubKey, (String)"Unexpected value for key");
                    break;
                }
                case UNSPECIFIED: {
                    Assert.fail((String)"Credential was resolved from invalid protocol");
                    break;
                }
            }
        }
    }

    @Test
    public void testProtocolFOOUsageSigning() throws SecurityException, ResolverException {
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolFoo));
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        ArrayList<Credential> resolved = new ArrayList<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(this.criteriaSet)) {
            resolved.add(credential);
            this.checkContextAndID(credential, this.idpEntityID, this.idpRole, true);
        }
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of credentials resolved");
        for (Credential credential : resolved) {
            switch (credential.getUsageType()) {
                case SIGNING: {
                    X509Credential x509Cred = (X509Credential)credential;
                    Assert.assertEquals((Object)x509Cred.getEntityCertificate(), (Object)this.idpDSACert, (String)"Unexpected value for certificate");
                    break;
                }
                case ENCRYPTION: {
                    Assert.fail((String)"Credential was resolved from invalid protocol or usage");
                    break;
                }
                case UNSPECIFIED: {
                    Assert.fail((String)"Credential was resolved from invalid protocol or usage");
                    break;
                }
            }
        }
    }

    @Test
    public void testProtocolFOOUsageEncryption() throws SecurityException, ResolverException {
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolFoo));
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        ArrayList<Credential> resolved = new ArrayList<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(this.criteriaSet)) {
            resolved.add(credential);
            this.checkContextAndID(credential, this.idpEntityID, this.idpRole, true);
        }
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of credentials resolved");
        for (Credential credential : resolved) {
            switch (credential.getUsageType()) {
                case SIGNING: {
                    Assert.fail((String)"Credential was resolved from invalid protocol or usage");
                    break;
                }
                case ENCRYPTION: {
                    Assert.assertTrue((boolean)credential.getKeyNames().contains(this.idpRSAPubKeyName), (String)"Expected value for key name not found");
                    Assert.assertEquals((Object)credential.getPublicKey(), (Object)this.idpRSAPubKey, (String)"Unexpected value for key");
                    break;
                }
                case UNSPECIFIED: {
                    Assert.fail((String)"Credential was resolved from invalid protocol or usage");
                    break;
                }
            }
        }
    }

    @Test
    public void testProtocolBARNoUsage() throws SecurityException, ResolverException {
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBar));
        ArrayList<Credential> resolved = new ArrayList<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(this.criteriaSet)) {
            resolved.add(credential);
            this.checkContextAndID(credential, this.idpEntityID, this.idpRole, true);
        }
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of credentials resolved");
        for (Credential credential : resolved) {
            switch (credential.getUsageType()) {
                case SIGNING: {
                    Assert.fail((String)"Credential was resolved from invalid protocol");
                    break;
                }
                case ENCRYPTION: {
                    Assert.fail((String)"Credential was resolved from invalid protocol");
                    break;
                }
                case UNSPECIFIED: {
                    X509Credential x509Cred = (X509Credential)credential;
                    Assert.assertEquals((Object)x509Cred.getEntityCertificate(), (Object)this.idpRSACert, (String)"Unexpected value for certificate");
                    break;
                }
            }
        }
    }

    @Test
    public void testProtocolBARUsageSigning() throws SecurityException, ResolverException {
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBar));
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        ArrayList<Credential> resolved = new ArrayList<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(this.criteriaSet)) {
            resolved.add(credential);
            this.checkContextAndID(credential, this.idpEntityID, this.idpRole, true);
        }
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of credentials resolved");
        for (Credential credential : resolved) {
            switch (credential.getUsageType()) {
                case SIGNING: {
                    Assert.fail((String)"Credential was resolved from invalid protocol or usage");
                    break;
                }
                case ENCRYPTION: {
                    Assert.fail((String)"Credential was resolved from invalid protocol or usage");
                    break;
                }
                case UNSPECIFIED: {
                    X509Credential x509Cred = (X509Credential)credential;
                    Assert.assertEquals((Object)x509Cred.getEntityCertificate(), (Object)this.idpRSACert, (String)"Unexpected value for certificate");
                    break;
                }
            }
        }
    }

    @Test
    public void testProtocolBARUsageEncryption() throws SecurityException, ResolverException {
        this.criteriaSet.add((Object)new ProtocolCriterion(this.protocolBar));
        this.criteriaSet.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        ArrayList<Credential> resolved = new ArrayList<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(this.criteriaSet)) {
            resolved.add(credential);
            this.checkContextAndID(credential, this.idpEntityID, this.idpRole, true);
        }
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of credentials resolved");
        for (Credential credential : resolved) {
            switch (credential.getUsageType()) {
                case SIGNING: {
                    Assert.fail((String)"Credential was resolved from invalid protocol or usage");
                    break;
                }
                case ENCRYPTION: {
                    Assert.fail((String)"Credential was resolved from invalid protocol or usage");
                    break;
                }
                case UNSPECIFIED: {
                    X509Credential x509Cred = (X509Credential)credential;
                    Assert.assertEquals((Object)x509Cred.getEntityCertificate(), (Object)this.idpRSACert, (String)"Unexpected value for certificate");
                    break;
                }
            }
        }
    }

    @Test
    public void testCaching() throws SecurityException, ResolverException {
        HashSet<Credential> resolved1 = new HashSet<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(this.criteriaSet)) {
            resolved1.add(credential);
        }
        HashSet<Credential> resolved2 = new HashSet<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(this.criteriaSet)) {
            resolved2.add(credential);
        }
        Assert.assertEquals((int)resolved1.size(), (int)3, (String)"Incorrect number of credentials resolved");
        Assert.assertEquals((int)resolved2.size(), (int)3, (String)"Incorrect number of credentials resolved");
        Assert.assertTrue((boolean)resolved1.equals(resolved2), (String)"Resolved credential sets were non-equal, caching must have failed");
    }

    @Test
    public void testDirectResolutionFromRoleDescriptor() throws ComponentInitializationException, ResolverException, CertificateEncodingException, EncodingException {
        this.mdCredResolver = new MetadataCredentialResolver();
        this.mdCredResolver.setKeyInfoCredentialResolver(SAMLTestSupport.buildBasicInlineKeyInfoResolver());
        this.mdCredResolver.initialize();
        EntityDescriptor entityDesc = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        entityDesc.setEntityID(this.idpEntityID);
        IDPSSODescriptor idpSSODesc = (IDPSSODescriptor)this.buildXMLObject(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        idpSSODesc.setParent((XMLObject)entityDesc);
        KeyDescriptor keyDesc1 = (KeyDescriptor)this.buildXMLObject(KeyDescriptor.DEFAULT_ELEMENT_NAME);
        KeyInfo keyInfo1 = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        KeyInfoSupport.addPublicKey((KeyInfo)keyInfo1, (PublicKey)this.idpRSAPubKey);
        KeyInfoSupport.addKeyName((KeyInfo)keyInfo1, (String)this.idpRSAPubKeyName);
        keyDesc1.setKeyInfo(keyInfo1);
        keyDesc1.setUse(UsageType.ENCRYPTION);
        idpSSODesc.getKeyDescriptors().add(keyDesc1);
        KeyDescriptor keyDesc2 = (KeyDescriptor)this.buildXMLObject(KeyDescriptor.DEFAULT_ELEMENT_NAME);
        KeyInfo keyInfo2 = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        KeyInfoSupport.addCertificate((KeyInfo)keyInfo2, (X509Certificate)this.idpRSACert);
        keyDesc2.setKeyInfo(keyInfo2);
        keyDesc2.setUse(UsageType.SIGNING);
        idpSSODesc.getKeyDescriptors().add(keyDesc2);
        RoleDescriptorCriterion roleDescCriterion = new RoleDescriptorCriterion((RoleDescriptor)idpSSODesc);
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{roleDescCriterion});
        ArrayList<Credential> resolved = new ArrayList<Credential>();
        for (Credential credential : this.mdCredResolver.resolve(criteria)) {
            resolved.add(credential);
            this.checkContextAndID(credential, this.idpEntityID, this.idpRole, false);
        }
        Assert.assertEquals((int)resolved.size(), (int)2);
        for (Credential credential : resolved) {
            switch (credential.getUsageType()) {
                case SIGNING: {
                    X509Credential x509Cred = (X509Credential)credential;
                    Assert.assertEquals((Object)x509Cred.getEntityCertificate(), (Object)this.idpRSACert, (String)"Unexpected value for certificate");
                    break;
                }
                case ENCRYPTION: {
                    Assert.assertTrue((boolean)credential.getKeyNames().contains(this.idpRSAPubKeyName));
                    Assert.assertEquals((Object)credential.getPublicKey(), (Object)this.idpRSAPubKey, (String)"Unexpected value for public key");
                    break;
                }
                case UNSPECIFIED: {
                    Assert.fail((String)"Credential was resolved with an invalid usage");
                    break;
                }
            }
        }
    }

    @Test(expectedExceptions={ResolverException.class})
    public void testMissingRequiredInputs() throws ResolverException {
        this.mdCredResolver.resolve(new CriteriaSet());
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testMissingKeyInfoCredentialResolver() throws ComponentInitializationException {
        this.mdCredResolver = new MetadataCredentialResolver();
        this.mdCredResolver.initialize();
    }

    @Test(expectedExceptions={ResolverException.class})
    public void testMissingRequiredRoleDescriptorResolver() throws ComponentInitializationException, ResolverException {
        this.mdCredResolver = new MetadataCredentialResolver();
        this.mdCredResolver.setKeyInfoCredentialResolver(SAMLTestSupport.buildBasicInlineKeyInfoResolver());
        this.mdCredResolver.initialize();
        this.mdCredResolver.resolve(this.criteriaSet);
    }

    private void checkContextAndID(Credential credential, String entityID, QName role, boolean checkEntitiesDesc) {
        Assert.assertEquals((String)credential.getEntityId(), (String)entityID, (String)"Unexpected value found for credential entityID");
        SAMLMDCredentialContext mdContext = (SAMLMDCredentialContext)credential.getCredentialContextSet().get(SAMLMDCredentialContext.class);
        Assert.assertNotNull((Object)mdContext, (String)"SAMLMDCredentialContext was not available");
        Assert.assertNotNull((Object)mdContext.getRoleDescriptor());
        RoleDescriptor contextRole = mdContext.getRoleDescriptor();
        Assert.assertEquals((Object)contextRole.getElementQName(), (Object)role, (String)"Unexpected value for context role descriptor");
        Assert.assertTrue((boolean)(contextRole.getParent() instanceof EntityDescriptor));
        EntityDescriptor entityDescriptor = (EntityDescriptor)mdContext.getRoleDescriptor().getParent();
        Assert.assertEquals((String)entityDescriptor.getEntityID(), (String)entityID, (String)"Unexpected value for entity descriptor entity ID");
        if (checkEntitiesDesc) {
            Assert.assertTrue((boolean)(entityDescriptor.getParent() instanceof EntitiesDescriptor));
            EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)entityDescriptor.getParent();
            Assert.assertNotNull((Object)entitiesDescriptor.getExtensions());
            Assert.assertNotNull(entitiesDescriptor.getExtensions().getUnknownXMLObjects().get(0));
        }
    }
}

