/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.security.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.testing.SAMLTestSupport;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.SAMLMetadataKeyAgreementEncryptionConfiguration;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.saml.security.impl.SAMLMetadataEncryptionParametersResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.testing.SecurityProviderTestSupport;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.KeyTransportAlgorithmPredicate;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.config.GlobalAlgorithmRegistryInitializer;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.KeyInfoGenerationProfileCriterion;
import org.opensaml.xmlsec.derivation.impl.ConcatKDF;
import org.opensaml.xmlsec.derivation.impl.PBKDF2;
import org.opensaml.xmlsec.encryption.MGF;
import org.opensaml.xmlsec.encryption.OAEPparams;
import org.opensaml.xmlsec.encryption.support.KeyAgreementEncryptionConfiguration;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.KeyAgreementKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.DigestMethod;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAMLMetadataEncryptionParametersResolverTest
extends XMLObjectBaseTestCase {
    private MetadataCredentialResolver mdCredResolver;
    private SAMLMetadataEncryptionParametersResolver resolver;
    private CriteriaSet criteriaSet;
    private EncryptionConfigurationCriterion configCriterion;
    private BasicEncryptionConfiguration config1;
    private BasicEncryptionConfiguration config2;
    private BasicEncryptionConfiguration config3;
    private Credential rsaCred1;
    private String rsaCred1KeyName = "RSACred1";
    private Credential dsaCred1;
    private String dsaCred1KeyName = "DSACred1";
    private Credential ecCred1;
    private String ecCred1KeyName = "ECCred1";
    private String defaultRSAKeyTransportAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    private String defaultAES128DataAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private String defaultAES192DataAlgo = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    private String defaultAES256DataAlgo = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    private NamedKeyInfoGeneratorManager defaultKeyTransportKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();
    private NamedKeyInfoGeneratorManager defaultDataEncryptionKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();
    private RoleDescriptorCriterion roleDescCriterion;
    private RoleDescriptor roleDesc;
    private String targetEntityID = "urn:test:foo";
    private SecurityProviderTestSupport providerSupport = new SecurityProviderTestSupport();

    @BeforeClass
    public void buildCredentials() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPair rsaKeyPair = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        this.rsaCred1 = CredentialSupport.getSimpleCredential((PublicKey)rsaKeyPair.getPublic(), null);
        this.rsaCred1.getKeyNames().add(this.rsaCred1KeyName);
        KeyPair dsaKeyPair = KeySupport.generateKeyPair((String)"DSA", (int)1024, null);
        this.dsaCred1 = CredentialSupport.getSimpleCredential((PublicKey)dsaKeyPair.getPublic(), null);
        this.dsaCred1.getKeyNames().add(this.dsaCred1KeyName);
        KeyPair ecKeyPair = KeySupport.generateKeyPair((String)"EC", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1"), null);
        this.ecCred1 = CredentialSupport.getSimpleCredential((PublicKey)ecKeyPair.getPublic(), (PrivateKey)ecKeyPair.getPrivate());
        this.ecCred1.getKeyNames().add(this.ecCred1KeyName);
    }

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.mdCredResolver = new MetadataCredentialResolver();
        this.mdCredResolver.setKeyInfoCredentialResolver(SAMLTestSupport.buildBasicInlineKeyInfoResolver());
        this.mdCredResolver.initialize();
        this.resolver = new SAMLMetadataEncryptionParametersResolver(this.mdCredResolver);
        this.config1 = new BasicEncryptionConfiguration();
        this.config2 = new BasicEncryptionConfiguration();
        this.config3 = new BasicEncryptionConfiguration();
        this.config3.setDataEncryptionAlgorithms(List.of(this.defaultAES128DataAlgo, this.defaultAES192DataAlgo, this.defaultAES256DataAlgo, "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "http://www.w3.org/2009/xmlenc11#aes128-gcm", "http://www.w3.org/2009/xmlenc11#aes192-gcm", "http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        this.config3.setKeyTransportEncryptionAlgorithms(List.of(this.defaultRSAKeyTransportAlgo, "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://www.w3.org/2009/xmlenc11#rsa-oaep", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#kw-aes192", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#kw-tripledes"));
        SAMLMetadataKeyAgreementEncryptionConfiguration ecConfig = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        ecConfig.setMetadataUseKeyWrap(SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Default);
        ecConfig.setAlgorithm("http://www.w3.org/2009/xmlenc11#ECDH-ES");
        ConcatKDF concatKDF = new ConcatKDF();
        concatKDF.setAlgorithmID("00");
        concatKDF.setPartyUInfo("00");
        concatKDF.setPartyVInfo("00");
        ecConfig.setParameters(Set.of(concatKDF));
        this.config3.setKeyAgreementConfigurations(Map.of("EC", ecConfig));
        BasicKeyInfoGeneratorFactory basicFactory1 = new BasicKeyInfoGeneratorFactory();
        X509KeyInfoGeneratorFactory x509Factory1 = new X509KeyInfoGeneratorFactory();
        KeyAgreementKeyInfoGeneratorFactory kaFactory1 = new KeyAgreementKeyInfoGeneratorFactory();
        this.defaultKeyTransportKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();
        this.defaultKeyTransportKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)basicFactory1);
        this.defaultKeyTransportKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)x509Factory1);
        this.defaultKeyTransportKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)kaFactory1);
        this.config3.setKeyTransportKeyInfoGeneratorManager(this.defaultKeyTransportKeyInfoGeneratorManager);
        BasicKeyInfoGeneratorFactory basicFactory2 = new BasicKeyInfoGeneratorFactory();
        X509KeyInfoGeneratorFactory x509Factory2 = new X509KeyInfoGeneratorFactory();
        KeyAgreementKeyInfoGeneratorFactory kaFactory2 = new KeyAgreementKeyInfoGeneratorFactory();
        this.defaultDataEncryptionKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();
        this.defaultDataEncryptionKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)basicFactory2);
        this.defaultDataEncryptionKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)x509Factory2);
        this.defaultDataEncryptionKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)kaFactory2);
        this.config3.setDataKeyInfoGeneratorManager(this.defaultDataEncryptionKeyInfoGeneratorManager);
        this.configCriterion = new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{this.config1, this.config2, this.config3});
        this.roleDesc = this.buildRoleDescriptorSkeleton();
        this.roleDescCriterion = new RoleDescriptorCriterion(this.roleDesc);
        this.criteriaSet = new CriteriaSet(new Criterion[]{this.configCriterion, this.roleDescCriterion});
    }

    @Test
    public void testBasic() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey()));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)this.defaultRSAKeyTransportAlgo);
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getRSAOAEPParameters());
        Assert.assertTrue((boolean)params.getRSAOAEPParameters().isEmpty());
    }

    @Test
    public void testWithRSAOAEPParametersFromConfig() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey()));
        this.config3.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2001/04/xmlenc#sha256", null, "oaep-params-3"));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)this.defaultRSAKeyTransportAlgo);
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getRSAOAEPParameters());
        Assert.assertEquals((String)params.getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertNull((Object)params.getRSAOAEPParameters().getMaskGenerationFunction());
        Assert.assertEquals((String)params.getRSAOAEPParameters().getOAEPParams(), (String)"oaep-params-3");
    }

    @Test
    public void testWithAlgorithmOverrides() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey()));
        this.config2.setDataEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        this.config2.setKeyTransportEncryptionAlgorithms(Collections.singletonList("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testWithBlacklist() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey()));
        this.config1.setExcludedAlgorithms(List.of(this.defaultRSAKeyTransportAlgo, this.defaultAES128DataAlgo, this.defaultAES192DataAlgo));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES256DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testWithWhitelist() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey()));
        this.config1.setIncludedAlgorithms(List.of("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testGeneratedDataCredential() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey()));
        this.resolver.setAutoGenerateDataEncryptionCredential(true);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)this.defaultRSAKeyTransportAlgo);
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getDataEncryptionCredential());
        Assert.assertNotNull((Object)params.getDataEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getDataEncryptionCredential().getSecretKey()), (Object)128);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testEncryptionMethod() throws ResolverException {
        KeyDescriptor keyDescriptor = this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey());
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        this.roleDesc.getKeyDescriptors().add(keyDescriptor);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptionMethodWithRSAOAEPParameters() throws ResolverException, InitializationException {
        KeyDescriptor keyDescriptor = this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey());
        this.roleDesc.getKeyDescriptors().add(keyDescriptor);
        EncryptionMethod rsaEncryptionMethod = this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        keyDescriptor.getEncryptionMethods().clear();
        keyDescriptor.getEncryptionMethods().add(rsaEncryptionMethod);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params.getRSAOAEPParameters());
        rsaEncryptionMethod = this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        keyDescriptor.getEncryptionMethods().clear();
        keyDescriptor.getEncryptionMethods().add(rsaEncryptionMethod);
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getRSAOAEPParameters());
        Assert.assertTrue((boolean)params.getRSAOAEPParameters().isEmpty());
        AlgorithmRegistry originalRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        Assert.assertNotNull((Object)originalRegistry);
        this.providerSupport.loadBC();
        new GlobalAlgorithmRegistryInitializer().init();
        this.resolver.setAlgorithmRegistry(AlgorithmSupport.getGlobalAlgorithmRegistry());
        try {
            rsaEncryptionMethod = this.buildEncryptionMethod("http://www.w3.org/2009/xmlenc11#rsa-oaep");
            DigestMethod digestMethod = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
            digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
            rsaEncryptionMethod.getUnknownXMLObjects().add(digestMethod);
            keyDescriptor.getEncryptionMethods().clear();
            keyDescriptor.getEncryptionMethods().add(rsaEncryptionMethod);
            params = this.resolver.resolveSingle(this.criteriaSet);
            Assert.assertNotNull((Object)params.getRSAOAEPParameters());
            Assert.assertEquals((String)params.getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
            Assert.assertNull((Object)params.getRSAOAEPParameters().getMaskGenerationFunction());
            Assert.assertNull((Object)params.getRSAOAEPParameters().getOAEPParams());
            rsaEncryptionMethod = this.buildEncryptionMethod("http://www.w3.org/2009/xmlenc11#rsa-oaep");
            digestMethod = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
            digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
            rsaEncryptionMethod.getUnknownXMLObjects().add(digestMethod);
            MGF mgf = (MGF)this.buildXMLObject(MGF.DEFAULT_ELEMENT_NAME);
            mgf.setAlgorithm("http://www.w3.org/2009/xmlenc11#mgf1sha256");
            rsaEncryptionMethod.getUnknownXMLObjects().add(mgf);
            OAEPparams oaepParams = (OAEPparams)this.buildXMLObject(OAEPparams.DEFAULT_ELEMENT_NAME);
            oaepParams.setValue("oaep-params-md");
            rsaEncryptionMethod.setOAEPparams(oaepParams);
            keyDescriptor.getEncryptionMethods().clear();
            keyDescriptor.getEncryptionMethods().add(rsaEncryptionMethod);
            params = this.resolver.resolveSingle(this.criteriaSet);
            Assert.assertNotNull((Object)params.getRSAOAEPParameters());
            Assert.assertEquals((String)params.getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
            Assert.assertEquals((String)params.getRSAOAEPParameters().getMaskGenerationFunction(), (String)"http://www.w3.org/2009/xmlenc11#mgf1sha256");
            Assert.assertEquals((String)params.getRSAOAEPParameters().getOAEPParams(), (String)"oaep-params-md");
            this.config3.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2000/09/xmldsig#sha1", null, "oaep-params-3"));
            rsaEncryptionMethod = this.buildEncryptionMethod("http://www.w3.org/2009/xmlenc11#rsa-oaep");
            digestMethod = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
            digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
            rsaEncryptionMethod.getUnknownXMLObjects().add(digestMethod);
            keyDescriptor.getEncryptionMethods().clear();
            keyDescriptor.getEncryptionMethods().add(rsaEncryptionMethod);
            params = this.resolver.resolveSingle(this.criteriaSet);
            Assert.assertNotNull((Object)params.getRSAOAEPParameters());
            Assert.assertEquals((String)params.getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
            Assert.assertNull((Object)params.getRSAOAEPParameters().getMaskGenerationFunction());
            Assert.assertNull((Object)params.getRSAOAEPParameters().getOAEPParams());
            this.config3.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2000/09/xmldsig#sha1", null, "oaep-params-3"));
            this.resolver.setMergeMetadataRSAOAEPParametersWithConfig(true);
            rsaEncryptionMethod = this.buildEncryptionMethod("http://www.w3.org/2009/xmlenc11#rsa-oaep");
            digestMethod = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
            digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
            rsaEncryptionMethod.getUnknownXMLObjects().add(digestMethod);
            keyDescriptor.getEncryptionMethods().clear();
            keyDescriptor.getEncryptionMethods().add(rsaEncryptionMethod);
            params = this.resolver.resolveSingle(this.criteriaSet);
            Assert.assertNotNull((Object)params.getRSAOAEPParameters());
            Assert.assertEquals((String)params.getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
            Assert.assertNull((Object)params.getRSAOAEPParameters().getMaskGenerationFunction());
            Assert.assertEquals((String)params.getRSAOAEPParameters().getOAEPParams(), (String)"oaep-params-3");
        }
        finally {
            this.providerSupport.unloadBC();
            ConfigurationService.register(AlgorithmRegistry.class, (Object)originalRegistry);
        }
    }

    @Test
    public void testKeyTransportAlgorithmPredicate() throws ResolverException {
        KeyDescriptor keyDescriptor = this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey());
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"));
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes192-cbc"));
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        this.roleDesc.getKeyDescriptors().add(keyDescriptor);
        HashMap<String, String> algoMap = new HashMap<String, String>();
        algoMap.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        algoMap.put("http://www.w3.org/2001/04/xmlenc#aes192-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        MapBasedKeyTransportAlgorithmPredicate predicate = new MapBasedKeyTransportAlgorithmPredicate(algoMap);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        this.config1.setKeyTransportAlgorithmPredicate((KeyTransportAlgorithmPredicate)predicate);
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        keyDescriptor.getEncryptionMethods().clear();
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"));
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes192-cbc"));
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
    }

    @Test
    public void testEncryptionMethodWithBlacklist() throws ResolverException {
        KeyDescriptor keyDescriptor = this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey());
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
        this.roleDesc.getKeyDescriptors().add(keyDescriptor);
        this.config1.setExcludedAlgorithms(List.of("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)this.defaultRSAKeyTransportAlgo);
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testEncryptionMethodWithWhitelist() throws ResolverException {
        KeyDescriptor keyDescriptor = this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey());
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        keyDescriptor.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
        this.roleDesc.getKeyDescriptors().add(keyDescriptor);
        this.config1.setIncludedAlgorithms(List.of("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://www.w3.org/2001/04/xmlenc#aes192-cbc"));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testEncryptionMethodWithBlacklistedDigest() throws ResolverException {
        KeyDescriptor keyDescriptor = this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey());
        EncryptionMethod rsaEncryptionMethod = this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        DigestMethod digestMethod = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        rsaEncryptionMethod.getUnknownXMLObjects().add(digestMethod);
        keyDescriptor.getEncryptionMethods().add(rsaEncryptionMethod);
        rsaEncryptionMethod = this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        digestMethod = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        rsaEncryptionMethod.getUnknownXMLObjects().add(digestMethod);
        keyDescriptor.getEncryptionMethods().add(rsaEncryptionMethod);
        this.roleDesc.getKeyDescriptors().add(keyDescriptor);
        this.config1.setExcludedAlgorithms(List.of("http://www.w3.org/2000/09/xmldsig#sha1"));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getRSAOAEPParameters());
        Assert.assertEquals((String)params.getRSAOAEPParameters().getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertNull((Object)params.getRSAOAEPParameters().getMaskGenerationFunction());
        Assert.assertNull((Object)params.getRSAOAEPParameters().getOAEPParams());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testECDHWithNoEncryptionMethodsAndKeyWrapDefault() throws ResolverException {
        KeyDescriptor kd = this.buildKeyDescriptor(this.ecCred1KeyName, UsageType.ENCRYPTION, this.ecCred1.getPublicKey());
        this.roleDesc.getKeyDescriptors().add(kd);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertNull((Object)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getDataEncryptionCredential());
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(params.getDataEncryptionCredential()));
        Assert.assertNotNull((Object)params.getDataEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getDataEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getDataEncryptionCredential().getSecretKey()), (Object)128);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertTrue((boolean)KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(params.getDataKeyInfoGenerator()));
    }

    @Test
    public void testECDHWithNoEncryptionMethodsAndKeyWrapAlways() throws ResolverException {
        KeyDescriptor kd = this.buildKeyDescriptor(this.ecCred1KeyName, UsageType.ENCRYPTION, this.ecCred1.getPublicKey());
        this.roleDesc.getKeyDescriptors().add(kd);
        SAMLMetadataKeyAgreementEncryptionConfiguration ecConfig = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        ecConfig.setMetadataUseKeyWrap(SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Always);
        this.config2.setKeyAgreementConfigurations(Map.of("EC", ecConfig));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(params.getKeyTransportEncryptionCredential()));
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getKeyTransportEncryptionCredential().getSecretKey()), (Object)128);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#kw-aes128");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertTrue((boolean)KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(params.getKeyTransportKeyInfoGenerator()));
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testECDHWithNoEncryptionMethodsAndKeyWrapNever() throws ResolverException {
        KeyDescriptor kd = this.buildKeyDescriptor(this.ecCred1KeyName, UsageType.ENCRYPTION, this.ecCred1.getPublicKey());
        this.roleDesc.getKeyDescriptors().add(kd);
        SAMLMetadataKeyAgreementEncryptionConfiguration ecConfig = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        ecConfig.setMetadataUseKeyWrap(SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Never);
        this.config2.setKeyAgreementConfigurations(Map.of("EC", ecConfig));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertNull((Object)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getDataEncryptionCredential());
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(params.getDataEncryptionCredential()));
        Assert.assertNotNull((Object)params.getDataEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getDataEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getDataEncryptionCredential().getSecretKey()), (Object)128);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertTrue((boolean)KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(params.getDataKeyInfoGenerator()));
    }

    @Test
    public void testECDHWithNoEncryptionMethodsAndKeyWrapIfNotIndicated() throws ResolverException {
        KeyDescriptor kd = this.buildKeyDescriptor(this.ecCred1KeyName, UsageType.ENCRYPTION, this.ecCred1.getPublicKey());
        this.roleDesc.getKeyDescriptors().add(kd);
        SAMLMetadataKeyAgreementEncryptionConfiguration ecConfig = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        ecConfig.setMetadataUseKeyWrap(SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.IfNotIndicated);
        this.config2.setKeyAgreementConfigurations(Map.of("EC", ecConfig));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(params.getKeyTransportEncryptionCredential()));
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getKeyTransportEncryptionCredential().getSecretKey()), (Object)128);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#kw-aes128");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertTrue((boolean)KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(params.getKeyTransportKeyInfoGenerator()));
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testECDHWithBlockEncryptionMethodAndKeyWrapDefault() throws ResolverException {
        KeyDescriptor kd = this.buildKeyDescriptor(this.ecCred1KeyName, UsageType.ENCRYPTION, this.ecCred1.getPublicKey());
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        this.roleDesc.getKeyDescriptors().add(kd);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertNull((Object)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getDataEncryptionCredential());
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(params.getDataEncryptionCredential()));
        Assert.assertNotNull((Object)params.getDataEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getDataEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getDataEncryptionCredential().getSecretKey()), (Object)256);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#aes256-gcm");
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertTrue((boolean)KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(params.getDataKeyInfoGenerator()));
    }

    @Test
    public void testECDHWithBlockEncryptionMethodAndKeyWrapAlways() throws ResolverException {
        KeyDescriptor kd = this.buildKeyDescriptor(this.ecCred1KeyName, UsageType.ENCRYPTION, this.ecCred1.getPublicKey());
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        this.roleDesc.getKeyDescriptors().add(kd);
        SAMLMetadataKeyAgreementEncryptionConfiguration ecConfig = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        ecConfig.setMetadataUseKeyWrap(SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Always);
        this.config2.setKeyAgreementConfigurations(Map.of("EC", ecConfig));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(params.getKeyTransportEncryptionCredential()));
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getKeyTransportEncryptionCredential().getSecretKey()), (Object)128);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#kw-aes128");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertTrue((boolean)KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(params.getKeyTransportKeyInfoGenerator()));
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#aes256-gcm");
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testECDHWithKeyWrapEncryptionMethodAndKeyWrapDefault() throws ResolverException {
        KeyDescriptor kd = this.buildKeyDescriptor(this.ecCred1KeyName, UsageType.ENCRYPTION, this.ecCred1.getPublicKey());
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        this.roleDesc.getKeyDescriptors().add(kd);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(params.getKeyTransportEncryptionCredential()));
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getKeyTransportEncryptionCredential().getSecretKey()), (Object)256);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#kw-aes256");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertTrue((boolean)KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(params.getKeyTransportKeyInfoGenerator()));
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testECDHWithKeyWrapEncryptionMethodAndKeyWrapNever() throws ResolverException {
        KeyDescriptor kd = this.buildKeyDescriptor(this.ecCred1KeyName, UsageType.ENCRYPTION, this.ecCred1.getPublicKey());
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        this.roleDesc.getKeyDescriptors().add(kd);
        SAMLMetadataKeyAgreementEncryptionConfiguration ecConfig = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        ecConfig.setMetadataUseKeyWrap(SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Never);
        this.config2.setKeyAgreementConfigurations(Map.of("EC", ecConfig));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertNull((Object)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getDataEncryptionCredential());
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(params.getDataEncryptionCredential()));
        Assert.assertNotNull((Object)params.getDataEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getDataEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getDataEncryptionCredential().getSecretKey()), (Object)128);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertTrue((boolean)KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(params.getDataKeyInfoGenerator()));
    }

    @Test
    public void testECDHWithBlockAndKeyWrapEncryptionMethods() throws ResolverException {
        KeyDescriptor kd = this.buildKeyDescriptor(this.ecCred1KeyName, UsageType.ENCRYPTION, this.ecCred1.getPublicKey());
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        this.roleDesc.getKeyDescriptors().add(kd);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(params.getKeyTransportEncryptionCredential()));
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getKeyTransportEncryptionCredential().getSecretKey()), (Object)256);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#kw-aes256");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertTrue((boolean)KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(params.getKeyTransportKeyInfoGenerator()));
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#aes256-gcm");
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testECDHWithKeyWrapEncryptionMethodAndGeneratedDataCredential() throws ResolverException {
        KeyDescriptor kd = this.buildKeyDescriptor(this.ecCred1KeyName, UsageType.ENCRYPTION, this.ecCred1.getPublicKey());
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        this.roleDesc.getKeyDescriptors().add(kd);
        this.resolver.setAutoGenerateDataEncryptionCredential(true);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(params.getKeyTransportEncryptionCredential()));
        Assert.assertNotNull((Object)params.getKeyTransportEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getKeyTransportEncryptionCredential().getSecretKey()), (Object)256);
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#kw-aes256");
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertTrue((boolean)KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(params.getKeyTransportKeyInfoGenerator()));
        Assert.assertNotNull((Object)params.getDataEncryptionCredential());
        Assert.assertNotNull((Object)params.getDataEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getDataEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getDataEncryptionCredential().getSecretKey()), (Object)128);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testECDHWithKDFOverride() throws ResolverException {
        KeyDescriptor kd = this.buildKeyDescriptor(this.ecCred1KeyName, UsageType.ENCRYPTION, this.ecCred1.getPublicKey());
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        this.roleDesc.getKeyDescriptors().add(kd);
        SAMLMetadataKeyAgreementEncryptionConfiguration ecConfig = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        PBKDF2 kdf = new PBKDF2();
        ecConfig.setParameters(Set.of(kdf));
        this.config2.setKeyAgreementConfigurations(Map.of("EC", ecConfig));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertNull((Object)params.getKeyTransportEncryptionCredential());
        Assert.assertNull((Object)params.getKeyTransportEncryptionAlgorithm());
        Assert.assertNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getDataEncryptionCredential());
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(params.getDataEncryptionCredential()));
        Assert.assertNotNull((Object)params.getDataEncryptionCredential().getSecretKey());
        Assert.assertEquals((String)params.getDataEncryptionCredential().getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)params.getDataEncryptionCredential().getSecretKey()), (Object)256);
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#aes256-gcm");
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertTrue((boolean)KeyAgreementKeyInfoGeneratorFactory.KeyAgreementKeyInfoGenerator.class.isInstance(params.getDataKeyInfoGenerator()));
        KeyAgreementCredential kaCred = (KeyAgreementCredential)KeyAgreementCredential.class.cast(params.getDataEncryptionCredential());
        Assert.assertEquals((int)kaCred.getParameters().size(), (int)1);
        Assert.assertTrue((boolean)kaCred.getParameters().contains(PBKDF2.class));
    }

    @Test
    public void testGetEffectiveKeyAgreementConfiguration() {
        SAMLMetadataKeyAgreementEncryptionConfiguration ecConfig1 = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        ecConfig1.setMetadataUseKeyWrap(SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Always);
        this.config1.setKeyAgreementConfigurations(Map.of("EC", ecConfig1));
        SAMLMetadataKeyAgreementEncryptionConfiguration ecConfig2 = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        ecConfig2.setAlgorithm("http://www.w3.org/2009/xmlenc11#ECDH-ES");
        ecConfig2.setParameters(Set.of(new PBKDF2()));
        ecConfig2.setMetadataUseKeyWrap(SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.IfNotIndicated);
        this.config2.setKeyAgreementConfigurations(Map.of("EC", ecConfig2));
        SAMLMetadataKeyAgreementEncryptionConfiguration ecConfig3 = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        ecConfig3.setAlgorithm("SomeAlgo");
        ecConfig3.setParameters(Set.of(new ConcatKDF()));
        ecConfig3.setMetadataUseKeyWrap(SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Default);
        this.config3.setKeyAgreementConfigurations(Map.of("EC", ecConfig3));
        SAMLMetadataKeyAgreementEncryptionConfiguration config = this.resolver.getEffectiveKeyAgreementConfiguration(this.criteriaSet, this.ecCred1);
        Assert.assertEquals((String)config.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#ECDH-ES");
        Assert.assertEquals((Object)config.getMetadataUseKeyWrap(), (Object)SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Always);
        Assert.assertEquals((int)config.getParameters().size(), (int)1);
        Assert.assertTrue((boolean)PBKDF2.class.isInstance(config.getParameters().iterator().next()));
    }

    @Test
    public void testDefaultKeyAgreementUseKeyWrap() {
        KeyAgreementEncryptionConfiguration ecConfig = new KeyAgreementEncryptionConfiguration();
        ecConfig.setAlgorithm("http://www.w3.org/2009/xmlenc11#ECDH-ES");
        ecConfig.setParameters(Set.of());
        BasicEncryptionConfiguration encConfig = new BasicEncryptionConfiguration();
        encConfig.setKeyAgreementConfigurations(Map.of("EC", ecConfig));
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{encConfig})});
        Assert.assertEquals((Object)this.resolver.getDefaultKeyAgreemenUseKeyWrap(), (Object)SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Default);
        SAMLMetadataKeyAgreementEncryptionConfiguration config = this.resolver.getEffectiveKeyAgreementConfiguration(criteria, this.ecCred1);
        Assert.assertEquals((Object)config.getMetadataUseKeyWrap(), (Object)SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Default);
        this.resolver.setDefaultKeyAgreementUseKeyWrap(SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Always);
        Assert.assertEquals((Object)this.resolver.getDefaultKeyAgreemenUseKeyWrap(), (Object)SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Always);
        config = this.resolver.getEffectiveKeyAgreementConfiguration(criteria, this.ecCred1);
        Assert.assertEquals((Object)config.getMetadataUseKeyWrap(), (Object)SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Always);
    }

    @Test
    public void testMultipleKeyDescriptors() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.dsaCred1KeyName, UsageType.SIGNING, this.dsaCred1.getPublicKey()));
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey()));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)this.defaultRSAKeyTransportAlgo);
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testOnlySigningDescriptor() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.dsaCred1KeyName, UsageType.SIGNING, this.dsaCred1.getPublicKey()));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testDSACredWithUnspecifiedUse() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.dsaCred1KeyName, null, this.dsaCred1.getPublicKey()));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testRSACredWithUnspecifiedUse() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, null, this.rsaCred1.getPublicKey()));
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)this.defaultRSAKeyTransportAlgo);
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
    }

    @Test
    public void testKeyInfoGenerationProfile() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey()));
        this.resolver.setAutoGenerateDataEncryptionCredential(true);
        this.criteriaSet.add((Object)new KeyInfoGenerationProfileCriterion("testKeyInfoProfile"));
        this.defaultDataEncryptionKeyInfoGeneratorManager.setUseDefaultManager(true);
        this.defaultKeyTransportKeyInfoGeneratorManager.setUseDefaultManager(true);
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        this.defaultDataEncryptionKeyInfoGeneratorManager.setUseDefaultManager(false);
        this.defaultKeyTransportKeyInfoGeneratorManager.setUseDefaultManager(false);
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertNull((Object)params.getKeyTransportKeyInfoGenerator());
        this.defaultDataEncryptionKeyInfoGeneratorManager.setUseDefaultManager(false);
        this.defaultKeyTransportKeyInfoGeneratorManager.setUseDefaultManager(false);
        this.defaultDataEncryptionKeyInfoGeneratorManager.registerFactory("testKeyInfoProfile", (KeyInfoGeneratorFactory)new BasicKeyInfoGeneratorFactory());
        this.defaultKeyTransportKeyInfoGeneratorManager.registerFactory("testKeyInfoProfile", (KeyInfoGeneratorFactory)new BasicKeyInfoGeneratorFactory());
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
    }

    @Test
    public void testResolve() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey()));
        Iterable paramsIter = this.resolver.resolve(this.criteriaSet);
        Assert.assertNotNull((Object)paramsIter);
        Iterator iterator = paramsIter.iterator();
        Assert.assertNotNull(iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        EncryptionParameters params = (EncryptionParameters)iterator.next();
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getKeyTransportEncryptionCredential().getPublicKey(), (Object)this.rsaCred1.getPublicKey());
        Assert.assertEquals((String)params.getKeyTransportEncryptionAlgorithm(), (String)this.defaultRSAKeyTransportAlgo);
        Assert.assertNotNull((Object)params.getKeyTransportKeyInfoGenerator());
        Assert.assertNull((Object)params.getDataEncryptionCredential());
        Assert.assertEquals((String)params.getDataEncryptionAlgorithm(), (String)this.defaultAES128DataAlgo);
        Assert.assertNull((Object)params.getDataKeyInfoGenerator());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNoCredentials() throws ResolverException {
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNoKeyTransportAlgorithms() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey()));
        this.config3.setKeyTransportEncryptionAlgorithms(new ArrayList());
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNoDataEncryptionAlgorithmForEncrypterAutoGen() throws ResolverException {
        this.roleDesc.getKeyDescriptors().add(this.buildKeyDescriptor(this.rsaCred1KeyName, UsageType.ENCRYPTION, this.rsaCred1.getPublicKey()));
        this.config3.setDataEncryptionAlgorithms(new ArrayList());
        EncryptionParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullCriteriaSet() throws ResolverException {
        this.resolver.resolve(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testAbsentCriterion() throws ResolverException {
        this.resolver.resolve(new CriteriaSet());
    }

    private RoleDescriptor buildRoleDescriptorSkeleton() {
        EntityDescriptor entityDesc = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        entityDesc.setEntityID(this.targetEntityID);
        SPSSODescriptor spSSODesc = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        spSSODesc.setParent((XMLObject)entityDesc);
        return spSSODesc;
    }

    private KeyDescriptor buildKeyDescriptor(String keyName, UsageType use, Object ... contentItems) {
        KeyDescriptor keyDesc = (KeyDescriptor)this.buildXMLObject(KeyDescriptor.DEFAULT_ELEMENT_NAME);
        KeyInfo keyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        for (Object contentItem : contentItems) {
            if (contentItem instanceof PublicKey) {
                try {
                    KeyInfoSupport.addPublicKey((KeyInfo)keyInfo, (PublicKey)((PublicKey)contentItem));
                    continue;
                }
                catch (EncodingException e) {
                    throw new RuntimeException("EncodingException adding public key to KeyInfo", e);
                }
            }
            if (contentItem instanceof X509Certificate) {
                try {
                    KeyInfoSupport.addCertificate((KeyInfo)keyInfo, (X509Certificate)((X509Certificate)contentItem));
                    continue;
                }
                catch (CertificateEncodingException e) {
                    throw new RuntimeException("CertificateEncodingException ading cert to KeyInfo", e);
                }
            }
            throw new RuntimeException("Saw unknown KeyInfo content type: " + contentItem.getClass().getName());
        }
        if (keyName != null) {
            KeyInfoSupport.addKeyName((KeyInfo)keyInfo, (String)keyName);
        }
        keyDesc.setKeyInfo(keyInfo);
        if (use != null) {
            keyDesc.setUse(use);
        }
        return keyDesc;
    }

    private EncryptionMethod buildEncryptionMethod(String algorithm) {
        EncryptionMethod encMethod = (EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME);
        encMethod.setAlgorithm(algorithm);
        return encMethod;
    }

    public class MapBasedKeyTransportAlgorithmPredicate
    implements KeyTransportAlgorithmPredicate {
        private Map<String, String> algoMap;

        public MapBasedKeyTransportAlgorithmPredicate(Map<String, String> map) {
            this.algoMap = map;
        }

        public boolean test(@Nullable KeyTransportAlgorithmPredicate.SelectionInput input) {
            return this.algoMap.get(input.getDataEncryptionAlgorithm()).equals(input.getKeyTransportAlgorithm());
        }
    }
}

