/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.security.impl;

import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.impl.SAMLMetadataSignatureSigningParametersResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAMLMetadataSignatureSigningParametersResolverTest
extends XMLObjectBaseTestCase {
    private SAMLMetadataSignatureSigningParametersResolver resolver;
    private CriteriaSet criteriaSet;
    private SignatureSigningConfigurationCriterion configCriterion;
    private BasicSignatureSigningConfiguration config1;
    private BasicSignatureSigningConfiguration config2;
    private BasicSignatureSigningConfiguration config3;
    private Credential rsaCred1024;
    private Credential rsaCred2048;
    private Credential rsaCred4096;
    private Credential dsaCred;
    private Credential ecCred;
    private Credential hmacCred;
    private String defaultReferenceDigest = "http://www.w3.org/2000/09/xmldsig#sha1";
    private String defaultC14N = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String defaultRSAAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String defaultDSAAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private String defaultECAlgo = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
    private String defaultHMACAlgo = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    private Integer defaultHMACOutputLength = 128;
    private NamedKeyInfoGeneratorManager defaultKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();
    private RoleDescriptorCriterion roleDescCriterion;
    private RoleDescriptor roleDesc;
    private String targetEntityID = "urn:test:foo";

    @BeforeClass
    public void buildCredentials() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair rsaKeyPair1024 = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.rsaCred1024 = CredentialSupport.getSimpleCredential((PublicKey)rsaKeyPair1024.getPublic(), (PrivateKey)rsaKeyPair1024.getPrivate());
        KeyPair rsaKeyPair2048 = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        this.rsaCred2048 = CredentialSupport.getSimpleCredential((PublicKey)rsaKeyPair2048.getPublic(), (PrivateKey)rsaKeyPair2048.getPrivate());
        KeyPair rsaKeyPair4096 = KeySupport.generateKeyPair((String)"RSA", (int)4096, null);
        this.rsaCred4096 = CredentialSupport.getSimpleCredential((PublicKey)rsaKeyPair4096.getPublic(), (PrivateKey)rsaKeyPair4096.getPrivate());
        KeyPair dsaKeyPair = KeySupport.generateKeyPair((String)"DSA", (int)1024, null);
        this.dsaCred = CredentialSupport.getSimpleCredential((PublicKey)dsaKeyPair.getPublic(), (PrivateKey)dsaKeyPair.getPrivate());
        try {
            KeyPair ecKeyPair = KeySupport.generateKeyPair((String)"EC", (int)256, null);
            this.ecCred = CredentialSupport.getSimpleCredential((PublicKey)ecKeyPair.getPublic(), (PrivateKey)ecKeyPair.getPrivate());
        }
        catch (NoSuchAlgorithmException ecKeyPair) {
            // empty catch block
        }
        SecretKey hmacKey = KeySupport.generateKey((String)"AES", (int)128, null);
        this.hmacCred = CredentialSupport.getSimpleCredential((SecretKey)hmacKey);
    }

    @BeforeMethod
    public void setUp() {
        this.resolver = new SAMLMetadataSignatureSigningParametersResolver();
        this.config1 = new BasicSignatureSigningConfiguration();
        this.config2 = new BasicSignatureSigningConfiguration();
        this.config3 = new BasicSignatureSigningConfiguration();
        this.config3.setSignatureAlgorithms(List.of(this.defaultRSAAlgo, this.defaultDSAAlgo, this.defaultECAlgo, this.defaultHMACAlgo));
        this.config3.setSignatureReferenceDigestMethods(Collections.singletonList(this.defaultReferenceDigest));
        this.config3.setSignatureCanonicalizationAlgorithm(this.defaultC14N);
        this.config3.setSignatureHMACOutputLength(this.defaultHMACOutputLength);
        BasicKeyInfoGeneratorFactory basicFactory = new BasicKeyInfoGeneratorFactory();
        X509KeyInfoGeneratorFactory x509Factory = new X509KeyInfoGeneratorFactory();
        this.defaultKeyInfoGeneratorManager = new NamedKeyInfoGeneratorManager();
        this.defaultKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)basicFactory);
        this.defaultKeyInfoGeneratorManager.registerDefaultFactory((KeyInfoGeneratorFactory)x509Factory);
        this.config3.setKeyInfoGeneratorManager(this.defaultKeyInfoGeneratorManager);
        this.configCriterion = new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{this.config1, this.config2, this.config3});
        this.roleDesc = this.buildRoleDescriptorSkeleton();
        this.roleDescCriterion = new RoleDescriptorCriterion(this.roleDesc);
        this.criteriaSet = new CriteriaSet(new Criterion[]{this.configCriterion, this.roleDescCriterion});
    }

    @Test
    public void testBasicRSA() throws ResolverException {
        this.config1.setSigningCredentials(Collections.singletonList(this.rsaCred2048));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred2048);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultRSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testRSAWithRoleDescriptorSigningMethod() throws ResolverException {
        this.config1.setSigningCredentials(Collections.singletonList(this.rsaCred2048));
        this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildSigningMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null, null));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred2048);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testRSAWithEntityDescriptorSigningMethod() throws ResolverException {
        this.config1.setSigningCredentials(Collections.singletonList(this.rsaCred2048));
        this.addEntityDescriptorExtension(this.roleDesc, (XMLObject)this.buildSigningMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null, null));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred2048);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testRSAWithRoleDescriptorDigestMethod() throws ResolverException {
        this.config1.setSigningCredentials(Collections.singletonList(this.rsaCred2048));
        this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256"));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred2048);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultRSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testRSAWithEntityDescriptorDigestMethod() throws ResolverException {
        this.config1.setSigningCredentials(Collections.singletonList(this.rsaCred2048));
        this.addEntityDescriptorExtension(this.roleDesc, (XMLObject)this.buildDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256"));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred2048);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultRSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testRSAWithSigningMethodBlacklisted() throws ResolverException {
        this.config1.setSigningCredentials(Collections.singletonList(this.rsaCred2048));
        this.config1.setExcludedAlgorithms(Collections.singletonList("http://www.w3.org/2001/04/xmldsig-more#rsa-md5"));
        this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildSigningMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-md5", null, null));
        this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildSigningMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null, null));
        this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildSigningMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null, null));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred2048);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testRSAWithDigestMethodBlacklisted() throws ResolverException {
        this.config1.setSigningCredentials(Collections.singletonList(this.rsaCred2048));
        this.config1.setExcludedAlgorithms(Collections.singletonList("http://www.w3.org/2001/04/xmldsig-more#md5"));
        this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildDigestMethod("http://www.w3.org/2001/04/xmldsig-more#md5"));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred2048);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultRSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testECWithSigningMethodWhitelisted() throws ResolverException {
        if (this.ecCred != null) {
            this.config1.setSigningCredentials(List.of(this.rsaCred2048, this.dsaCred, this.ecCred));
            this.config1.setIncludedAlgorithms(List.of("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", this.defaultReferenceDigest));
            this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildSigningMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", null, null));
            this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildSigningMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null, null));
            this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildSigningMethod("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", null, null));
            SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
            Assert.assertNotNull((Object)params);
            Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.ecCred);
            Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256");
            Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
            Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
            Assert.assertNull((Object)params.getSignatureHMACOutputLength());
            Assert.assertNotNull((Object)params.getKeyInfoGenerator());
        }
    }

    @Test
    public void testMultipleCredsWithSigningMethodSelection() throws ResolverException {
        this.config1.setSigningCredentials(List.of(this.rsaCred2048, this.hmacCred, this.dsaCred));
        this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildSigningMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null, null));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.dsaCred);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)this.defaultDSAAlgo);
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testRSAMinKeyLength() throws ResolverException {
        this.config1.setSigningCredentials(List.of(this.rsaCred1024, this.rsaCred2048, this.rsaCred4096));
        this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildSigningMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", 4096, null));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred4096);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testRSAMaxKeyLength() throws ResolverException {
        this.config1.setSigningCredentials(List.of(this.rsaCred4096, this.rsaCred2048, this.rsaCred1024));
        this.addRoleDescriptorExtension(this.roleDesc, (XMLObject)this.buildSigningMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null, 1024));
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((Object)params.getSigningCredential(), (Object)this.rsaCred1024);
        Assert.assertEquals((String)params.getSignatureAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((String)params.getSignatureReferenceDigestMethod(), (String)this.defaultReferenceDigest);
        Assert.assertEquals((String)params.getSignatureCanonicalizationAlgorithm(), (String)this.defaultC14N);
        Assert.assertNull((Object)params.getSignatureHMACOutputLength());
        Assert.assertNotNull((Object)params.getKeyInfoGenerator());
    }

    @Test
    public void testNoCredentials() throws ResolverException {
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNoAlgorithms() throws ResolverException {
        this.config1.setSigningCredentials(Collections.singletonList(this.rsaCred2048));
        this.config3.setSignatureAlgorithms(new ArrayList());
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNoReferenceDigestMethods() throws ResolverException {
        this.config1.setSigningCredentials(Collections.singletonList(this.rsaCred2048));
        this.config3.setSignatureReferenceDigestMethods(new ArrayList());
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test
    public void testNoC14NAlgorithm() throws ResolverException {
        this.config1.setSigningCredentials(Collections.singletonList(this.rsaCred2048));
        this.config3.setSignatureCanonicalizationAlgorithm(null);
        SignatureSigningParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)params);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullCriteriaSet() throws ResolverException {
        this.resolver.resolve(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testAbsentCriterion() throws ResolverException {
        this.resolver.resolve(new CriteriaSet());
    }

    private RoleDescriptor buildRoleDescriptorSkeleton() {
        EntityDescriptor entityDesc = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        entityDesc.setEntityID(this.targetEntityID);
        SPSSODescriptor spSSODesc = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        spSSODesc.setParent((XMLObject)entityDesc);
        return spSSODesc;
    }

    private SigningMethod buildSigningMethod(String algorithm, Integer minKeySize, Integer maxKeySize) {
        SigningMethod signingMethod = (SigningMethod)this.buildXMLObject(SigningMethod.DEFAULT_ELEMENT_NAME);
        signingMethod.setAlgorithm(algorithm);
        signingMethod.setMinKeySize(minKeySize);
        signingMethod.setMaxKeySize(maxKeySize);
        return signingMethod;
    }

    private DigestMethod buildDigestMethod(String algorithm) {
        DigestMethod digestMethod = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm(algorithm);
        return digestMethod;
    }

    private void addRoleDescriptorExtension(RoleDescriptor roleDescriptor, XMLObject extension) {
        Extensions extensions = roleDescriptor.getExtensions();
        if (extensions == null) {
            extensions = this.buildExtensions();
            roleDescriptor.setExtensions(extensions);
        }
        extensions.getUnknownXMLObjects().add(extension);
    }

    private void addEntityDescriptorExtension(RoleDescriptor roleDescriptor, XMLObject extension) {
        EntityDescriptor entityDescriptor = (EntityDescriptor)roleDescriptor.getParent();
        Extensions extensions = entityDescriptor.getExtensions();
        if (extensions == null) {
            extensions = this.buildExtensions();
            entityDescriptor.setExtensions(extensions);
        }
        extensions.getUnknownXMLObjects().add(extension);
    }

    private Extensions buildExtensions() {
        return (Extensions)this.buildXMLObject(Extensions.DEFAULT_ELEMENT_NAME);
    }
}

