/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.MissingOrder;
import org.opensearch.client.opensearch._types.aggregations.ValueType;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class CompositeValuesSource
implements PlainJsonSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final Script script;
    @Nullable
    private final ValueType valueType;
    @Nullable
    private Boolean missingBucket;
    @Nullable
    private MissingOrder missingOrder;
    @Nullable
    private SortOrder order;
    @Nullable
    private String format;

    protected CompositeValuesSource(AbstractBuilder<?> builder) {
        this.field = ((AbstractBuilder)builder).field;
        this.script = ((AbstractBuilder)builder).script;
        this.valueType = ((AbstractBuilder)builder).valueType;
        this.missingBucket = ((AbstractBuilder)builder).missingBucket;
        this.missingOrder = ((AbstractBuilder)builder).missingOrder;
        this.order = ((AbstractBuilder)builder).order;
        this.format = ((AbstractBuilder)builder).format;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final ValueType valueType() {
        return this.valueType;
    }

    @Nullable
    public final Boolean missingBucket() {
        return this.missingBucket;
    }

    @Nullable
    public final MissingOrder missingOrder() {
        return this.missingOrder;
    }

    @Nullable
    public final SortOrder order() {
        return this.order;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            this.valueType.serialize(generator, mapper);
        }
        if (this.missingBucket != null) {
            generator.writeKey("missing_bucket");
            generator.write(this.missingBucket.booleanValue());
        }
        if (this.missingOrder != null) {
            generator.writeKey("missing_order");
            this.missingOrder.serialize(generator, mapper);
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupCompositeValuesSourceDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(AbstractBuilder::script, Script._DESERIALIZER, "script");
        op.add(AbstractBuilder::valueType, ValueType._DESERIALIZER, "value_type");
        op.add(AbstractBuilder::missingBucket, JsonpDeserializer.booleanDeserializer(), "missing_bucket");
        op.add(AbstractBuilder::missingOrder, MissingOrder._DESERIALIZER, "missing_order");
        op.add(AbstractBuilder::order, SortOrder._DESERIALIZER, "order");
        op.add(AbstractBuilder::format, JsonpDeserializer.stringDeserializer(), "format");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private String field;
        @Nullable
        private Script script;
        @Nullable
        private ValueType valueType;
        @Nullable
        private Boolean missingBucket;
        @Nullable
        private MissingOrder missingOrder;
        @Nullable
        private SortOrder order;
        @Nullable
        private String format;

        protected AbstractBuilder() {
        }

        public final BuilderT field(@Nullable String field) {
            this.field = field;
            return this.self();
        }

        public final BuilderT script(@Nullable Script script) {
            this.script = script;
            return this.self();
        }

        public final BuilderT script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final BuilderT valueType(@Nullable ValueType valueType) {
            this.valueType = valueType;
            return this.self();
        }

        public final BuilderT missingBucket(@Nullable Boolean missingBucket) {
            this.missingBucket = missingBucket;
            return this.self();
        }

        public final BuilderT missingOrder(@Nullable MissingOrder missingOrder) {
            this.missingOrder = missingOrder;
            return this.self();
        }

        public final BuilderT order(@Nullable SortOrder order) {
            this.order = order;
            return this.self();
        }

        public final BuilderT format(@Nullable String format) {
            this.format = format;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

