/*
 * Decompiled with CFR 0.152.
 */
package spring.boot.shiro.autoconfig;

import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import spring.boot.shiro.autoconfig.ShiroManager;
import spring.boot.shiro.autoconfig.ShiroProperties;

@Configuration
@EnableConfigurationProperties(value={ShiroProperties.class})
@Import(value={ShiroManager.class})
public class ShiroAutoConfiguration {
    @Autowired
    private ShiroProperties properties;

    @Bean(name={"realm"})
    @DependsOn(value={"lifecycleBeanPostProcessor"})
    @ConditionalOnMissingBean
    public Realm realm() {
        Class<?> relmClass = this.properties.getRealm();
        return (Realm)BeanUtils.instantiate(relmClass);
    }

    @Bean(name={"shiroFilter"})
    @DependsOn(value={"securityManager"})
    @ConditionalOnMissingBean
    public ShiroFilterFactoryBean getShiroFilterFactoryBean(DefaultSecurityManager securityManager, Realm realm) {
        securityManager.setRealm(realm);
        ShiroFilterFactoryBean shiroFilter = new ShiroFilterFactoryBean();
        shiroFilter.setSecurityManager((SecurityManager)securityManager);
        shiroFilter.setLoginUrl(this.properties.getLoginUrl());
        shiroFilter.setSuccessUrl(this.properties.getSuccessUrl());
        shiroFilter.setUnauthorizedUrl(this.properties.getUnauthorizedUrl());
        shiroFilter.setFilterChainDefinitionMap(this.properties.getFilterChainDefinitionsMap());
        return shiroFilter;
    }
}

