/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.qianfan;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.autoconfigure.qianfan.QianFanChatProperties;
import org.springframework.ai.autoconfigure.qianfan.QianFanConnectionProperties;
import org.springframework.ai.autoconfigure.qianfan.QianFanEmbeddingProperties;
import org.springframework.ai.autoconfigure.qianfan.QianFanImageProperties;
import org.springframework.ai.autoconfigure.retry.SpringAiRetryAutoConfiguration;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.image.observation.ImageModelObservationConvention;
import org.springframework.ai.model.function.DefaultFunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.qianfan.QianFanChatModel;
import org.springframework.ai.qianfan.QianFanEmbeddingModel;
import org.springframework.ai.qianfan.QianFanImageModel;
import org.springframework.ai.qianfan.api.QianFanApi;
import org.springframework.ai.qianfan.api.QianFanImageApi;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ConditionalOnClass(value={QianFanApi.class})
@EnableConfigurationProperties(value={QianFanConnectionProperties.class, QianFanChatProperties.class, QianFanEmbeddingProperties.class, QianFanImageProperties.class})
public class QianFanAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.qianfan.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public QianFanChatModel qianFanChatModel(QianFanConnectionProperties commonProperties, QianFanChatProperties chatProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention) {
        QianFanApi qianFanApi = this.qianFanApi(chatProperties.getBaseUrl(), commonProperties.getBaseUrl(), chatProperties.getApiKey(), commonProperties.getApiKey(), chatProperties.getSecretKey(), commonProperties.getSecretKey(), (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), responseErrorHandler);
        QianFanChatModel chatModel = new QianFanChatModel(qianFanApi, chatProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((QianFanChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.qianfan.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public QianFanEmbeddingModel qianFanEmbeddingModel(QianFanConnectionProperties commonProperties, QianFanEmbeddingProperties embeddingProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<EmbeddingModelObservationConvention> observationConvention) {
        QianFanApi qianFanApi = this.qianFanApi(embeddingProperties.getBaseUrl(), commonProperties.getBaseUrl(), embeddingProperties.getApiKey(), commonProperties.getApiKey(), embeddingProperties.getSecretKey(), commonProperties.getSecretKey(), (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), responseErrorHandler);
        QianFanEmbeddingModel embeddingModel = new QianFanEmbeddingModel(qianFanApi, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((QianFanEmbeddingModel)embeddingModel).setObservationConvention(arg_0));
        return embeddingModel;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.qianfan.image", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public QianFanImageModel qianFanImageModel(QianFanConnectionProperties commonProperties, QianFanImageProperties imageProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ImageModelObservationConvention> observationConvention) {
        String apiKey = StringUtils.hasText((String)imageProperties.getApiKey()) ? imageProperties.getApiKey() : commonProperties.getApiKey();
        String secretKey = StringUtils.hasText((String)imageProperties.getSecretKey()) ? imageProperties.getSecretKey() : commonProperties.getSecretKey();
        String baseUrl = StringUtils.hasText((String)imageProperties.getBaseUrl()) ? imageProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)apiKey, (String)"QianFan API key must be set.  Use the property: spring.ai.qianfan.api-key");
        Assert.hasText((String)secretKey, (String)"QianFan secret key must be set.  Use the property: spring.ai.qianfan.secret-key");
        Assert.hasText((String)baseUrl, (String)"QianFan base URL must be set.  Use the property: spring.ai.qianfan.base-url");
        QianFanImageApi qianFanImageApi = new QianFanImageApi(baseUrl, apiKey, secretKey, (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), responseErrorHandler);
        QianFanImageModel imageModel = new QianFanImageModel(qianFanImageApi, imageProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((QianFanImageModel)imageModel).setObservationConvention(arg_0));
        return imageModel;
    }

    private QianFanApi qianFanApi(String baseUrl, String commonBaseUrl, String apiKey, String commonApiKey, String secretKey, String commonSecretKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        String resolvedBaseUrl = StringUtils.hasText((String)baseUrl) ? baseUrl : commonBaseUrl;
        Assert.hasText((String)resolvedBaseUrl, (String)"QianFan base URL must be set");
        String resolvedApiKey = StringUtils.hasText((String)apiKey) ? apiKey : commonApiKey;
        Assert.hasText((String)resolvedApiKey, (String)"QianFan API key must be set");
        String resolvedSecretKey = StringUtils.hasText((String)secretKey) ? secretKey : commonSecretKey;
        Assert.hasText((String)resolvedSecretKey, (String)"QianFan Secret key must be set");
        return new QianFanApi(resolvedBaseUrl, resolvedApiKey, resolvedSecretKey, restClientBuilder, responseErrorHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackResolver springAiFunctionManager(ApplicationContext context) {
        DefaultFunctionCallbackResolver manager = new DefaultFunctionCallbackResolver();
        manager.setApplicationContext(context);
        return manager;
    }
}

