/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.typesense;

import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import java.util.ArrayList;
import org.springframework.ai.autoconfigure.vectorstore.typesense.TypesenseConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.typesense.TypesenseServiceClientProperties;
import org.springframework.ai.autoconfigure.vectorstore.typesense.TypesenseVectorStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.ai.vectorstore.typesense.TypesenseVectorStore;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.typesense.api.Client;
import org.typesense.api.Configuration;
import org.typesense.resources.Node;

@AutoConfiguration
@ConditionalOnClass(value={TypesenseVectorStore.class, EmbeddingModel.class})
@EnableConfigurationProperties(value={TypesenseServiceClientProperties.class, TypesenseVectorStoreProperties.class})
public class TypesenseVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={TypesenseConnectionDetails.class})
    PropertiesTypesenseConnectionDetails typesenseServiceClientConnectionDetails(TypesenseServiceClientProperties properties) {
        return new PropertiesTypesenseConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy batchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public TypesenseVectorStore vectorStore(Client typesenseClient, EmbeddingModel embeddingModel, TypesenseVectorStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        return ((TypesenseVectorStore.Builder)((TypesenseVectorStore.Builder)((TypesenseVectorStore.Builder)TypesenseVectorStore.builder((Client)typesenseClient, (EmbeddingModel)embeddingModel).collectionName(properties.getCollectionName()).embeddingDimension(properties.getEmbeddingDimension()).initializeSchema(properties.isInitializeSchema()).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP))).customObservationConvention((VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null))).batchingStrategy(batchingStrategy)).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Client typesenseClient(TypesenseConnectionDetails connectionDetails) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(new Node(connectionDetails.getProtocol(), connectionDetails.getHost(), String.valueOf(connectionDetails.getPort())));
        Configuration configuration = new Configuration(nodes, Duration.ofSeconds(5L), connectionDetails.getApiKey());
        return new Client(configuration);
    }

    static class PropertiesTypesenseConnectionDetails
    implements TypesenseConnectionDetails {
        private final TypesenseServiceClientProperties properties;

        PropertiesTypesenseConnectionDetails(TypesenseServiceClientProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getProtocol() {
            return this.properties.getProtocol();
        }

        @Override
        public String getHost() {
            return this.properties.getHost();
        }

        @Override
        public int getPort() {
            return this.properties.getPort();
        }

        @Override
        public String getApiKey() {
            return this.properties.getApiKey();
        }
    }
}

