/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.servlet.context;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;

abstract class ServletComponentHandler {
    private final Class<? extends Annotation> annotationType;
    private final TypeFilter typeFilter;

    protected ServletComponentHandler(Class<? extends Annotation> annotationType) {
        this.typeFilter = new AnnotationTypeFilter(annotationType);
        this.annotationType = annotationType;
    }

    TypeFilter getTypeFilter() {
        return this.typeFilter;
    }

    protected String[] extractUrlPatterns(Map<String, @Nullable Object> attributes) {
        String[] value = (String[])attributes.get("value");
        String[] urlPatterns = (String[])attributes.get("urlPatterns");
        Assert.state((urlPatterns != null ? 1 : 0) != 0, (String)"'urlPatterns' must not be null");
        Assert.state((value != null ? 1 : 0) != 0, (String)"'value' must not be null");
        if (urlPatterns.length > 0) {
            Assert.state((value.length == 0 ? 1 : 0) != 0, (String)"The urlPatterns and value attributes are mutually exclusive");
            return urlPatterns;
        }
        return value;
    }

    protected final Map<String, String> extractInitParameters(Map<String, @Nullable Object> attributes) {
        HashMap<String, String> initParameters = new HashMap<String, String>();
        AnnotationAttributes[] initParams = (AnnotationAttributes[])attributes.get("initParams");
        Assert.state((initParams != null ? 1 : 0) != 0, (String)"'initParams' must not be null");
        for (AnnotationAttributes initParam : initParams) {
            String name = (String)initParam.get((Object)"name");
            String value = (String)initParam.get((Object)"value");
            Assert.state((name != null ? 1 : 0) != 0, (String)"'name' must not be null");
            Assert.state((value != null ? 1 : 0) != 0, (String)"'value' must not be null");
            initParameters.put(name, value);
        }
        return initParameters;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    void handle(AnnotatedBeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        @Nullable Map attributes = beanDefinition.getMetadata().getAnnotationAttributes(this.annotationType.getName());
        if (attributes != null) {
            this.doHandle(attributes, beanDefinition, registry);
        }
    }

    protected abstract void doHandle(Map<String, @Nullable Object> var1, AnnotatedBeanDefinition var2, BeanDefinitionRegistry var3);
}

