/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.bootstrap;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentController;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.config.server.bootstrap"})
public class ConfigServerBootstrapOverridesAutoConfiguration {
    @Bean
    ConfigServerBootstrapOverridesLifecycle configServerBootstrapOverridesLifecycle(ApplicationContext context) {
        return new ConfigServerBootstrapOverridesLifecycle(context);
    }

    private static class ConfigServerBootstrapOverridesLifecycle
    implements SmartLifecycle {
        private final ApplicationContext context;
        private volatile boolean running;

        ConfigServerBootstrapOverridesLifecycle(ApplicationContext context) {
            this.context = context;
        }

        public void start() {
            this.running = true;
            ConfigurationPropertiesRebinder rebinder = (ConfigurationPropertiesRebinder)this.context.getBean(ConfigurationPropertiesRebinder.class);
            rebinder.rebind(ConfigServerProperties.class);
            RefreshScope refreshScope = (RefreshScope)this.context.getBean(RefreshScope.class);
            refreshScope.refresh(EnvironmentController.class);
        }

        public void stop() {
            this.running = false;
        }

        public boolean isRunning() {
            return this.running;
        }

        public int getPhase() {
            return 0x7FFFF3FF;
        }
    }
}

