/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.elasticsearch.core.convert.AbstractRangePropertyValueConverter;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchDateConverter;
import org.springframework.data.mapping.PersistentProperty;

public class DateRangePropertyValueConverter
extends AbstractRangePropertyValueConverter<Date> {
    private static final Log LOGGER = LogFactory.getLog(DateRangePropertyValueConverter.class);
    private final List<ElasticsearchDateConverter> dateConverters;

    public DateRangePropertyValueConverter(PersistentProperty<?> property, List<ElasticsearchDateConverter> dateConverters) {
        super(property);
        this.dateConverters = dateConverters;
    }

    @Override
    protected String format(Date value) {
        return this.dateConverters.get(0).format(value);
    }

    @Override
    protected Date parse(String value) {
        for (ElasticsearchDateConverter converters : this.dateConverters) {
            try {
                return converters.parse(value);
            }
            catch (Exception e) {
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
        throw new ConversionException(String.format("Unable to convert value '%s' to %s for property '%s'", value, this.getGenericType().getTypeName(), this.getProperty().getName()));
    }
}

