/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.utils.geohash;

import org.springframework.data.elasticsearch.utils.geohash.Geometry;
import org.springframework.data.elasticsearch.utils.geohash.GeometryValidator;
import org.springframework.data.elasticsearch.utils.geohash.GeometryVisitor;
import org.springframework.data.elasticsearch.utils.geohash.Point;
import org.springframework.data.elasticsearch.utils.geohash.Rectangle;

public class StandardValidator
implements GeometryValidator {
    private final boolean ignoreZValue;

    public StandardValidator(boolean ignoreZValue) {
        this.ignoreZValue = ignoreZValue;
    }

    protected void checkZ(double zValue) {
        if (!this.ignoreZValue && !Double.isNaN(zValue)) {
            throw new IllegalArgumentException("found Z value [" + zValue + "] but [ignore_z_value] parameter is [" + this.ignoreZValue + "]");
        }
    }

    @Override
    public void validate(Geometry geometry) {
        if (!this.ignoreZValue) {
            geometry.visit(new GeometryVisitor<Void, RuntimeException>(){

                @Override
                public Void visit(Point point) throws RuntimeException {
                    StandardValidator.this.checkZ(point.getZ());
                    return null;
                }

                @Override
                public Void visit(Rectangle rectangle) throws RuntimeException {
                    StandardValidator.this.checkZ(rectangle.getMinZ());
                    StandardValidator.this.checkZ(rectangle.getMaxZ());
                    return null;
                }
            });
        }
    }
}

