/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.springframework.http.HttpStatus;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class StatusResultMatchers {
    protected StatusResultMatchers() {
    }

    public ResultMatcher is(final Matcher<Integer> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                MatcherAssertionErrors.assertThat("Response status", result.getResponse().getStatus(), matcher);
            }
        };
    }

    public ResultMatcher is(final int status) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("Response status", status, result.getResponse().getStatus());
            }
        };
    }

    public ResultMatcher is1xxInformational() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), HttpStatus.Series.INFORMATIONAL, StatusResultMatchers.this.getHttpStatusSeries(result));
            }
        };
    }

    public ResultMatcher is2xxSuccessful() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), HttpStatus.Series.SUCCESSFUL, StatusResultMatchers.this.getHttpStatusSeries(result));
            }
        };
    }

    public ResultMatcher is3xxRedirection() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), HttpStatus.Series.REDIRECTION, StatusResultMatchers.this.getHttpStatusSeries(result));
            }
        };
    }

    public ResultMatcher is4xxClientError() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), HttpStatus.Series.CLIENT_ERROR, StatusResultMatchers.this.getHttpStatusSeries(result));
            }
        };
    }

    public ResultMatcher is5xxServerError() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("Range for response status value " + result.getResponse().getStatus(), HttpStatus.Series.SERVER_ERROR, StatusResultMatchers.this.getHttpStatusSeries(result));
            }
        };
    }

    private HttpStatus.Series getHttpStatusSeries(MvcResult result) {
        int statusValue = result.getResponse().getStatus();
        HttpStatus status = HttpStatus.valueOf((int)statusValue);
        return status.series();
    }

    public ResultMatcher reason(final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                MatcherAssertionErrors.assertThat("Response status reason", result.getResponse().getErrorMessage(), matcher);
            }
        };
    }

    public ResultMatcher reason(final String reason) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("Response status reason", reason, result.getResponse().getErrorMessage());
            }
        };
    }

    public ResultMatcher isContinue() {
        return this.matcher(HttpStatus.CONTINUE);
    }

    public ResultMatcher isSwitchingProtocols() {
        return this.matcher(HttpStatus.SWITCHING_PROTOCOLS);
    }

    public ResultMatcher isProcessing() {
        return this.matcher(HttpStatus.PROCESSING);
    }

    public ResultMatcher isCheckpoint() {
        return this.matcher(HttpStatus.valueOf((int)103));
    }

    public ResultMatcher isOk() {
        return this.matcher(HttpStatus.OK);
    }

    public ResultMatcher isCreated() {
        return this.matcher(HttpStatus.CREATED);
    }

    public ResultMatcher isAccepted() {
        return this.matcher(HttpStatus.ACCEPTED);
    }

    public ResultMatcher isNonAuthoritativeInformation() {
        return this.matcher(HttpStatus.NON_AUTHORITATIVE_INFORMATION);
    }

    public ResultMatcher isNoContent() {
        return this.matcher(HttpStatus.NO_CONTENT);
    }

    public ResultMatcher isResetContent() {
        return this.matcher(HttpStatus.RESET_CONTENT);
    }

    public ResultMatcher isPartialContent() {
        return this.matcher(HttpStatus.PARTIAL_CONTENT);
    }

    public ResultMatcher isMultiStatus() {
        return this.matcher(HttpStatus.MULTI_STATUS);
    }

    public ResultMatcher isAlreadyReported() {
        return this.matcher(HttpStatus.ALREADY_REPORTED);
    }

    public ResultMatcher isImUsed() {
        return this.matcher(HttpStatus.IM_USED);
    }

    public ResultMatcher isMultipleChoices() {
        return this.matcher(HttpStatus.MULTIPLE_CHOICES);
    }

    public ResultMatcher isMovedPermanently() {
        return this.matcher(HttpStatus.MOVED_PERMANENTLY);
    }

    public ResultMatcher isFound() {
        return this.matcher(HttpStatus.FOUND);
    }

    public ResultMatcher isMovedTemporarily() {
        return this.matcher(HttpStatus.MOVED_TEMPORARILY);
    }

    public ResultMatcher isSeeOther() {
        return this.matcher(HttpStatus.SEE_OTHER);
    }

    public ResultMatcher isNotModified() {
        return this.matcher(HttpStatus.NOT_MODIFIED);
    }

    public ResultMatcher isUseProxy() {
        return this.matcher(HttpStatus.USE_PROXY);
    }

    public ResultMatcher isTemporaryRedirect() {
        return this.matcher(HttpStatus.TEMPORARY_REDIRECT);
    }

    public ResultMatcher isResumeIncomplete() {
        return this.matcher(HttpStatus.valueOf((int)308));
    }

    public ResultMatcher isBadRequest() {
        return this.matcher(HttpStatus.BAD_REQUEST);
    }

    public ResultMatcher isUnauthorized() {
        return this.matcher(HttpStatus.UNAUTHORIZED);
    }

    public ResultMatcher isPaymentRequired() {
        return this.matcher(HttpStatus.PAYMENT_REQUIRED);
    }

    public ResultMatcher isForbidden() {
        return this.matcher(HttpStatus.FORBIDDEN);
    }

    public ResultMatcher isNotFound() {
        return this.matcher(HttpStatus.NOT_FOUND);
    }

    public ResultMatcher isMethodNotAllowed() {
        return this.matcher(HttpStatus.METHOD_NOT_ALLOWED);
    }

    public ResultMatcher isNotAcceptable() {
        return this.matcher(HttpStatus.NOT_ACCEPTABLE);
    }

    public ResultMatcher isProxyAuthenticationRequired() {
        return this.matcher(HttpStatus.PROXY_AUTHENTICATION_REQUIRED);
    }

    public ResultMatcher isRequestTimeout() {
        return this.matcher(HttpStatus.REQUEST_TIMEOUT);
    }

    public ResultMatcher isConflict() {
        return this.matcher(HttpStatus.CONFLICT);
    }

    public ResultMatcher isGone() {
        return this.matcher(HttpStatus.GONE);
    }

    public ResultMatcher isLengthRequired() {
        return this.matcher(HttpStatus.LENGTH_REQUIRED);
    }

    public ResultMatcher isPreconditionFailed() {
        return this.matcher(HttpStatus.PRECONDITION_FAILED);
    }

    public ResultMatcher isRequestEntityTooLarge() {
        return this.matcher(HttpStatus.REQUEST_ENTITY_TOO_LARGE);
    }

    public ResultMatcher isRequestUriTooLong() {
        return this.matcher(HttpStatus.REQUEST_URI_TOO_LONG);
    }

    public ResultMatcher isUnsupportedMediaType() {
        return this.matcher(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    public ResultMatcher isRequestedRangeNotSatisfiable() {
        return this.matcher(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
    }

    public ResultMatcher isExpectationFailed() {
        return this.matcher(HttpStatus.EXPECTATION_FAILED);
    }

    public ResultMatcher isIAmATeapot() {
        return this.matcher(HttpStatus.valueOf((int)418));
    }

    @Deprecated
    public ResultMatcher isInsufficientSpaceOnResource() {
        return this.matcher(HttpStatus.INSUFFICIENT_SPACE_ON_RESOURCE);
    }

    @Deprecated
    public ResultMatcher isMethodFailure() {
        return this.matcher(HttpStatus.METHOD_FAILURE);
    }

    @Deprecated
    public ResultMatcher isDestinationLocked() {
        return this.matcher(HttpStatus.DESTINATION_LOCKED);
    }

    public ResultMatcher isUnprocessableEntity() {
        return this.matcher(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    public ResultMatcher isLocked() {
        return this.matcher(HttpStatus.LOCKED);
    }

    public ResultMatcher isFailedDependency() {
        return this.matcher(HttpStatus.FAILED_DEPENDENCY);
    }

    public ResultMatcher isUpgradeRequired() {
        return this.matcher(HttpStatus.UPGRADE_REQUIRED);
    }

    public ResultMatcher isPreconditionRequired() {
        return this.matcher(HttpStatus.valueOf((int)428));
    }

    public ResultMatcher isTooManyRequests() {
        return this.matcher(HttpStatus.valueOf((int)429));
    }

    public ResultMatcher isRequestHeaderFieldsTooLarge() {
        return this.matcher(HttpStatus.valueOf((int)431));
    }

    public ResultMatcher isInternalServerError() {
        return this.matcher(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public ResultMatcher isNotImplemented() {
        return this.matcher(HttpStatus.NOT_IMPLEMENTED);
    }

    public ResultMatcher isBadGateway() {
        return this.matcher(HttpStatus.BAD_GATEWAY);
    }

    public ResultMatcher isServiceUnavailable() {
        return this.matcher(HttpStatus.SERVICE_UNAVAILABLE);
    }

    public ResultMatcher isGatewayTimeout() {
        return this.matcher(HttpStatus.GATEWAY_TIMEOUT);
    }

    public ResultMatcher isHttpVersionNotSupported() {
        return this.matcher(HttpStatus.HTTP_VERSION_NOT_SUPPORTED);
    }

    public ResultMatcher isVariantAlsoNegotiates() {
        return this.matcher(HttpStatus.VARIANT_ALSO_NEGOTIATES);
    }

    public ResultMatcher isInsufficientStorage() {
        return this.matcher(HttpStatus.INSUFFICIENT_STORAGE);
    }

    public ResultMatcher isLoopDetected() {
        return this.matcher(HttpStatus.LOOP_DETECTED);
    }

    public ResultMatcher isBandwidthLimitExceeded() {
        return this.matcher(HttpStatus.valueOf((int)509));
    }

    public ResultMatcher isNotExtended() {
        return this.matcher(HttpStatus.NOT_EXTENDED);
    }

    public ResultMatcher isNetworkAuthenticationRequired() {
        return this.matcher(HttpStatus.valueOf((int)511));
    }

    private ResultMatcher matcher(final HttpStatus status) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                AssertionErrors.assertEquals("Status", status.value(), result.getResponse().getStatus());
            }
        };
    }
}

