/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ActiveProfilesResolver;
import org.springframework.test.context.support.DefaultActiveProfilesResolver;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

abstract class ActiveProfilesUtils {
    private static final Log logger = LogFactory.getLog(ActiveProfilesUtils.class);

    ActiveProfilesUtils() {
    }

    static String[] resolveActiveProfiles(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        ArrayList<Object[]> profileArrays = new ArrayList<Object[]>();
        MetaAnnotationUtils.AnnotationDescriptor<ActiveProfiles> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, ActiveProfiles.class);
        if (descriptor == null && logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", ActiveProfiles.class.getName(), testClass.getName()));
        }
        while (descriptor != null) {
            ActiveProfilesResolver resolver;
            Class<? extends ActiveProfilesResolver> resolverClass;
            Class<?> rootDeclaringClass = descriptor.getRootDeclaringClass();
            ActiveProfiles annotation = descriptor.synthesizeAnnotation();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @ActiveProfiles [%s] for declaring class [%s]", annotation, descriptor.getDeclaringClass().getName()));
            }
            if (ActiveProfilesResolver.class == (resolverClass = annotation.resolver())) {
                resolverClass = DefaultActiveProfilesResolver.class;
            }
            try {
                resolver = (ActiveProfilesResolver)BeanUtils.instantiateClass(resolverClass, ActiveProfilesResolver.class);
            }
            catch (Exception ex) {
                String msg = String.format("Could not instantiate ActiveProfilesResolver of type [%s] for test class [%s]", resolverClass.getName(), rootDeclaringClass.getName());
                logger.error((Object)msg);
                throw new IllegalStateException(msg, ex);
            }
            Object[] profiles = resolver.resolve(rootDeclaringClass);
            if (!ObjectUtils.isEmpty((Object[])profiles)) {
                profileArrays.add(profiles);
            }
            descriptor = annotation.inheritProfiles() ? descriptor.next() : null;
        }
        Collections.reverse(profileArrays);
        LinkedHashSet<String> activeProfiles = new LinkedHashSet<String>();
        Iterator iterator = profileArrays.iterator();
        while (iterator.hasNext()) {
            String[] profiles;
            for (String profile : profiles = (String[])iterator.next()) {
                if (!StringUtils.hasText((String)profile)) continue;
                activeProfiles.add(profile.trim());
            }
        }
        return StringUtils.toStringArray(activeProfiles);
    }
}

