/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

public class ParameterMethodNameResolver
implements MethodNameResolver {
    public static final String DEFAULT_PARAM_NAME = "action";
    private String paramName = "action";
    private String[] methodParamNames;
    private Properties logicalMappings;
    private String defaultMethodName;

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void setMethodParamNames(String[] methodParamNames) {
        this.methodParamNames = methodParamNames;
    }

    public void setLogicalMappings(Properties logicalMappings) {
        this.logicalMappings = logicalMappings;
    }

    public void setDefaultMethodName(String defaultMethodName) {
        this.defaultMethodName = defaultMethodName;
    }

    public String getHandlerMethodName(HttpServletRequest request) throws NoSuchRequestHandlingMethodException {
        String methodName = null;
        if (this.paramName != null) {
            methodName = request.getParameter(this.paramName);
        }
        if (this.methodParamNames != null) {
            for (int i = 0; i < this.methodParamNames.length; ++i) {
                String candidate = this.methodParamNames[i];
                if (request.getParameter(candidate) != null) {
                    methodName = candidate;
                    break;
                }
                if (request.getParameter(candidate + ".x") == null) continue;
                methodName = candidate;
                break;
            }
        }
        if (methodName != null) {
            if (this.logicalMappings != null) {
                methodName = this.logicalMappings.getProperty(methodName, methodName);
            }
        } else {
            methodName = this.defaultMethodName;
        }
        if (methodName == null) {
            throw new NoSuchRequestHandlingMethodException(request);
        }
        return methodName;
    }
}

