package jd.model.repository;

import jd.model.address.NationalAddress;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by xujingfeng on 2016/11/10.
 */
public interface NationalAddressRepos extends JpaRepository<NationalAddress, String>, JpaSpecificationExecutor<NationalAddress> {

    List<NationalAddress> findByLeveloneAddressNameAndLeveltwoAddressNameAndLevelthreeAddressName(String leveloneName, String leveltwoName, String levelthreeName);

    List<NationalAddress> findByLeveloneAddressNameAndLeveltwoAddressName(String leveloneName, String leveltwoName);

    NationalAddress findByLinkId(String linkId);

    List<NationalAddress> findByLinkIdLike(String linkId);

    NationalAddress findByLeveloneAddressAndLeveltwoAddressAndLevelthreeAddressAndLevelfourAddress(Integer level1Id, Integer level2Id,Integer level3Id,Integer level4Id);


    @Transactional
    @Modifying(clearAutomatically = true)
    @Query("update NationalAddress set linkId =?1 where id=?2")
    int updatelinkIdById(String linkId, String id);
}
