/*
 * Decompiled with CFR 0.152.
 */
package recharge.center.service.config.yimei;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import recharge.center.service.config.yimei.HttpClient;
import recharge.center.service.config.yimei.HttpRequestBody;
import recharge.center.service.config.yimei.HttpResponseBody;

public class HttpClient {
    private int httpConnectionTimeOut = 30;
    private int httpReadTimeOut = 30;
    private boolean debug = false;

    public HttpClient(int httpConnectionTimeOut, int httpReadTimeOut, boolean debug) {
        this.httpConnectionTimeOut = httpConnectionTimeOut;
        this.httpReadTimeOut = httpReadTimeOut;
        this.debug = debug;
    }

    public HttpClient() {
    }

    public HttpResponseBody service(HttpRequestBody body) {
        HttpResponseBody result = null;
        Exception ex = null;
        try {
            HttpURLConnection conn = this.createConnection(body);
            this.fillConnection(conn, body);
            this.request(conn, body);
            result = this.handleResponse(conn, body);
            this.closeCoonection(conn);
        }
        catch (IOException e) {
            ex = e;
            result = HttpResponseBody.error((String)"HTTP_ERR_IO", (String)"client io error");
        }
        catch (Exception e) {
            ex = e;
            result = HttpResponseBody.error((String)"HTTP_ERR_IO", (String)"client other error");
        }
        if (this.debug && ex != null) {
            ex.printStackTrace();
        }
        return result;
    }

    public HttpResponseBody serviceProxy(HttpRequestBody body, String host, int port) {
        HttpResponseBody result = null;
        Exception ex = null;
        try {
            HttpURLConnection conn = this.createConnectionProxy(body, host, port);
            this.fillConnection(conn, body);
            this.request(conn, body);
            result = this.handleResponse(conn, body);
            this.closeCoonection(conn);
        }
        catch (IOException e) {
            ex = e;
            result = HttpResponseBody.error((String)"HTTP_ERR_IO", (String)"client io error");
        }
        catch (Exception e) {
            ex = e;
            result = HttpResponseBody.error((String)"HTTP_ERR_IO", (String)"client other error");
        }
        if (this.debug && ex != null) {
            ex.printStackTrace();
        }
        return result;
    }

    private HttpURLConnection createConnectionProxy(HttpRequestBody body, String host, int port) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        HttpURLConnection conn;
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        URL console = new URL(body.getUrl());
        if (body.isHttps()) {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
            HttpsURLConnection sconn = (HttpsURLConnection)console.openConnection(proxy);
            sconn.setSSLSocketFactory(sc.getSocketFactory());
            sconn.setHostnameVerifier((HostnameVerifier)new TrustAnyHostnameVerifier());
            conn = sconn;
        } else {
            conn = (HttpURLConnection)console.openConnection(proxy);
        }
        return conn;
    }

    private HttpURLConnection createConnection(HttpRequestBody body) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        HttpURLConnection conn;
        URL console = new URL(body.getUrl());
        if (body.isHttps()) {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
            HttpsURLConnection sconn = (HttpsURLConnection)console.openConnection();
            sconn.setSSLSocketFactory(sc.getSocketFactory());
            sconn.setHostnameVerifier((HostnameVerifier)new TrustAnyHostnameVerifier());
            conn = sconn;
        } else {
            conn = (HttpURLConnection)console.openConnection();
        }
        return conn;
    }

    protected void fillConnection(HttpURLConnection conn, HttpRequestBody body) throws ProtocolException {
        this.fillTimeout(conn);
        this.filleMethod(conn, body);
        this.fillHeaders(conn, body);
        this.fillCookies(conn, body);
    }

    private void fillTimeout(HttpURLConnection conn) {
        if (this.httpConnectionTimeOut != 0) {
            conn.setConnectTimeout(this.httpConnectionTimeOut * 1000);
        }
        if (this.httpReadTimeOut != 0) {
            conn.setReadTimeout(this.httpReadTimeOut * 1000);
        }
    }

    private void filleMethod(HttpURLConnection conn, HttpRequestBody body) throws ProtocolException {
        conn.setRequestMethod(body.getMethod().toString().toUpperCase());
    }

    private void fillHeaders(HttpURLConnection conn, HttpRequestBody body) {
        if (!this.isEmpty((Object)body.getHeaders())) {
            for (Map.Entry entry : body.getHeaders().entrySet()) {
                conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void fillCookies(HttpURLConnection conn, HttpRequestBody body) {
        if (!this.isEmpty((Object)body.getCookies())) {
            conn.setRequestProperty("Cookie", body.getCookies());
        }
    }

    protected void request(HttpURLConnection conn, HttpRequestBody body) throws IOException {
        conn.setDoOutput(true);
        if (body.getQueryString() != null) {
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            out.write(body.getQueryString().getBytes(body.getCharSet()));
            out.flush();
            out.close();
        }
    }

    protected HttpResponseBody handleResponse(HttpURLConnection conn, HttpRequestBody body) throws IOException {
        Map resultHeaders = this.getHeaders(conn, body);
        List cookies = this.getCookies(conn, body);
        String resultBody = this.getResultBody(conn, body);
        int code = conn.getResponseCode();
        return HttpResponseBody.ok((Map)resultHeaders, (List)cookies, (String)resultBody, (int)code);
    }

    private Map<String, String> getHeaders(HttpURLConnection conn, HttpRequestBody body) throws UnsupportedEncodingException {
        HashMap<String, String> resultHeaders = new HashMap<String, String>();
        Map<String, List<String>> header = conn.getHeaderFields();
        if (!this.isEmpty(header)) {
            for (Map.Entry<String, List<String>> entry : header.entrySet()) {
                if ("Set-Cookie".equalsIgnoreCase(entry.getKey())) continue;
                String valuer = "";
                if (entry.getValue() != null && entry.getValue().size() > 0) {
                    for (String value : entry.getValue()) {
                        valuer = valuer + new String(value.getBytes("ISO-8859-1"), body.getCharSet()) + ",";
                    }
                    valuer = valuer.substring(0, valuer.length() - 1);
                }
                resultHeaders.put(entry.getKey(), valuer);
            }
        }
        return resultHeaders;
    }

    private List<String> getCookies(HttpURLConnection conn, HttpRequestBody body) throws UnsupportedEncodingException {
        ArrayList<String> resultC = new ArrayList<String>();
        List<String> cookies = null;
        Map<String, List<String>> header = conn.getHeaderFields();
        if (!this.isEmpty(header)) {
            cookies = header.get("Set-Cookie");
        }
        if (cookies != null) {
            for (String cookie : cookies) {
                resultC.add(new String(cookie.getBytes("ISO-8859-1"), body.getCharSet()));
            }
        }
        return cookies;
    }

    private String getResultBody(HttpURLConnection conn, HttpRequestBody body) throws IOException {
        String resultBody = null;
        InputStream is = conn.getInputStream();
        if (is != null) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            is.close();
            byte[] resultBytes = outStream.toByteArray();
            resultBody = new String(resultBytes, body.getCharSet());
        }
        return resultBody;
    }

    protected void closeCoonection(HttpURLConnection conn) {
        conn.disconnect();
    }

    private boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return "".equals(((String)obj).trim());
        }
        if (obj instanceof Map) {
            return ((Map)obj).size() == 0;
        }
        return true;
    }
}

