package spider.service.controller;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import spider.service.handler.impl.JdPriceSpiderHandlerImpl;
import spider.service.handler.impl.SnPriceSpiderHandlerImpl;
import spider.api.PriceSpiderApi;
import spider.service.service.SpiderLogsService;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Liang Wenxu
 * @since 2017-07-05
 * Created by Liang Wenxu on 2017-07-05.
 */
@Controller
@RequestMapping(value = {"test"})
public class SpiderApiTestController {
    /** Attributes ============== */

    /** Methods ============== */

    @RequestMapping("jdPriceSpider")
    @ResponseBody
    public Object jdPriceSpider(String sku, String areaCode) throws Exception {
        if(sku.contains(",")) {
            String[] skuArr = sku.split(",");
            List<String> skus = new ArrayList();
            for(String s : skuArr) {
                skus.add(s);
            }
         //   return jdPriceSpiderHandler.getBatchSalesPrice(skus, areaCode);
            return null;
        } else {
           // return jdPriceSpiderHandler.getSalesPrice(sku, areaCode);
            return null;
        }
    }

    @RequestMapping("snPriceSpider")
    @ResponseBody
    public Object snPriceSpider(String sku, String areaCode) throws Exception {
        if(sku.contains(",")) {
            String[] skuArr = sku.split(",");
            List<String> skus = new ArrayList();
            for(String s : skuArr) {
                skus.add(s);
            }
            return snPriceSpiderHandler.getBatchSalesPrice(skus);
        } else {
            return snPriceSpiderHandler.getSalesPrice(sku);
        }
    }

    @RequestMapping("testPriceSpider")
    @ResponseBody
    public Object testPriceSpiderApi(String sku, String storeCode, String areaCode) throws Exception {
        if(sku.contains(",")) {
            String[] skuArr = sku.split(",");
            List<String> skus = new ArrayList();
            for(String s : skuArr) {
                skus.add(s);
            }
//            return jdPriceSpiderHandler.getBatchSalesPrice(skus, areaCode);
            return null;
        } else {
            return priceSpiderApi.getSalesPrice(sku, storeCode);
//            return jdPriceSpiderHandler.getSalesPrice(sku, areaCode);
        }
    }

    @RequestMapping("updateJdPrices")
    @ResponseBody
    public Object updateJdPrices(Integer poolSize, Integer pageSize, Integer dbPoolSize, Integer dbPageSize) {
        spiderLogsService.doUpdatePrices(poolSize, pageSize, dbPoolSize, dbPageSize);

        return "success";
    }

    /** Dependent Components ============== */

//    @MotanReferer(basicReferer = "motanClientBasicConfig")
//    JdPriceSpiderApi jdPriceSpiderApi;

    @Autowired
    JdPriceSpiderHandlerImpl jdPriceSpiderHandler;

    @Autowired
    SnPriceSpiderHandlerImpl snPriceSpiderHandler;

    @Autowired
    SpiderLogsService spiderLogsService;

    @MotanReferer(basicReferer = "motanClientBasicConfig")
    PriceSpiderApi priceSpiderApi;
    /** Setter and getters ============== */
}
