package spider.service.handler.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ma.glasnost.orika.MapperFacade;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import spider.dto.SpiderLogsDto;
import spider.model.SpiderLogs;
import spider.service.handler.PriceSpiderHandler;
import spider.service.service.SpiderLogsService;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import sysmg.api.SystemConfigApi;
import sysmg.api.SystemLogApi;
import sysmg.dto.SystemConfigDto;
import sysmg.dto.SystemLogDto;
import utils.GlobalContants;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;
import utils.rpc.motan.ApiResponseVo;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 苏宁价格爬虫API
 * @author Liang Wenxu
 * @since 2017-07-04
 * Created by Liang Wenxu on 2017-07-04.
 */
@Component
public class SnPriceSpiderHandlerImpl implements PriceSpiderHandler {
    Log logger = Logs.getLog(SnPriceSpiderHandlerImpl.class.getName());

    /** Attributes ============== */
    private static StoreDto store;

    @Value("${spider.httpclient.request.connectTimeout:3000}")
    private Integer connectTimeout;

    @Value("${spider.httpclient.request.connectionRequestTimeout:3000}")
    private Integer connectionRequestTimeout;

    @Value("${spider.httpclient.request.socketTimeout:5000}")
    private Integer socketTimeout;

    @Autowired
    MapperFacade mapperFacade;

    /** Methods ============== */

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String sku) throws IOException {
        return this.getSalesPrice(sku, null, SpiderLogs.TRIGGER_TYPE_MANUAL);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(List<String> skus) throws IOException {
        return this.getBatchSalesPrice(skus, null, SpiderLogs.TRIGGER_TYPE_MANUAL);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiResponseVo<SpiderLogsDto> getSalesPrice(String sku, Map<Integer, String> areaCodeMap, String triggerType) throws IOException {
        ApiResponseVo responseVo = new ApiResponseVo();
        String pdUrl = systemConfigApi.getConfigValue(
                SystemConfigDto.ORG_CODE_COMMON, SystemConfigDto.CONFIG_CODE_SN_SPIDER_CONFIGS,
                "SN_PD_URL", true, true);
        String areaUrl = systemConfigApi.getConfigValue(
                SystemConfigDto.ORG_CODE_COMMON, SystemConfigDto.CONFIG_CODE_SN_SPIDER_CONFIGS,
                "SN_AREA_SELECT_URL", true, true);

        String priceUrl = systemConfigApi.getConfigValue(
                SystemConfigDto.ORG_CODE_COMMON, SystemConfigDto.CONFIG_CODE_SN_SPIDER_CONFIGS,
                "SN_PRICE_URL", true, true);


        // 替换skuid
        pdUrl = !Lang.isEmpty(pdUrl) ? pdUrl.replaceAll("\\{sku\\}", sku) : "";

//        pdUrl = pdUrl.replace(":9999", "");
        logger.info("get suning PD page url: ----->\r\n" + pdUrl);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout)
                .setSocketTimeout(socketTimeout).build();
        HttpGet httpGet = new HttpGet(pdUrl);
        httpGet.setConfig(requestConfig);
        CloseableHttpResponse response = null;

        Map<String, SpiderLogs> returnData = new HashMap<>();

        Boolean spiderError = false; // 爬虫处理出错标识
        String spiderErrorMsg = ""; // 爬虫处理出错信息
        String spiderErrorContent = ""; // 爬虫处理出错详情
        String spiderRequestUrl = ""; // 请求的URL，用于记录出错时的URL
        // 拼接苏宁价格Ajax请求地址
        StringBuilder snPriceUrlSb = new StringBuilder();

        try {
            response = httpclient.execute(httpGet);
            System.out.println(response.getStatusLine());
            if(response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                String html = EntityUtils.toString(entity);
                logger.info("get suning PD page: ----->\r\n" + html);

                /** 从苏宁产品页面，获取苏宁产品的配置，从中截取需要的信息 */
                // 使用正则表达式匹配出页面中sn变量的定义
                String snConfigStrRegxStr = "var\\s*sn\\s*=\\s*sn\\s*\\|\\|\\s*\\{(.*?)\\}\\s*;";
                Pattern patternSn = Pattern.compile(snConfigStrRegxStr);
                Matcher matcherSn = patternSn.matcher(html);
                String snStr = "";// 页面上抓取到的sn变量定义
                while (matcherSn.find()) { // 需取最后一个匹配
                    if(matcherSn.groupCount() >= 1) {
                        snStr = matcherSn.group(1);
                    }
                }

                // 将sn对象定义的javascript脚本转化为json（只需除去部分不符合JSON规范的代码段）
//                snStr = snStr.length() > 2 ? snStr.substring(1, snStr.length() - 1) : snStr;
                snStr = snStr.replaceAll("\"cuxiaoSeq\":\\{.*?\\},", "");
                snStr = snStr.replaceAll("\"itemDomain\":.*?,", "");
                snStr = snStr.replaceAll("/\\*.*?\\*/", "");

                snStr = "{" + snStr + "}";
                // 解析sn为Map方便提取
                Map<String, String> snMap = JSON.parseObject(snStr, HashMap.class);
//                Map<String, String> snMap = new HashMap<>();
//                String[] spiltedKVStr = snStr.split(",");
//                String[] tempKV = null; // 键值对
//                for(String kv : spiltedKVStr) {
//                    kv = kv.replace("\"", "").replace("'", "");
//                    tempKV = kv.split(":");
//                    if(tempKV != null && tempKV.length > 0) {
//                        snMap.put(StringUtils.trim(tempKV[0]), tempKV.length > 1 ? (tempKV[1] != null ? tempKV[1] : "") : "");
//                    }
//                }



                /** 处理地区 */
                if(areaCodeMap == null) {// 默认上海
                    areaCodeMap = new HashMap<>();
                    areaCodeMap.put(1, "20");
                    areaCodeMap.put(2, "021");
                    areaCodeMap.put(3, "13");
                }
                snMap.put("provinceCode", areaCodeMap.get(1));
                snMap.put("lesCityId", areaCodeMap.get(2));
                snMap.put("lesDistrictId", areaCodeMap.get(3));
                snMap.put("lesCodeStr", areaCodeMap.get(1)+areaCodeMap.get(2)+"01");

                // 苏宁网站上的拼接规则：
                // c = sn.luaUrl + "/nspcsale_" + e + "_" + sn.passPartNumber + "_" + sn.partNumber + "_" + sn.vendorCode +
                // "_" + sn.provinceCode + "_" + sn.lesCityId + "_" + a + "_" + sn.category1 + "_" + sn.mdmCityId
                // + "_" + sn.cityId + "_" + sn.districtId + "_" + sn.cmmdtyType + "_" + sn.custLevel +
                // "_" + b + "_" + f.manageInvFlag + "_" + f.factorySendFlag + "_" + f.ownerPlace +
                // "_" + f.accountPlace + "_" + f.deptNo + "_" + f.vendor + "_" + f.sendAvalidTime +
                // "_" + f.purChaseType + "_" + f.bookActionID + "_" + f.priceType + "_" + f.vendorType +
                // "_" + f.juId + "_" + encodeURIComponent(f.promotionPrice) + "_" + f.bookGoodID +
                // "_" + f.invStatus + "_" + g + "_" + sn.vendor + ".html"
                if(!priceUrl.startsWith("http")) {
                    priceUrl = "https:" + (priceUrl.startsWith("//") ? "" : "//");
                }
//                priceUrl = priceUrl.replace(":9999", "");
                snPriceUrlSb.append(priceUrl).append("0")
                        .append("_").append(snMap.get("passPartNumber") == null ? "" : snMap.get("passPartNumber"))
                        .append("_").append(snMap.get("partNumber") == null ? "" : snMap.get("partNumber"))
                        .append("_").append(snMap.get("vendorCode") == null ? "" : snMap.get("vendorCode"))
                        .append("_").append(snMap.get("provinceCode") == null ? "" : snMap.get("provinceCode"))
                        .append("_").append(snMap.get("lesCityId") == null ? "" : snMap.get("lesCityId"))
//                        .append("_").append(snMap.get("lesCodeStr") == null ? "" : snMap.get("lesCodeStr"))
                        .append("_") // lesCodeStr
                        .append("_").append(snMap.get("category1") == null ? "" : snMap.get("category1"))
                        .append("_").append(snMap.get("mdmCityId") == null ? "" : snMap.get("mdmCityId"))
                        .append("_").append(snMap.get("cityId") == null ? "" : snMap.get("cityId"))
                        .append("_").append(snMap.get("districtId") == null ? "" : snMap.get("districtId"))
                        .append("_").append(snMap.get("cmmdtyType") == null ? "" : snMap.get("cmmdtyType"))
                        .append("_").append(snMap.get("custLevel") == null ? "" : snMap.get("custLevel"))
                        .append("_").append("")
                        .append("_").append(snMap.get("manageInvFlag") == null ? "" : snMap.get("manageInvFlag"))
                        .append("_").append(snMap.get("factorySendFlag") == null ? "" : snMap.get("factorySendFlag"))
                        .append("_").append(snMap.get("ownerPlace") == null ? "" : snMap.get("ownerPlace"))
                        .append("_").append(snMap.get("accountPlace") == null ? "" : snMap.get("accountPlace"))
                        .append("_").append(snMap.get("deptNo") == null ? "" : snMap.get("deptNo"))
                        .append("_").append(snMap.get("vendor") == null ? "" : snMap.get("vendor"))
                        .append("_").append(snMap.get("sendAvalidTime") == null ? "" : snMap.get("sendAvalidTime"))
                        .append("_").append(snMap.get("purChaseType") == null ? "" : snMap.get("purChaseType"))
                        .append("_").append(snMap.get("bookActionID") == null ? "" : snMap.get("bookActionID"))
                        .append("_").append(snMap.get("priceType") == null ? "" : snMap.get("priceType"))
                        .append("_").append(snMap.get("vendorType") == null ? "" : snMap.get("vendorType"))
                        .append("_").append(snMap.get("juId") == null ? "" : snMap.get("juId"))
                        .append("_").append(snMap.get("promotionPrice") == null ? "" : snMap.get("promotionPrice"))
                        .append("_").append(snMap.get("bookGoodID") == null ? "" : snMap.get("bookGoodID"))
                        .append("_").append(snMap.get("invStatus") == null ? "" : snMap.get("invStatus"))
                        .append("_").append(snMap.get("vendor") == null ? "" : snMap.get("vendor"))
                        .append(".html");
                logger.info("查询苏宁价格接口URL-> " + snPriceUrlSb.toString());
                response.close();
                response = null;
                httpGet = new HttpGet(snPriceUrlSb.toString());
                httpGet.setConfig(requestConfig);
                httpclient = HttpClients.createDefault();
                response = httpclient.execute(httpGet);
                System.out.println(response.getStatusLine());


                if(response.getStatusLine().getStatusCode() == 200) {
                    entity = response.getEntity();
                    String snPriceJson = EntityUtils.toString(entity);
                    if(!Lang.isEmpty(snPriceJson)) {
                        Map jsonData = JSON.parseObject(snPriceJson.substring(snPriceJson.indexOf("pcData(")+"pcData(".length(), snPriceJson.lastIndexOf(")")), HashMap.class);
                        // jsonData["data"]["price"]["saleInfo"][0]["promotionPrice"] // 易购销售价
                        if(!Lang.isEmpty(jsonData.get("code")) && jsonData.get("code").toString().equals("1")) {
                            if(!Lang.isEmpty(jsonData.get("data"))) {
                                Map data = (Map) jsonData.get("data");
                                if(!Lang.isEmpty(data)) {
                                    Map price = (Map) data.get("price");
                                    if(!Lang.isEmpty(price)) {
                                        JSONArray saleInfo = (JSONArray) price.get("saleInfo");
                                        if(saleInfo != null && saleInfo.size() > 0) {
                                            JSONObject si = (JSONObject) saleInfo.get(0);
                                            BigDecimal snPrice = si.getBigDecimal("promotionPrice");
                                            SpiderLogs spiderLogs = new SpiderLogs();
                                            spiderLogs.setStoreId(getStore().getId());
                                            spiderLogs.setSalesPrice(snPrice);
                                            spiderLogs.setContent(snPriceJson);
                                            spiderLogs.setProductCode(sku);
                                            spiderLogs.setTriggerType(triggerType);
                                            spiderLogsService.saveLog(spiderLogs);
                                            responseVo.setData(mapperFacade.map(spiderLogs,SpiderLogsDto.class));
                                            responseVo.setStatus(GlobalContants.ResponseStatus.SUCCESS);
                                            spiderError = false;
                                        } else {
                                            spiderError = true;
                                            spiderErrorMsg = jsonData.get("message") == null ? "苏宁价格获取AJAX返回数据有误" : jsonData.get("message").toString();
                                        }
                                    } else {
                                        spiderError = true;
                                        spiderErrorMsg = jsonData.get("message") == null ? "苏宁价格获取AJAX返回数据有误"  : jsonData.get("message").toString();
                                    }
                                } else {
                                    spiderError = true;
                                    spiderErrorMsg = jsonData.get("message") == null ? "苏宁价格获取AJAX返回数据有误"  : jsonData.get("message").toString();
                                }
                            } else {
                                spiderError = true;
                                spiderErrorMsg = jsonData.get("message") == null ? "苏宁价格获取AJAX返回数据有误"  : jsonData.get("message").toString();
                            }
                        } else {
                            spiderError = true;
                            spiderErrorMsg = jsonData.get("message") == null ? "苏宁价格获取AJAX返回数据有误"  : jsonData.get("message").toString();
                        }
                    } else {
                        spiderError = true;
                        spiderErrorMsg = "苏宁价格AJAX接口返回为空";
                    }
                    logger.info("get suning price json: ----->\r\n" + snPriceJson);
                    spiderErrorContent = snPriceJson;
                } else {
                    spiderError = true;
                    spiderErrorContent = response.getStatusLine().toString();
                }
                spiderRequestUrl = snPriceUrlSb.toString();

            } else {
                // 详情页获取失败
                spiderRequestUrl = pdUrl;
            }

            if(spiderError) {
                // 错误日志记录
                systemLogApi.saveBean(new SystemLogDto(
                        ""+spiderRequestUrl, "SN_PRICE_SPIDER", ""+SystemLogDto.LOG_TYPE_ERROR,
                        "" + spiderErrorContent
                ));
                // 返回错误
                responseVo.setStatus(GlobalContants.ResponseStatus.ERROR);
                responseVo.setMessage(spiderErrorMsg);
            }

        } catch (ClientProtocolException e) {
            logger.error("抓取苏宁爬虫数据失败！", e);
            responseVo = ApiResponseVo.createErrorResp("抓取京东数据失败："+e.getLocalizedMessage(), "3", Lang.toString(e));
        } catch (IOException e) {
            logger.error("抓取苏宁爬虫数据失败！", e);
            responseVo = ApiResponseVo.createErrorResp("抓取京东数据失败："+e.getLocalizedMessage(), "3", Lang.toString(e));
        } finally {
            if(response != null) {
                response.close();
            }
        }
        return responseVo;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiResponseVo<Map<String, SpiderLogsDto>> getBatchSalesPrice(List<String> skus, Map<Integer, String> areaCodeMap, String triggerType) throws IOException {
        ApiResponseVo<Map<String, SpiderLogsDto>> responseVo = new ApiResponseVo<>();
        Map<String, SpiderLogsDto> rtnData = new HashMap<>();
        for(String sku : skus) {
            ApiResponseVo<SpiderLogsDto> r = getSalesPrice(sku, areaCodeMap, triggerType);
            if(GlobalContants.ResponseStatus.SUCCESS.equals(r.getStatus())) {
                rtnData.put(sku, r.getData());
            }
        }
        responseVo.setStatus(GlobalContants.ResponseStatus.SUCCESS);
        responseVo.setData(rtnData);
        return responseVo;
    }

    // 获取店铺（写死当前的店铺code即可）
    private StoreDto getStore() {
        if(store == null) {
            store = storeApi.findByCode("suning");
        }
        return store;
    }

    /** Dependent Components ============== */
    @MotanReferer
    SystemConfigApi systemConfigApi;

    @Autowired
    SpiderLogsService spiderLogsService;

    @MotanReferer
    StoreApi storeApi;

    @MotanReferer
    SystemLogApi systemLogApi;
    /** Setter and getters ============== */
}
