package pool.api;

import org.springframework.data.domain.Pageable;
import pool.dto.brand.brandmapper.BrandMapperDto;
import pool.vo.BrandVo;
import pool.vo.query.brand.brandmapper.BrandMapperQueryVo;
import utils.sql.PageVo;

import java.util.List;

public interface ProviderBrandMangerApi {
        /**
     * 根据标准化品牌id，查询供应商映射该id下的数量
     * @param standardBrandId
     * @return
     */
    int findCountByStandardBrandId(String standardBrandId);

    /**
     * 供应商品牌映射查询（admin-web调用）
     */
    PageVo<BrandMapperDto> pageQueryForMapper(BrandMapperQueryVo brandMapperQueryVo, Pageable pageable);

    /**
     * 根据供应商品牌id 获取品牌信息
     */
    BrandMapperDto findOneById(String id);

    /**
     * 供应商绑定标准品牌的id
     */
    Boolean bindStandardBrand(String id,String productBrandId);

    Boolean cancelBindStandardBrand(String id);

    List<BrandMapperDto> findStores();

    /**
     * 指定分类
     * 获取供应商的店铺id
     * @param productCategoryId
     * @return
     */
    List<String> findStoresOfProviderByProductCategoryId(String productCategoryId);

    void updateProviderBrandMappingInfo(BrandVo brandVo);
    /**
     * 根据品牌模型下的品牌id,gengxing
     */
}
