package pool.api;

import pool.dto.BrandDto;
import pool.dto.BrandQueryDto;
import pool.vo.BrandVo;
import pool.vo.ProviderProductBrandVo;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

import java.util.Map;

/**
 * 2.对接供应商接口API
 * 品牌api
 * Created by zj on 2018/06/26.
 */
public interface ProviderProductBrandApi {
    /**
     * 2.创建商品品牌
     * @param brandDto
     */
    BaseResponse<Map<String,String>> saveBrand(BrandDto brandDto);

    /**
     * 3.查询品牌列表
     * @param brandQueryDto
     * @return
     */
    BaseResponse<PageVo<BrandVo>> queryBrands(BrandQueryDto brandQueryDto);

    /**
     * 4.删除品牌
     * @param brandId
     * @return
     */
    BaseResponse<String> deleteBrand(String brandId);


    ProviderProductBrandVo findBrandByNameAndStoreId(String brandName, String storeId);


}
