package pool.api;

import pool.dto.ProductModelDto;
import pool.dto.ProductModelQueryDto;
import pool.dto.ProviderProductDto;
import pool.vo.ProductModelVo;
import sinomall.global.common.response.BaseResponse;
import utils.sql.PageVo;

import java.util.List;

/**
 * 3.对接供应商
 * 商品模型接口
 * Created by zj on 2018/06/26.
 */
public interface ProviderProductModelApi {

    /**
     * 5. 商品模型查询
     *
     * @param productModelQueryDto
     * @return
     */
    BaseResponse<PageVo<ProductModelVo>> queryModels(ProductModelQueryDto productModelQueryDto);

    /**
     * 6.商品模型创建
     *
     * @param productModelDto
     * @return
     */
    BaseResponse<ProductModelDto> saveModel(ProductModelDto productModelDto);

    /**
     * 7.商品模型修改
     *
     * @param productModelDto
     * @return
     */
    BaseResponse<ProductModelDto> updateModel(ProductModelDto productModelDto);

    /**
     * 8.商品模型删除
     *
     * @param modelId
     * @return
     */
    BaseResponse<String> deleteModel(String modelId, String storeId);

    /**
     * zj
     * 根据供应商品牌查询该品牌下的所有的模型 model
     * @param providerProductBrandId
     * @param isDelete
     * @return
     */
    List<ProductModelDto> findByBrandIdAndIsDelete(String providerProductBrandId,Boolean isDelete);

    ProductModelDto findByModelSkuAndStoreId(String modelSku, String storeId);

}
