package pool.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 商品
 * 传输类
 * Created by zj on 2018/06/27.
 */
@Data
public class ProviderGoodsDto implements Serializable {
    private static final long serialVersionUID = 4326175893854352362L;
    private String id;                 //id
    private String sku;             //商品编码，数字字母组合
    private String modelSku;        //模型编码
    private String status;          //上下架状态0-否，1-是
    private String weight;          //重量
    private String name;            //名称
    private String productArea;     //产地
    private String upc;             //条形码
    private String saleUnit;        //销售单位
    private String introduction;    //详细介绍 格式html标签格式，可用于页面直接展示
    private String param;           //规格参数
    private String wareQD;          //包装清单
    private List<PicDto> pics;      //商品图片列表
    private BigDecimal costPrice;   //协议价格
    private BigDecimal salePrice;   //销售价格
    private BigDecimal marketPrice; //市场价格
    private Integer stockCount;     //库存
    private String storeId;         //供应商id
    private String postSalePolicy;  //支持售后类型
    private String invoiceType;     //是否支持开具发票

    private String brandId;   //品牌id(金服标准品牌)
    private String brandName; //品牌名称（京东消息处理时使用）
    private boolean onSale;   //是否可售（消息处理时使用）
    private String category;  //分类（消息处理时使用）
    private String title;//标题（消息处理时使用）
    private Boolean isJudgefac;//是否支持厂家配送（消息处理时使用）
    private BigDecimal discountRate;//折扣率（消息同步时使用）
    private ProviderCategoryDto providerCategoryDto;//（消息同步时使用）

    private String provideName;              //供应商名称
    private String categoryName;              //分类名称
    private String categoryId;              //分类id
    private String individuaDescription; //商品个性化描述
    private List<ProviderGoodsParamsDto> providerGoodsParamsDtos;//商品参数（消息同步时使用，苏宁）

    private List<ProviderGoodsSpecificationDto> providerGoodsSpecifications;


}
