package pool.dto.brand.providerproductfashion;

import lombok.Data;

import java.io.Serializable;

/**
 * 供应商商品查询映射实体类
 * 用于 admin_web中的商品查询页使用
 * @author zj
 * @date 2018-08-24
 */
@Data
public class ProviderProductFashionInfoMapper implements Serializable {
    private static final long serialVersionUID = 2774672893342242828L;
    private String id;                  //供应商商品id
    private String isDelete;            //是否删除表示
    private String sku;                 //供应商商品sku
    private String providerFashionName; //供应商商品名称
    private String providerSaleStatus;  //供应商商品状态 0:下架 1上架
    private String modelSku;            //供应商模型modelSku
    private String modelName;           //供应商模型名称
    private String productCategoryId;   //标准商品分类id
    private String productStatus;       //模型上下架状态
    private String providerProductBrandId;//供应商商品品牌id
    private String productBrandId;          //标准品牌id
    private String providerProductCategoryId;//供应商分类id
    private String productCategoryName;     //标准分类名称
    private String storeId;                 //店铺id（供应商id）
    private String storeName;               //店铺名称
    private String storeType;               //店铺类型(1:协议店铺 2：供应商店铺 3：第三方店铺)
}
