package pool.dto.enumeration;

import java.util.HashMap;
import java.util.Map;

public enum ProviderProductFashionStatusEnum {

    dwon(0, "已下架"), up(1, "已上架"),all(-1,"全部"),notUp(-2,"未上架");
    private Integer code;
    private String description;
    public static Map<Integer, ProviderProductFashionStatusEnum> providerProductFashionStatusEnumMap = new HashMap<>();

    static {
        providerProductFashionStatusEnumMap.put(up.getCode(), up);
        providerProductFashionStatusEnumMap.put(dwon.getCode(), dwon);
        providerProductFashionStatusEnumMap.put(all.getCode(), all);
        providerProductFashionStatusEnumMap.put(notUp.getCode(), notUp);
    }

    ProviderProductFashionStatusEnum() {
    }

    ProviderProductFashionStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
