package pool.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 商品
 * 输出类
 * Created by zj on 2018/06/26.
 */
@Data
public class ProviderGoodsVo implements Serializable {
    private static final long serialVersionUID = 7352955266472613848L;
    private String productId;       //商品id
    private String name;            //名称
    private String sku;             //商品编码
    private String status;          //上下架状态0-否，1-是
    private String brandName;       //品牌名称
    private String productArea;     //产地
    private String upc;             //条形码
    private String saleUnit;         //销售单位
    private String introduction;    //详情介绍
    private String param;           //规格参数
    private String wareQD;          //包装清单
    private List<FashionPicVo> fashionPics; //商品图片列表
    private BigDecimal salePrice;       //销售价格
    private BigDecimal costPrice;       //成本价格
    private BigDecimal marketPrice;     //市场价格
    private Integer stockCount;      //库存
    private Integer postSalePolicy; //是否支持售后
    private String invoiceType; //发票类型

    private String provideName; //供应商名字

    private String categoryId;              //分类id

    private String storeId;
}
