/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.service.apiImpl;

import com.google.common.collect.Maps;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import sinosoftgz.member.api.AddressCommonApi;
import sinosoftgz.member.api.vo.AddressVo;
import sinosoftgz.member.model.common.Address;
import sinosoftgz.member.model.common.IpAddress;
import sinosoftgz.member.model.repository.common.AddressRepos;
import sinosoftgz.member.model.repository.common.IpAddressRepos;
import sinosoftgz.member.service.service.AddressService;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.ip.IPtoLong;
import sinosoftgz.utils.lang.Copys;
import sinosoftgz.utils.web.AddressUtils;
import sinosoftgz.utils.web.Webs;

@MotanService(basicService="motanServerBasicConfig")
public class AddressCommonApiImpl
implements AddressCommonApi {
    @Autowired
    AddressRepos addressRepos;
    @Autowired
    IpAddressRepos ipAddressRepos;

    public List<Address> findByCoordinates(String level, Float lng, Float lat, Float lngRange, Float latRange, Boolean withChildren) {
        throw new UnsupportedOperationException();
    }

    public List<Address> findByJianPing(String jp, AddressCommonApi.AddressLevel level, Boolean withChildren) {
        throw new UnsupportedOperationException();
    }

    public List<Address> findByPingYin(String pingYing, AddressCommonApi.AddressLevel level, Boolean withChildren) {
        throw new UnsupportedOperationException();
    }

    public List<Address> findByFirstChar(String firstChar, AddressCommonApi.AddressLevel level, Boolean withChildren) {
        throw new UnsupportedOperationException();
    }

    public IpAddress findByIp(Long ipL) {
        return this.ipAddressRepos.findByIPL(ipL);
    }

    public Address findAreaByIp(Long ipL, int areaLevelProvince) {
        IpAddress ipAddress = this.ipAddressRepos.findByIPL(ipL);
        if (ipAddress == null) {
            return null;
        }
        Address address = this.addressRepos.findByIdOrderById(ipAddress.getCode());
        while (address != null) {
            if (StringUtils.equals((CharSequence)address.getLevelType(), (CharSequence)(areaLevelProvince + ""))) {
                return address;
            }
            if (address.getParent() == null || address.getId().equals(address.getParent().getId())) {
                return null;
            }
            address = address.getParent();
        }
        return null;
    }

    public List<Address> addressList(AddressCommonApi.AddressLevel level, Boolean withChildren) {
        return this.addressList(level, null, withChildren);
    }

    public List<Address> addressList(AddressCommonApi.AddressLevel level, String parentId, Boolean withChildren) {
        String[] stringArray;
        Address p;
        ArrayList<Address> resList = new ArrayList<Address>();
        List<Object> dbRes = null;
        dbRes = Lang.isEmpty((Object)parentId) ? this.addressRepos.findByLevelTypeOrderById(level + "") : ((p = (Address)this.addressRepos.findOne((Serializable)((Object)parentId))) != null ? (Lang.isEmpty((Object)level) ? this.addressRepos.findByParentOrderById(p) : this.addressRepos.findByLevelTypeAndParentOrderById(level + "", p)) : new ArrayList<Address>());
        if (withChildren.booleanValue()) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "child";
        }
        AddressService.addressCpy(dbRes, resList, stringArray);
        return resList;
    }

    public List<AddressVo> addressVoList(AddressCommonApi.AddressLevel level, String parentId, Boolean withChildren) {
        return this.transAddressListToVoList(this.addressList(level, parentId, withChildren), withChildren);
    }

    public Address findById(String id) {
        Address a = (Address)this.addressRepos.findOne((Serializable)((Object)id));
        if (a != null) {
            Address res = new Address();
            AddressService.addressCpy(a, res, new String[0]);
            return res;
        }
        return null;
    }

    public AddressVo findVoById(String id) {
        Address a = (Address)this.addressRepos.findOne((Serializable)((Object)id));
        if (a != null) {
            return this.transAddressToVo(a, true);
        }
        return null;
    }

    public Map<Integer, String> areaCodeNodeList(String areaCode) {
        System.out.println("areaCodeNodeList invoked");
        HashMap<Integer, String> nodeList = new HashMap<Integer, String>();
        Address curArea = this.addressRepos.findByIdOrderById(areaCode);
        if (!Lang.isEmpty((Object)curArea)) {
            if (curArea.getLevelType().equals("1")) {
                nodeList.put(1, curArea.getId());
            } else {
                while (!Lang.isEmpty((Object)curArea.getParent())) {
                    nodeList.put(Integer.parseInt(curArea.getLevelType()), curArea.getId());
                    if (curArea.getLevelType().equals("1")) break;
                    curArea = curArea.getParent();
                }
                nodeList.put(Integer.parseInt(curArea.getLevelType()), curArea.getId());
            }
        }
        return nodeList;
    }

    public Map<Integer, Address> areaNodeList(String areaCode) {
        HashMap<Integer, Address> nodeList = new HashMap<Integer, Address>();
        Address curArea = this.addressRepos.findByIdOrderById(areaCode);
        if (!Lang.isEmpty((Object)curArea)) {
            if (curArea.getLevelType().equals("1")) {
                nodeList.put(1, curArea);
            } else {
                while (!Lang.isEmpty((Object)curArea.getParent())) {
                    nodeList.put(Integer.parseInt(curArea.getLevelType()), curArea);
                    if (curArea.getLevelType().equals("1")) break;
                    curArea = curArea.getParent();
                }
            }
        }
        return nodeList;
    }

    public Long childrenCounts(String areaCode) {
        Address address = this.addressRepos.findByIdOrderById(areaCode);
        if (address != null) {
            return this.childrenCounts(address);
        }
        return 0L;
    }

    public Long childrenCounts(Address address) {
        if (address != null) {
            return this.addressRepos.countByParent(address);
        }
        return 0L;
    }

    public Address findByCityCode(String cityCode) {
        return this.addressRepos.findByCityCode(cityCode);
    }

    public Map getIpAddressIds(HttpServletRequest request, HttpServletResponse response) {
        String sessionProvoiceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        Map returnMap = this.getAddressIdSByParams(request, response, sessionProvoiceId);
        return returnMap;
    }

    public Map getAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String proviceId) {
        HashMap<String, String> returnAddressIdMap = new HashMap<String, String>();
        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = null;
        String sessionProvoiceId = (String)request.getSession().getAttribute("AREA_LEVEL_PROVINCE_ID");
        String cityId = (String)request.getSession().getAttribute("AREA_LEVEL_CITY_ID");
        String areaId = (String)request.getSession().getAttribute("AREA_LEVEL_AREA_ID");
        if (Lang.isEmpty((Object)proviceId)) {
            if (!Lang.isEmpty((Object)sessionProvoiceId)) {
                returnProvoiceId = sessionProvoiceId;
            } else {
                String remoteIp = Webs.getIp((HttpServletRequest)request);
                if (!Lang.isEmpty((Object)remoteIp)) {
                    Long ipL = IPtoLong.ipToLong((String)remoteIp);
                    Address currentAaddress = null;
                    currentAaddress = this.findAreaByIp(ipL, 1);
                    returnProvoiceId = !Lang.isEmpty((Object)currentAaddress) ? currentAaddress.getId() : "310000";
                } else {
                    returnProvoiceId = "310000";
                }
            }
        } else {
            returnProvoiceId = !Lang.isEmpty((Object)sessionProvoiceId) ? (!proviceId.equals(sessionProvoiceId) ? proviceId : sessionProvoiceId) : proviceId;
        }
        returnCityId = (String)this.getAddressId(request, cityId, areaId, returnProvoiceId).get("cityId");
        returnAreaId = (String)this.getAddressId(request, cityId, areaId, returnProvoiceId).get("areaId");
        returnAddressIdMap.put("provoiceId", returnProvoiceId);
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        return returnAddressIdMap;
    }

    public void setAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String areaId) {
        if (Lang.isEmpty((Object)areaId)) {
            throw new NullPointerException("areaId not null");
        }
        HashMap addressMap = Maps.newHashMap();
        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = areaId;
        Address address = this.findById(returnAreaId);
        if (!Lang.isEmpty((Object)address) && !Lang.isEmpty((Object)address.getParent())) {
            returnCityId = address.getParent().getId();
            if (!Lang.isEmpty((Object)address.getParent().getParent())) {
                returnProvoiceId = address.getParent().getParent().getId();
            }
        }
        addressMap.put("provoiceId", returnProvoiceId);
        addressMap.put("cityId", returnCityId);
        addressMap.put("areaId", returnAreaId);
        AddressUtils.setAddressIdToSession((HttpServletRequest)request, (HttpServletResponse)response, (Map)addressMap);
    }

    public String toString() {
        return super.toString();
    }

    public Map getCityAndAreaId(String provoiceId) {
        HashMap<String, String> returnAddressIdMap = new HashMap<String, String>();
        String returnCityId = null;
        String returnAreaId = null;
        List<Address> areaAddressList = this.addressList(AddressCommonApi.AddressLevel.CITY, provoiceId, true);
        if (!Lang.isEmpty(areaAddressList)) {
            returnCityId = areaAddressList.get(0).getId();
            if (!Lang.isEmpty((Object)areaAddressList.get(0).getChild())) {
                returnAreaId = ((Address)areaAddressList.get(0).getChild().get(0)).getId();
            }
        }
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        return returnAddressIdMap;
    }

    public Map getAddressId(HttpServletRequest request, String cityId, String areaId, String provoiceId) {
        HashMap<String, String> returnAddressIdMap = new HashMap<String, String>();
        String returnCityId = null;
        String returnAreaId = null;
        String remoteIp = Webs.getIp((HttpServletRequest)request);
        if (!Lang.isEmpty((Object)remoteIp)) {
            Long ipL = IPtoLong.ipToLong((String)remoteIp);
            Address currentAaddress = null;
            if (Lang.isEmpty((Object)cityId) && Lang.isEmpty((Object)areaId)) {
                currentAaddress = this.findAreaByIp(ipL, 3);
                if (Lang.isEmpty((Object)currentAaddress)) {
                    currentAaddress = this.findAreaByIp(ipL, 2);
                    if (Lang.isEmpty((Object)currentAaddress)) {
                        returnCityId = (String)this.getCityAndAreaId(provoiceId).get("cityId");
                        returnAreaId = (String)this.getCityAndAreaId(provoiceId).get("areaId");
                    } else {
                        returnCityId = currentAaddress.getId();
                        List<Address> areaAddressList = this.addressList(AddressCommonApi.AddressLevel.AREA, returnCityId, false);
                        if (!Lang.isEmpty(areaAddressList)) {
                            returnAreaId = areaAddressList.get(0).getId();
                        }
                    }
                } else {
                    returnAreaId = currentAaddress.getId();
                    returnCityId = currentAaddress.getParent().getId();
                }
            } else if (!Lang.isEmpty((Object)cityId) && !Lang.isEmpty((Object)areaId)) {
                returnAreaId = areaId;
                returnCityId = cityId;
            } else if (!Lang.isEmpty((Object)cityId) && Lang.isEmpty((Object)areaId)) {
                returnCityId = cityId;
                List<Address> areaAddressList = this.addressList(AddressCommonApi.AddressLevel.AREA, returnCityId, false);
                if (!Lang.isEmpty(areaAddressList)) {
                    returnAreaId = areaAddressList.get(0).getId();
                }
            } else if (Lang.isEmpty((Object)cityId) && !Lang.isEmpty((Object)areaId)) {
                returnAreaId = areaId;
                Address address = this.findById(areaId);
                if (!Lang.isEmpty((Object)address)) {
                    returnCityId = address.getParent().getId();
                }
            }
        } else {
            returnCityId = (String)this.getCityAndAreaId(provoiceId).get("cityId");
            returnAreaId = (String)this.getCityAndAreaId(provoiceId).get("areaId");
        }
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        return returnAddressIdMap;
    }

    public Address findFirstChild(String parentId, Boolean withChildren) {
        List list = new ArrayList();
        if (Lang.isEmpty((Object)parentId)) {
            list = this.addressRepos.findByLevelTypeOrderById((Pageable)new PageRequest(0, 1), "1");
        } else {
            Address p = this.addressRepos.findByIdOrderById(parentId);
            if (p != null) {
                list = this.addressRepos.findByParentOrderById((Pageable)new PageRequest(0, 1), p);
            }
        }
        Address res = new Address();
        if (Lang.isEmpty(list)) {
            return null;
        }
        if (withChildren.booleanValue()) {
            AddressService.addressCpy((Address)list.get(0), res, new String[0]);
        } else {
            AddressService.addressCpy((Address)list.get(0), res, "child");
        }
        return res;
    }

    private AddressVo transAddressToVo(Address address, Boolean withChild) {
        AddressVo addressVo = new AddressVo();
        Copys copys = Copys.create();
        copys.from((Object)address).excludes(new String[]{"parent", "child"}).to(new Object[]{addressVo});
        addressVo.setCode(address.getId());
        if (!Lang.isEmpty((Object)address.getParent())) {
            addressVo.setParentCode(address.getParent().getId());
        }
        addressVo.setHasChild(Boolean.valueOf(address.getChild() != null && address.getChild().size() > 0));
        if (address.getRemarks() != null && address.getRemarks().trim().equals("direct")) {
            addressVo.setDirectly(Boolean.valueOf(true));
        }
        if (withChild.booleanValue()) {
            addressVo.setChild(this.transAddressListToVoList(address.getChild(), withChild));
        } else {
            addressVo.setChild(null);
        }
        return addressVo;
    }

    private List<AddressVo> transAddressListToVoList(List<Address> addressList, Boolean withChild) {
        ArrayList<AddressVo> addressVoList = new ArrayList<AddressVo>();
        for (Address a : addressList) {
            if (a == null) continue;
            addressVoList.add(this.transAddressToVo(a, withChild));
        }
        return addressVoList;
    }
}

