/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.member.service.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import sinosoftgz.member.model.core.CoreCompany;
import sinosoftgz.member.model.core.CoreUser;
import sinosoftgz.member.model.core.CoreUserExt;
import sinosoftgz.member.model.repository.core.CompanyRepos;
import sinosoftgz.member.model.repository.core.UserExtRepos;
import sinosoftgz.member.model.repository.core.UserRepos;
import sinosoftgz.member.model.repository.member.MemberRepos;
import sinosoftgz.member.model.shop.Member;
import sinosoftgz.member.service.service.UserService;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.data.Encodes;
import sinosoftgz.utils.data.Jsons;
import sinosoftgz.utils.data.ValidateUtil;
import sinosoftgz.utils.security.Digests;
import sinosoftgz.utils.sql.PageVo;
import sinosoftgz.utils.sql.QueryByPage;

@Transactional
@Component
public class MemberService {
    @Autowired
    EntityManager em;
    @Autowired
    MemberRepos memberRepos;
    @Autowired
    UserRepos userRepos;
    @Autowired
    CompanyRepos companyRepos;
    @Autowired
    UserExtRepos userExtRepos;
    @Autowired
    UserService userService;
    @Autowired(required=false)
    QueryByPage queryByPage;

    public Member saveMember(Member member) {
        Member entity = null;
        if (!Lang.isEmpty((Object)member)) {
            entity = (Member)this.memberRepos.save((Object)member);
        }
        return entity;
    }

    public Page<Member> findPage(PageRequest pageRequest) {
        return this.memberRepos.findAll((Pageable)pageRequest);
    }

    public boolean saveBean(String coreCompanyId, CoreUser coreUser, Member member, CoreUserExt coreUserExt) {
        CoreCompany coreCompany = (CoreCompany)this.companyRepos.findOne((Serializable)((Object)coreCompanyId));
        coreUser.setCoreCompany(coreCompany);
        if (Lang.isEmpty((Object)coreUser.getId())) {
            byte[] hashPassword = Digests.sha1((byte[])"123456".getBytes(), (byte[])"12345678abcdefgh".getBytes(), (int)1024);
            coreUser.setPassword(Encodes.encodeHex((byte[])hashPassword));
            coreUser.setUserType("member");
        }
        CoreUser coreUser1 = (CoreUser)this.userRepos.save((Object)coreUser);
        coreUserExt.setCoreUser(coreUser1);
        this.userExtRepos.save((Object)coreUserExt);
        member.setCoreUser(coreUser1);
        Member member1 = (Member)this.memberRepos.save((Object)member);
        return !Lang.isEmpty((Object)member1.getId());
    }

    public Member findById(String id) {
        return (Member)this.memberRepos.findOne((Serializable)((Object)id));
    }

    public Member findByCoreUser(CoreUser coreUser) {
        return this.memberRepos.findByCoreUser(coreUser);
    }

    public Page<Member> findPage(Date startDate, Date endDate, String name, String type, String companyId, Pageable pageable) {
        return null;
    }

    public List<Member> findMemberByOrganizationId(String organizationId) {
        List<Object> members = new ArrayList<Member>();
        if (!Lang.isEmpty((Object)organizationId)) {
            members = this.memberRepos.findMemberByOrganizationId(organizationId);
        }
        return members;
    }

    public List<Member> findMemberByOrganizationIdAndCoreUser(String organizationId, CoreUser coreUser) {
        List<Object> members = new ArrayList<Member>();
        if (!Lang.isEmpty((Object)organizationId) && !Lang.isEmpty((Object)coreUser)) {
            members = this.memberRepos.findMemberByOrganizationIdAndCoreUser(organizationId, coreUser);
        }
        return members;
    }

    public Member findMemberById(String id) {
        Member entity = null;
        if (!Lang.isEmpty((Object)id)) {
            entity = (Member)this.memberRepos.findOne((Serializable)((Object)id));
        }
        return entity;
    }

    public Page<Member> findMemberByOrganizationIdAndCoreUsers(String organizationId, List<CoreUser> coreUser, Pageable pageable) {
        return this.memberRepos.findMemberByOrganizationIdAndCoreUserInOrderByCoreUserLastUpdatedDesc(organizationId, coreUser, pageable);
    }

    public List<Member> findMemberByOrganizationIdAndCoreUsers(String organizationId, List<CoreUser> coreUser) {
        return this.memberRepos.findMemberByOrganizationIdAndCoreUserInOrderByCoreUserLastUpdatedDesc(organizationId, coreUser);
    }

    public List<Member> findMembersByCoreUsers(List<CoreUser> coreUser) {
        return this.memberRepos.findMemberByCoreUserIn(coreUser);
    }

    public PageVo findMemberPageByUserIdAndName(Integer pageSize, Integer pageNum, String userId, String searchLoginId, String memberName) {
        PageVo pageVo = null;
        String sql = "SELECT cuser.PHONE as phone,cuser.EMAIL as email,mem.IS_ADMIN,mem.IS_FIRST_LOGIN, mem.SCORE,mem.ORGANIZATION_ID, mem.REAL_NAME FROM MEMBER mem  LEFT JOIN CORE_USER cuser on mem.USER_ID=cuser.ID WHERE cuser.IS_DELETE=? and cuser.ID!=? and cuser.source=? ";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(false);
        list.add(userId);
        list.add("\u76f4\u63a5\u5bfc\u5165");
        if (!Lang.isEmpty((Object)searchLoginId)) {
            sql = ValidateUtil.isEmail((String)searchLoginId) ? sql + " AND ( cuser.EMAIL LIKE ? " : sql + " AND ( cuser.PHONE LIKE ? ";
            list.add("%" + searchLoginId + "%");
        }
        if (!Lang.isEmpty((Object)memberName)) {
            sql = !Lang.isEmpty((Object)searchLoginId) ? sql + " OR mem.REAL_NAME LIKE ? ) " : sql + " AND  mem.REAL_NAME LIKE ? ";
            list.add("%" + memberName + "%");
        } else if (!Lang.isEmpty((Object)searchLoginId)) {
            sql = sql + " ) ";
        }
        sql = sql + "  ORDER BY cuser.DATE_CREATED DESC ";
        try {
            pageVo = this.queryByPage.query(sql, pageNum, pageSize, list.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("json:" + Jsons.toJson((Object)pageVo));
        return pageVo;
    }

    public Page<Member> findPageByParams(String username, String companyId, String organizationId, Pageable pageable) {
        Member member = new Member();
        CoreUser coreUser = new CoreUser();
        coreUser.setIsDelete(Boolean.valueOf(false));
        coreUser.setUserType("member");
        coreUser.setUsername(username);
        coreUser.setDisabled(null);
        if (companyId.equals("1")) {
            coreUser.setCoreCompany(null);
        } else {
            CoreCompany coreCompany = (CoreCompany)this.companyRepos.findOne((Serializable)((Object)companyId));
            coreUser.setCoreCompany(coreCompany);
        }
        if (organizationId.equals("1")) {
            member.setOrganizationId(null);
        } else {
            member.setOrganizationId(organizationId);
        }
        member.setCoreUser(coreUser);
        ExampleMatcher matcher = ExampleMatcher.matching().withIgnoreNullValues().withMatcher("organizationId", ExampleMatcher.GenericPropertyMatcher.of((ExampleMatcher.StringMatcher)ExampleMatcher.StringMatcher.CONTAINING, (boolean)true)).withMatcher("coreUser", ExampleMatcher.GenericPropertyMatcher.of((ExampleMatcher.StringMatcher)ExampleMatcher.StringMatcher.CONTAINING, (boolean)true)).withMatcher("coreUser.username", ExampleMatcher.GenericPropertyMatcher.of((ExampleMatcher.StringMatcher)ExampleMatcher.StringMatcher.CONTAINING, (boolean)true));
        Example example = Example.of((Object)member, (ExampleMatcher)matcher);
        return this.memberRepos.findAll(example, pageable);
    }
}

